/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.pdw;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.generic.annotations.Ignore;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.pdw.ProxyDataWrapperTools;
import eu.javaexperience.reflect.Mirror;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;

public abstract class ProxyHelpedLazyImplementation<I, B extends I, R extends I> {
    protected final Set<String> backendImplMethodNames = new HashSet<String>();
    protected Class<I> interfaceClass;
    protected B lazyImplObject;
    protected Class<R> rootInterface;
    protected R root;
    protected final GetBy3<Object, B, Method, Object[]> mapper = (root, b, c) -> {
        String methodName = b.getName();
        try {
            if (this.backendImplMethodNames.contains(methodName)) {
                return this.relayApiCall((B)root, (Method)b, (Object[])c);
            }
            if ("toString".equals(methodName)) {
                return "Proxy generated ProxyHelpedLazyImplementation accessor for object: " + this.lazyImplObject + ", with class: " + root.getClass().getSimpleName();
            }
            return this.handleInterfaceCall((B)root, (Method)b, (Object[])c);
        }
        catch (Throwable e) {
            this.handleException(e);
            return null;
        }
    };

    public ProxyHelpedLazyImplementation(Class<I> interfaceClass, B lazyImplObject, Class<R> rootObjectInterface) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        AssertArgument.assertTrue(interfaceClass.isInterface(), "interfaceClass must be and interface.");
        AssertArgument.assertNotNull(lazyImplObject, "lazyImplObject");
        AssertArgument.assertTrue(rootObjectInterface.isInterface(), "rootObjectInterface must be and interface.");
        this.interfaceClass = interfaceClass;
        this.rootInterface = rootObjectInterface;
        this.lazyImplObject = lazyImplObject;
        for (Method m : lazyImplObject.getClass().getDeclaredMethods()) {
            if (null != m.getAnnotation(Ignore.class)) continue;
            this.backendImplMethodNames.add(m.getName());
        }
        this.root = this.wrapWithClass(this.rootInterface, lazyImplObject);
    }

    public abstract Object handleInterfaceCall(B var1, Method var2, Object[] var3) throws Throwable;

    protected void handleException(Throwable e) {
        Mirror.propagateAnyway(e);
    }

    public <T extends I> T createInstanceWithDefaultConstructor(Class<T> cls, B zkp) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Constructor<T> constr = cls.getConstructor(this.lazyImplObject.getClass());
        if (null == constr) {
            throw new RuntimeException("No constructor " + cls.getSimpleName() + "(" + this.lazyImplObject.getClass().getSimpleName() + " root) defined in the requested class (" + cls.getSimpleName() + ").");
        }
        return constr.newInstance(zkp);
    }

    public <T extends I> T wrapWithClass(Class<T> cls, B elem) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (cls.isInterface()) {
            return ProxyDataWrapperTools.wrapAccessor(elem, cls, this.mapper);
        }
        return this.createInstanceWithDefaultConstructor(cls, elem);
    }

    protected Object relayApiCall(B path, Method b, Object[] c) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.lazyImplObject.getClass().getDeclaredMethod(b.getName(), b.getParameterTypes()).invoke(path, c);
    }

    public R getRoot() {
        return this.root;
    }
}

