/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.proxy;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.StringTools;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;

public class TorProxySpawner {
    public final String root;
    private static String proto = "# This file was generated by Tor; if you edit it, comments will not be preserved\n# The old torrc file was renamed to torrc.orig.1 or similar, and Tor will ignore it\nControlSocket $root$/$off$/control\nDataDirectory $root$/$off$/data\n\n#9030+offset\nDirPort $dp$\n\nDirReqStatistics 0\nExitPolicy reject *:*\nLog notice stdout\nNickname Unnamed\n\n#9001+offset\nORPort $op$\n#9050+offset\nSOCKSPort $sp$\n\nPublishServerDescriptor 0\nPortForwarding 0\nRelayBandwidthBurst 524288000\nRelayBandwidthRate 524288000\n";

    public TorProxySpawner(String root) throws IOException {
        this.root = new File(root).getCanonicalFile().toString();
        AssertArgument.assertNotNull(this.root, "root_working_directory_path");
    }

    public TorProxy spawnWithOffset(int off) throws InterruptedException, IOException {
        TorProxy tp = new TorProxy();
        tp.offset = off;
        tp.setup();
        tp.start();
        if (tp.waitPortOpen(9050 + off, 30)) {
            tp.updateAccessTimeNow();
            return tp;
        }
        return null;
    }

    public static final Process exec(boolean wait, String ... args) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(args);
        Process p = pb.start();
        if (wait) {
            p.waitFor();
        }
        return p;
    }

    public static Proxy proxyForLocalPort(int port, boolean http) {
        return new Proxy(http ? Proxy.Type.HTTP : Proxy.Type.SOCKS, InetSocketAddress.createUnresolved("127.0.0.1", port));
    }

    public static TorProxySpawner runtimeThrowCreate(String path) {
        try {
            return new TorProxySpawner(path);
        }
        catch (IOException e) {
            Mirror.throwSoftOrHardButAnyway(e);
            return null;
        }
    }

    public class TorProxy
    extends AbstractProxySource {
        protected int offset;
        protected long lastAccess = 0L;
        protected Process process = null;

        public long getLastAccessTime() {
            return this.lastAccess;
        }

        public void updateAccessTimeNow() {
            this.lastAccess = System.currentTimeMillis();
        }

        public void setup() throws IOException, InterruptedException {
            String conf = StringTools.replaceAllStrings(proto, "$off$", String.valueOf(this.offset));
            conf = StringTools.replaceAllStrings(conf, "$dp$", String.valueOf(10001 + this.offset));
            conf = StringTools.replaceAllStrings(conf, "$op$", String.valueOf(12001 + this.offset));
            conf = StringTools.replaceAllStrings(conf, "$sp$", String.valueOf(9050 + this.offset));
            conf = StringTools.replaceAllStrings(conf, "$root$", TorProxySpawner.this.root);
            IOTools.putFileContent(TorProxySpawner.this.root + "/cfg" + this.offset, false, conf.getBytes());
            File r = new File(TorProxySpawner.this.root + "/" + this.offset);
            r.mkdirs();
            TorProxySpawner.exec(true, "chmod", "700", r.toString());
            new File(TorProxySpawner.this.root + "/" + this.offset + "/data").mkdir();
        }

        public void start() throws IOException, InterruptedException {
            if (null != this.process) {
                throw new RuntimeException("Tor process alredy started");
            }
            this.process = TorProxySpawner.exec(false, "tor", "-f", TorProxySpawner.this.root + "/cfg" + this.offset);
        }

        public void stop() throws InterruptedException {
            this.process.destroy();
            this.process.waitFor();
            this.process = null;
        }

        public boolean waitPortOpen(int port, int max_try) throws InterruptedException {
            boolean conn = false;
            int i = 0;
            while (!conn && i++ < max_try) {
                try {
                    Socket s = new Socket("127.0.0.1", port);
                    conn = true;
                    s.close();
                    System.out.println("proxy ready");
                    break;
                }
                catch (Exception e) {
                    System.out.println("wait");
                    Thread.sleep(500L);
                }
            }
            System.out.println(port + ". Tor proxy started: " + conn);
            return conn;
        }

        public void withinTimeOrRestart(long milisecs) throws IOException, InterruptedException {
            if (this.lastAccess + milisecs < System.currentTimeMillis()) {
                this.stop();
                this.start();
                this.waitPortOpen(9050 + this.offset, 30);
            }
        }

        @Override
        public Proxy getProxy() {
            return TorProxySpawner.proxyForLocalPort(9050 + this.offset, false);
        }

        @Override
        public int getPort() {
            return 9050 + this.offset;
        }

        @Override
        public String getAddress() {
            return "127.0.0.1";
        }

        @Override
        public Proxy.Type getType() {
            return Proxy.Type.SOCKS;
        }
    }

    public static abstract class AbstractProxySource
    implements ProxySource {
        @Override
        public Proxy getProxy() {
            return new Proxy(this.getType(), InetSocketAddress.createUnresolved(this.getAddress(), this.getPort()));
        }

        public static ProxySource createLocalSocksProxy(final int port) {
            return new AbstractProxySource(){

                @Override
                public Proxy.Type getType() {
                    return Proxy.Type.SOCKS;
                }

                @Override
                public int getPort() {
                    return port;
                }

                @Override
                public String getAddress() {
                    return "127.0.0.1";
                }
            };
        }
    }

    public static interface ProxySource {
        public String getAddress();

        public int getPort();

        public Proxy.Type getType();

        public Proxy getProxy();
    }
}

