/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.proxy;

import eu.javaexperience.proxy.ProxyStorage;
import eu.javaexperience.proxy.TorProxySpawner;
import eu.javaexperience.reflect.Mirror;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class TorSpawnerStorage
implements ProxyStorage,
Closeable {
    protected TorProxySpawner spawner;
    protected int maxProxies;
    protected ConcurrentMap<Integer, TorProxySpawner.TorProxy> proxies = new ConcurrentHashMap<Integer, TorProxySpawner.TorProxy>();
    protected long maxIdle = -1L;

    public TorSpawnerStorage(TorProxySpawner spawn, int max, long maxIdleMs) {
        this.spawner = spawn;
        this.maxProxies = max;
        this.maxIdle = maxIdleMs;
    }

    public TorSpawnerStorage(TorProxySpawner spawn, int max) {
        this(spawn, max, -1L);
    }

    @Override
    public synchronized TorProxySpawner.ProxySource getAtOffset(int i) throws IOException {
        TorProxySpawner.TorProxy tp = (TorProxySpawner.TorProxy)this.proxies.get(i);
        if (null == tp) {
            try {
                tp = this.spawner.spawnWithOffset(i);
            }
            catch (InterruptedException e) {
                Mirror.throwSoftOrHardButAnyway(e);
            }
            this.proxies.put(i, tp);
        } else if (this.maxIdle > 0L) {
            try {
                tp.withinTimeOrRestart(this.maxIdle);
                tp.updateAccessTimeNow();
            }
            catch (InterruptedException e) {
                Mirror.propagateAnyway(e);
            }
        }
        return tp;
    }

    @Override
    public int size() {
        return this.maxProxies;
    }

    @Override
    public void close() throws IOException {
        for (Map.Entry kv : this.proxies.entrySet()) {
            try {
                ((TorProxySpawner.TorProxy)kv.getValue()).stop();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

