/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.query;

import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.query.AtomicCondition;
import eu.javaexperience.query.LogicalGroup;
import eu.javaexperience.query.LogicalRelation;
import java.util.Collection;

public class QueryEvaluator<T> {
    protected GetBy2<Boolean, T, AtomicCondition> unitMatcher;

    public QueryEvaluator(GetBy2<Boolean, T, AtomicCondition> unitMatcher) {
        this.unitMatcher = unitMatcher;
    }

    public boolean eval(T element, LogicalGroup query) {
        LogicalRelation rel = query.getLogicalRelation();
        switch (rel) {
            case and: {
                for (LogicalGroup g : query.getLogicalGroups()) {
                    if (this.eval(element, g)) continue;
                    return false;
                }
                return true;
            }
            case or: {
                for (LogicalGroup g : query.getLogicalGroups()) {
                    if (!this.eval(element, g)) continue;
                    return true;
                }
                return false;
            }
            case unit: {
                return this.unitMatcher.getBy(element, query.getAtomicCondition());
            }
        }
        throw new UnimplementedCaseException(rel);
    }

    public int select(Collection<T> dst, Collection<T> from, LogicalGroup query) {
        int n = 0;
        for (T f : from) {
            if (!this.eval(f, query)) continue;
            dst.add(f);
            ++n;
        }
        return n;
    }
}

