/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.resource.pool;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.resource.pool.IssuedResource;
import eu.javaexperience.resource.pool.TrackedResourcePool;
import eu.javaexperience.semantic.references.MayNull;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TrackedLimitedResourcePool<T>
implements TrackedResourcePool<T> {
    protected final ConcurrentLinkedQueue<T> free = new ConcurrentLinkedQueue();
    protected final AtomicInteger issued = new AtomicInteger();
    protected final SimpleGet<T> factory;
    protected final int limit;
    protected final Semaphore limiter;

    @Override
    public int getIssuedResourcesCount() {
        return this.issued.get();
    }

    public TrackedLimitedResourcePool(SimpleGet<T> factory, int limit) {
        this.factory = factory;
        AssertArgument.assertNotNull(this.factory, "factory");
        this.limit = limit;
        AssertArgument.assertGreaterOrEqualsThan(this.limit, 0, "limit");
        this.limiter = new Semaphore(limit);
    }

    @Override
    public IssuedResource<T> acquireResource() throws InterruptedException {
        return this.tryAcquireResource(0L, null);
    }

    @Override
    public void releaseResource(IssuedResource<T> resource) {
        AssertArgument.assertNotNull(resource, "resource");
        if (resource.pool != this) {
            throw new IllegalArgumentException("The resource acquired from other resource pool");
        }
        this.free.add(resource.getResource());
        this.issued.decrementAndGet();
        this.limiter.release();
    }

    @Override
    public int getFreeResourcesCount() {
        return this.free.size();
    }

    @Override
    public int getResourceLimitCount() {
        return this.limit;
    }

    @Override
    @MayNull
    public IssuedResource<T> tryAcquireResource(long paramLong, TimeUnit paramTimeUnit) throws InterruptedException {
        if (paramTimeUnit == null) {
            this.limiter.acquire();
        } else if (!this.limiter.tryAcquire(paramLong, paramTimeUnit)) {
            return null;
        }
        T ret = this.free.poll();
        if (ret == null) {
            ret = this.factory.get();
        }
        this.issued.incrementAndGet();
        return new IssuedResource<T>(this, ret);
    }

    @Override
    @MayNull
    public IssuedResource<T> pollResource() {
        T ret = this.free.poll();
        if (null == ret) {
            return null;
        }
        this.issued.incrementAndGet();
        return new IssuedResource<T>(this, ret);
    }

    @Override
    public void destroyResource(IssuedResource<T> resource) {
        if (!resource.issued) {
            throw new RuntimeException("Resource released, can't be destroyed");
        }
        resource.issued = false;
        resource.resource = null;
        this.issued.decrementAndGet();
    }
}

