/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.exceptions.OperationSuccessfullyEnded;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.JavaClassRpcFunctions;
import eu.javaexperience.rpc.JavaClassRpcUnboundFunctionsInstance;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.rpc.RpcFunction;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.RpcSession;
import eu.javaexperience.rpc.RpcSessionTools;
import eu.javaexperience.rpc.SimpleRpcRequest;
import eu.javaexperience.rpc.SimpleRpcSession;
import eu.javaexperience.rpc.SocketRpcServer;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcDefaultProtocol;
import eu.javaexperience.rpc.bidirectional.RpcClientProtocolHandler;
import eu.javaexperience.rpc.bulk.MultiplexedApiCall;
import eu.javaexperience.rpc.codegen.PhpRpcInterfaceGenerator;
import eu.javaexperience.rpc.codegen.RpcSourceBuilder;
import eu.javaexperience.rpc.discover.DiscoverRpc;
import eu.javaexperience.rpc.function.RpcFunctionParameter;
import eu.javaexperience.semantic.references.MayNull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RpcTools {
    public static final RpcFacility[] emptyRpcFacilityArray = new RpcFacility[0];

    public static <C extends RpcRequest, F extends RpcFunction<C, ?>> DataObject callFunction(C ctx, F function) {
        return RpcTools.callFunction(ctx, null, function);
    }

    public static <C extends RpcRequest, F extends RpcFunction<C, ?>> DataObject callFunction(C ctx, Object javaMethodThisParam, F function) {
        RpcProtocolHandler protocol = ctx.getProtocolHandler();
        String functionName = protocol.getRequestFunctionName(ctx);
        try {
            Object thisContext = javaMethodThisParam;
            Object[] incoming = protocol.extractParameters(ctx);
            RpcFunctionParameter[] ps = function.getParameterClasses();
            Object[] callParam = new Object[Math.min(incoming.length, ps.length)];
            for (int i = 0; i < callParam.length; ++i) {
                callParam[i] = ps[i].getCaster().cast(incoming[i]);
            }
            Object result = function.call(ctx, thisContext, functionName, callParam);
            return protocol.createReturningValue(ctx, result);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return protocol.createException(ctx, e);
        }
    }

    public static DataObject wrapReturningValue(RpcRequest ctx, Object ret) {
        RpcProtocolHandler protocol = ctx.getProtocolHandler();
        return protocol.createReturningValue(ctx, ret);
    }

    public static DataObject wrapReturningValue(RpcProtocolHandler protocol, Object ret) {
        return protocol.createReturningValue(null, ret);
    }

    public static DataObject wrapException(RpcRequest ctx, Throwable ret) {
        RpcProtocolHandler protocol = ctx.getProtocolHandler();
        return protocol.createException(ctx, ret);
    }

    public static <S extends RpcSession> RpcRequest createClientInvocation(S session, long trace, Object _this, String method, Object ... args) {
        BidirectionalRpcDefaultProtocol PROTO = (BidirectionalRpcDefaultProtocol)session.getDefaultRpcProtocolHandler();
        RpcRequest req = PROTO.createClientRequest(session);
        RpcTools.fillClientInvocation(req, trace, null, _this, method, args);
        return req;
    }

    public static <S extends RpcSession> RpcRequest createClientNamespaceInvocation(S session, long trace, @MayNull String namespace, Object _this, String method, Object ... args) {
        BidirectionalRpcDefaultProtocol PROTO = (BidirectionalRpcDefaultProtocol)session.getDefaultRpcProtocolHandler();
        RpcRequest req = PROTO.createClientRequest(session);
        RpcTools.fillClientInvocation(req, trace, namespace, _this, method, args);
        return req;
    }

    public static <S extends RpcSession> void fillClientInvocation(RpcRequest req, long trace, String namspace, Object _this, String method, Object[] args) {
        RpcClientProtocolHandler PROTO = (RpcClientProtocolHandler)((Object)req.getProtocolHandler());
        PROTO.putNamespace(req, namspace);
        PROTO.putPacketTraceId(req, String.valueOf(trace));
        PROTO.putThisParameter(req, _this);
        PROTO.putRequestFunctionName(req, method);
        PROTO.putParameters(req, args);
    }

    public static <SOCK extends IOStream, SESS extends RpcSession> SocketRpcServer<SOCK, SESS> newServer(IOStreamServer<SOCK> serverSocket, int concurrency, RpcProtocolHandler proto, final GetBy2<SESS, SOCK, RpcProtocolHandler> sessionCreator, final GetBy2<DataObject, SESS, DataObject> requestHandler) {
        AssertArgument.assertNotNull(sessionCreator, "session_creator");
        AssertArgument.assertNotNull(requestHandler, "request_handler");
        return new SocketRpcServer<SOCK, SESS>(serverSocket, concurrency, proto){

            @Override
            protected SESS init(SOCK socket) {
                return (RpcSession)sessionCreator.getBy(socket, this.handler);
            }

            @Override
            @MayNull
            protected DataObject handleRequest(SESS sess, DataObject request) {
                return (DataObject)requestHandler.getBy(sess, request);
            }
        };
    }

    public static <SOCK extends IOStream, SESS extends RpcSession> SocketRpcServer<SOCK, SESS> newParallelCallServer(IOStreamServer<SOCK> serverSocket, int concurrency, RpcProtocolHandler proto, final GetBy2<SESS, SOCK, RpcProtocolHandler> sessionCreator, final GetBy2<DataObject, SESS, DataObject> requestHandler) {
        final ThreadPoolExecutor exec = new ThreadPoolExecutor(10, 300, 60L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>());
        return new SocketRpcServer<SOCK, SESS>(serverSocket, concurrency, proto){

            @Override
            protected SESS init(SOCK socket) {
                return (RpcSession)sessionCreator.getBy(socket, this.handler);
            }

            @Override
            protected void responseRequest(SimplePublish1<DataObject> response, SESS sess, DataObject request, Object extraCtx) {
                exec.execute(() -> {
                    RpcSessionTools.setCurrentRpcSession(sess);
                    try {
                        DataObject resp = this.handleRequest(sess, request);
                        if (null != resp) {
                            response.publish(resp);
                        } else {
                            System.out.println("NULL response");
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    finally {
                        RpcSessionTools.setCurrentRpcSession(null);
                    }
                });
            }

            @Override
            @MayNull
            protected DataObject handleRequest(SESS sess, DataObject request) {
                return (DataObject)requestHandler.getBy(sess, request);
            }

            @Override
            public void close() throws IOException {
                super.close();
                exec.shutdown();
            }
        };
    }

    public static <P extends RpcFunctionParameter, F extends RpcFunction<? extends RpcRequest, P>> String generatePhpRpcClass(String unitName, Collection<F> functions) {
        return RpcTools.generateRpcClassWithBuilder(PhpRpcInterfaceGenerator.BASIC_PHP_SOURCE_BUILDER, unitName, functions);
    }

    public static <P extends RpcFunctionParameter, F extends RpcFunction<? extends RpcRequest, P>> String generateRpcClassWithBuilder(RpcSourceBuilder<RpcFunctionParameter, RpcFunction<RpcRequest, RpcFunctionParameter>> builder, String unitName, Collection<F> functions) {
        return RpcTools.generateRpcClassWithBuilder(builder, unitName, functions, new HashMap<String, Object>());
    }

    public static <P extends RpcFunctionParameter, F extends RpcFunction<? extends RpcRequest, P>> String generateRpcClassWithBuilder(RpcSourceBuilder<RpcFunctionParameter, RpcFunction<RpcRequest, RpcFunctionParameter>> builder, String unitName, Collection<F> functions, Map<String, Object> settings) {
        return builder.buildRpcClientSource(unitName, functions, settings);
    }

    public static String generateRpcClassesWithBuilder(RpcSourceBuilder<RpcFunctionParameter, RpcFunction<RpcRequest, RpcFunctionParameter>> builder, Map<String, Object> settings, Map.Entry<String, JavaClassRpcFunctions<SimpleRpcRequest>> ... rpcs) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, JavaClassRpcFunctions<SimpleRpcRequest>> rpc : rpcs) {
            sb.append(RpcTools.generateRpcClassWithBuilder(builder, rpc.getKey(), rpc.getValue().getFunctionList(), settings));
        }
        return sb.toString();
    }

    public static GetBy2<SimpleRpcSession, IOStream, RpcProtocolHandler> getSimpleSessionCreator() {
        return new GetBy2<SimpleRpcSession, IOStream, RpcProtocolHandler>(){

            @Override
            public SimpleRpcSession getBy(IOStream a, RpcProtocolHandler b) {
                return new SimpleRpcSession(b);
            }
        };
    }

    public static Object extractReturnOrThrow(RpcRequest req) throws Throwable {
        RpcClientProtocolHandler hand = (RpcClientProtocolHandler)((Object)req.getProtocolHandler());
        Throwable t = hand.extractException(req);
        if (null != t) {
            throw t;
        }
        return hand.extractReturningValue(req);
    }

    public static <R extends RpcRequest> GetBy1<DataObject, R> createSimpleNamespaceDispatcher(GetBy2<DataObject, R, String> _default, Collection<RpcFacility> rpcs) {
        return RpcTools.createSimpleNamespaceDispatcher(_default, rpcs.toArray(JavaClassRpcFunctions.emptyRpcFacilityArray));
    }

    public static <R extends RpcRequest> GetBy1<DataObject, R> createSimpleNamespaceDispatcher(final GetBy2<DataObject, R, String> _default, final RpcFacility ... rpcs) {
        return new GetBy1<DataObject, R>(){

            @Override
            public DataObject getBy(R a) {
                String ns = a.getProtocolHandler().extractNamespace((RpcRequest)a);
                for (RpcFacility rpc : rpcs) {
                    if (!Mirror.equals(ns, rpc.getRpcName())) continue;
                    return rpc.dispatch(a);
                }
                if (null != _default) {
                    return (DataObject)_default.getBy(a, ns);
                }
                return null;
            }
        };
    }

    public static List<RpcFacility> wrapApis(RpcFacility ... apis) {
        ArrayList dst = new ArrayList();
        CollectionTools.copyInto(apis, dst);
        return Collections.unmodifiableList(dst);
    }

    public static GetBy1<DataObject, SimpleRpcRequest> createSimpleNamespaceDispatcherWithDiscoverApi(RpcFacility ... instances) {
        DiscoverRpc discover = new DiscoverRpc(instances);
        RpcFacility[] add = ArrayTools.arrayAppend(discover, instances);
        return RpcTools.createSimpleNamespaceDispatcher(discover, add);
    }

    public static List<RpcFacility> addMultiplexer(List<RpcFacility> apis, GetBy1<RpcRequest, DataObject> requestCreator) {
        ArrayList<RpcFacility> rpc = new ArrayList<RpcFacility>();
        CollectionTools.copyInto(apis, rpc);
        rpc.add(new JavaClassRpcUnboundFunctionsInstance<RpcRequest>((Object)new MultiplexedApiCall(apis, requestCreator), new Class[]{MultiplexedApiCall.class}){

            @Override
            public String getRpcName() {
                return "MultiplexedApiCall";
            }
        });
        return rpc;
    }

    public static void throwUnknownNamespace(String ns) {
        throw new RuntimeException("Unknown RPC namespace: " + ns);
    }

    public static abstract class RpcEndpointUnitRpcHandler<SESS extends RpcSession, REQ extends RpcRequest> {
        protected RpcProtocolHandler protocolHandler = new BidirectionalRpcDefaultProtocol(new DataObjectJsonImpl());

        public abstract DataObject receive();

        public abstract void send(DataObject var1);

        public abstract DataObject dispatch(REQ var1);

        public SESS createSession() {
            return (SESS)new SimpleRpcSession(this.protocolHandler);
        }

        public void destroySession(SESS session) {
        }

        public REQ createRequest(SESS sess, DataObject request) {
            return (REQ)new SimpleRpcRequest((RpcSession)sess, request);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            block8: {
                SESS session = this.createSession();
                RpcSessionTools.setCurrentRpcSession(session);
                try {
                    while (true) {
                        try {
                            while (true) {
                                DataObject req;
                                if (null == (req = this.receive())) {
                                    break block8;
                                }
                                DataObject ret = this.dispatch(this.createRequest(session, req));
                                if (null == ret) continue;
                                this.send(ret);
                            }
                        }
                        catch (OperationSuccessfullyEnded skk) {
                            continue;
                        }
                        break;
                    }
                }
                finally {
                    RpcSessionTools.setCurrentRpcSession(null);
                }
            }
        }
    }
}

