/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.bulk;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.rpc.bulk.BulkResult;
import java.util.Collection;
import java.util.HashSet;

public abstract class BulkOperation<K, M> {
    protected final HashSet<K> supported = new HashSet();

    public BulkOperation(K ... supported) {
    }

    public RequestedFields<K, M> readRequestedFields(K ... req) {
        RequestedFields ret = new RequestedFields(this);
        for (K r : req) {
            if (!this.isFieldSupported(r)) continue;
            ret.req.add(r);
        }
        return ret;
    }

    public boolean isFieldSupported(K r) {
        return this.supported.contains(r);
    }

    public void fillSupportedResults(Collection<K> dst) {
        CollectionTools.copyInto(this.supported, dst);
    }

    public abstract M createResult();

    public abstract BulkResult<K, M> invoke(K[] var1, Object[] var2);

    public static class RequestedFields<K, M> {
        protected BulkOperation<K, M> owner;
        protected HashSet<K> req = new HashSet();

        public RequestedFields(BulkOperation<K, M> owner) {
            this.owner = owner;
        }

        public BulkOperation<K, M> getOwner() {
            return this.owner;
        }

        public boolean needReport(K supported) {
            return this.req.contains(supported);
        }
    }
}

