/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.discover;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.collection.map.NullMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.rpc.JavaClassRpcUnboundFunctionsInstance;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.SimpleRpcRequest;
import eu.javaexperience.rpc.codegen.WellKnownRpcSourceBuilders;
import eu.javaexperience.rpc.discover.DiscoverRpcInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DiscoverRpc
extends JavaClassRpcUnboundFunctionsInstance
implements GetBy2<DataObject, SimpleRpcRequest, String>,
DiscoverRpcInterface {
    protected List<RpcFacility> facilities = new ArrayList<RpcFacility>();

    public DiscoverRpc(RpcFacility ... fs) {
        super(new Class[]{DiscoverRpcInterface.class});
        this.facilities.add(this);
        CollectionTools.copyInto(ArrayTools.withoutNulls(fs), this.facilities);
    }

    @Override
    public String[] getNamespaces() {
        String[] ret = new String[this.facilities.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.facilities.get(i).getRpcName();
        }
        return ret;
    }

    @Override
    public String help() {
        return this.getRpcName() + ": Helps you to discover the RPC API facilities.\nString help(): this help message.\nString[] getNamespaces(): returns the available namespaces.\nsource(String language, String namespace, Map<String, String> params): generates the api wrapper class for the requested language and namespace. (langs: see error message of an invalid language)";
    }

    @Override
    public String source(String language, String namespace, Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        WellKnownRpcSourceBuilders builder = EnumTools.recogniseSymbol(WellKnownRpcSourceBuilders.class, language);
        if (null == builder) {
            sb.append("Invalid target language `" + language + "` supported languages: " + ArrayTools.toString((Object[])WellKnownRpcSourceBuilders.values()));
        }
        RpcFacility fac = null;
        for (RpcFacility f : this.facilities) {
            if (!f.getRpcName().equals(namespace)) continue;
            fac = f;
            break;
        }
        if (null == fac) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append("Unknown namespace: " + namespace);
        }
        if (sb.length() > 0) {
            throw new RuntimeException(sb.toString());
        }
        if (null == params) {
            params = NullMap.instance;
        }
        return builder.getBuilder().buildRpcClientSource(fac.getRpcName(), fac.getWrappedFunctions(), params);
    }

    @Override
    protected DataObject onMethodNotFound(RpcRequest ctx, String name) {
        return ctx.getProtocolHandler().createException(ctx, new RuntimeException("Unknown function: " + name + ". You can get help in the `" + this.getRpcName() + "` namespace with the `String help()` method"));
    }

    @Override
    public boolean ping() {
        return true;
    }

    @Override
    public DataObject getBy(SimpleRpcRequest req, String ns) {
        return req.getProtocolHandler().createException(req, new RuntimeException("Unknown RPC namespace: " + ns + ". You can list the namespaces in the `" + this.getRpcName() + "` namespace with the `String[] getNamespaces()` method"));
    }
}

