/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.javaclient;

import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.NotatedCaster;
import eu.javaexperience.rpc.RpcCastTools;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.RpcTools;
import eu.javaexperience.rpc.SimpleRpcSession;
import eu.javaexperience.rpc.bidirectional.RpcClientProtocolHandler;
import eu.javaexperience.rpc.javaclient.JavaRpcParallelClient;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.url.UrlDownloadTools;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class JavaRpcClientTools {
    protected static final ConcurrentMap<String, Class> CLASS_LOOKUP = new ConcurrentHashMap<String, Class>();

    public static <T> T createApiWithIpPort(Class<T> type, String ip, int port, @MayNull String namespace, RpcProtocolHandler proto) throws IOException {
        Socket s = new Socket(ip, port);
        return JavaRpcClientTools.createApiWithSocket(type, s, namespace, proto);
    }

    public static <T> T createApiWithSocket(Class<T> type, Socket s, @MayNull String namespace, RpcProtocolHandler proto) throws IOException {
        return JavaRpcClientTools.createApiWithTxRx(type, proto.getDefaultCommunicationProtocolPrototype().newDataSender(s.getOutputStream()), proto.getDefaultCommunicationProtocolPrototype().newDataReceiver(s.getInputStream()), namespace, proto);
    }

    public static <T> T createApiWithIOAndProto(Class<T> type, IOStream io, @MayNull String namespace, RpcProtocolHandler proto) throws IOException {
        return JavaRpcClientTools.createApiWithTxRx(type, proto.getDefaultCommunicationProtocolPrototype().newDataSender(io.getOutputStream()), proto.getDefaultCommunicationProtocolPrototype().newDataReceiver(io.getInputStream()), namespace, proto);
    }

    public static <T> T createApiWithTxRx(Class<T> type, final DataSender send, final DataReceiver rec, @MayNull String namespace, RpcProtocolHandler proto) {
        return JavaRpcClientTools.createApiWithTransactionHandler(type, new GetBy1<DataObject, DataObject>(){

            @Override
            public DataObject getBy(DataObject a) {
                try {
                    send.send(a);
                    return rec.receiveDataObject();
                }
                catch (IOException e) {
                    Mirror.propagateAnyway(e);
                    return null;
                }
            }
        }, namespace, proto);
    }

    public static <T> T createApiHttp(Class<T> type, final URL url, @MayNull String namespace, RpcProtocolHandler proto) {
        return JavaRpcClientTools.createApiWithTransactionHandler(type, new GetBy1<DataObject, DataObject>(){

            @Override
            public DataObject getBy(DataObject a) {
                try {
                    return a.objectFromBlob(UrlDownloadTools.download(null, url, null, a.toBlob()));
                }
                catch (IOException e) {
                    Mirror.propagateAnyway(e);
                    return null;
                }
            }
        }, namespace, proto);
    }

    protected static Object extractReturnOrThrow(RpcRequest req, Class<?> retType, RpcProtocolHandler proto) throws Throwable {
        RpcClientProtocolHandler hand = (RpcClientProtocolHandler)((Object)req.getProtocolHandler());
        Throwable t = hand.extractException(req);
        if (null != t) {
            throw t;
        }
        Object ret = hand.extractReturningValue(req);
        return proto.extract(retType, ret);
    }

    public static <T> T createApiWithTransactionHandler(Class<T> type, final GetBy1<DataObject, DataObject> transact, final @MayNull String namespace, final RpcProtocolHandler proto) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type}, new InvocationHandler(){
            AtomicLong tid = new AtomicLong();
            SimpleRpcSession session = new SimpleRpcSession(proto);

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (null == args) {
                    args = Mirror.emptyObjectArray;
                }
                String func = method.getName();
                long id = this.tid.incrementAndGet();
                RpcRequest req = RpcTools.createClientNamespaceInvocation(this.session, id, namespace, null, method.getName(), args);
                DataObject ret = (DataObject)transact.getBy(req.getRequestData());
                req.fillResponse(ret);
                Object ex = JavaRpcClientTools.extractReturnOrThrow(req, method.getReturnType(), proto);
                if (null != ex) {
                    Object e;
                    Class<?> r = method.getReturnType();
                    if (r.isAssignableFrom(ex.getClass())) {
                        return ex;
                    }
                    NotatedCaster caster = RpcCastTools.tryCreateCaster(r);
                    if (null != caster && null != (e = caster.cast(ex))) {
                        return e;
                    }
                }
                return ex;
            }
        });
    }

    public static JavaRpcParallelClient createClientWithIpPort(String ip, int port, RpcProtocolHandler proto) throws IOException {
        Socket s = new Socket(ip, port);
        return JavaRpcClientTools.createClientWithSocket(s, proto);
    }

    public static JavaRpcParallelClient createClientWithSocket(Socket s, RpcProtocolHandler proto) throws IOException {
        return JavaRpcClientTools.createClientWithTxRx(proto.getDefaultCommunicationProtocolPrototype().newDataSender(s.getOutputStream()), proto.getDefaultCommunicationProtocolPrototype().newDataReceiver(s.getInputStream()), proto);
    }

    public static JavaRpcParallelClient createClientWithIOAndProto(IOStream io, RpcProtocolHandler proto) throws IOException {
        return JavaRpcClientTools.createClientWithTxRx(proto.getDefaultCommunicationProtocolPrototype().newDataSender(io.getOutputStream()), proto.getDefaultCommunicationProtocolPrototype().newDataReceiver(io.getInputStream()), proto);
    }

    public static JavaRpcParallelClient createClientWithTxRx(DataSender send, DataReceiver rec, RpcProtocolHandler proto) {
        return new JavaRpcParallelClient(send, rec, proto);
    }

    public static JavaRpcParallelClient createClientHttp(URL url, RpcProtocolHandler proto) {
        return new JavaRpcParallelClient(obj -> {
            try {
                UrlDownloadTools.download(null, url, null, obj.toBlob());
            }
            catch (IOException e) {
                Mirror.propagateAnyway(e);
            }
        }, () -> {
            try {
                return proto.getDefaultCommunicationProtocolPrototype().objectFromBlob(UrlDownloadTools.download(null, url, null));
            }
            catch (IOException e) {
                Mirror.propagateAnyway(e);
                return null;
            }
        }, proto);
    }
}

