/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.javaclient;

import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcDefaultProtocol;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcProtocolHandler;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class JavaRpcConnection<C> {
    protected final C connection;
    protected final BidirectionalRpcDefaultProtocol protocol;
    protected final DataSender sender;
    protected final DataReceiver receiver;
    @Deprecated
    public final GetBy1<DataObject, DataObject> transaction;

    public JavaRpcConnection(C connection, BidirectionalRpcDefaultProtocol protocol, DataSender ds, DataReceiver rec) {
        this.connection = connection;
        this.sender = ds;
        this.receiver = rec;
        this.protocol = protocol;
        this.transaction = new GetBy1<DataObject, DataObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DataObject getBy(DataObject a) {
                try {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        JavaRpcConnection.this.sender.send(a);
                        return JavaRpcConnection.this.receiver.receiveDataObject();
                    }
                }
                catch (Exception e) {
                    Mirror.propagateAnyway(e);
                    return null;
                }
            }
        };
    }

    public static JavaRpcConnection<Socket> tcpConnect(String ip, int port, BidirectionalRpcDefaultProtocol proto) throws UnknownHostException, IOException {
        Socket socket = new Socket(ip, port);
        DataReceiver rec = proto.getDefaultCommunicationProtocolPrototype().newDataReceiver(socket.getInputStream());
        DataSender send = proto.getDefaultCommunicationProtocolPrototype().newDataSender(socket.getOutputStream());
        return new JavaRpcConnection<Socket>(socket, proto, send, rec);
    }

    public BidirectionalRpcProtocolHandler getProtocol() {
        return this.protocol;
    }
}

