/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.primitives;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.functional.BoolFunctions;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.rpc.primitives.ExportableEnum;
import eu.javaexperience.rpc.primitives.SymbolDescriptor;
import eu.javaexperience.rpc.primitives.SymbolEnumSource;
import eu.javaexperience.transform.ConverterPublisher;
import java.util.Collection;

public class RpcEnumTools {
    protected static final GetBy1<Boolean, ExportableEnum> EXPORTABLE_ENUM_FILTER = new GetBy1<Boolean, ExportableEnum>(){

        @Override
        public Boolean getBy(ExportableEnum a) {
            return a.isWordwideVisible();
        }
    };

    public static SymbolDescriptor[] exportPublicEnums(Class enumClass) {
        return RpcEnumTools.exportFilteredEnums(enumClass, EXPORTABLE_ENUM_FILTER);
    }

    public static SymbolDescriptor[] exportFilteredEnums(Class enumClass, GetBy1<Boolean, ExportableEnum> ... filter_false_drop) {
        ConverterPublisher<SymbolEnumSource, SymbolDescriptor> conv = ConverterPublisher.createFromGetByWithPreFilter(SymbolDescriptor.CONVERTER, 0 == filter_false_drop.length ? BoolFunctions.always() : BoolFunctions.and(filter_false_drop));
        CollectionTools.copyInto(enumClass.getEnumConstants(), conv);
        return conv.getDestination().toArray(SymbolDescriptor.emptySymbolDescriptorArray);
    }

    public static <E extends Enum> void copyNamesToArray(Collection<E> enumVals, DataArray arr) {
        for (Enum e : enumVals) {
            arr.putString(e.name());
        }
    }
}

