/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.scheduler.periodic;

import eu.javaexperience.Global;
import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.interfaces.simple.SimpleCall;
import java.util.concurrent.atomic.AtomicReference;

public class PeriodicTask {
    protected AtomicReference<PendingTask> nextTask = new AtomicReference();
    protected volatile boolean run = false;
    protected int interval;
    protected final SimpleCall call;

    public PeriodicTask(SimpleCall call, int milisec) {
        this.call = call;
        AssertArgument.assertNotNull(this.call, "call");
        this.interval = milisec;
        AssertArgument.assertGreaterThan(this.interval, 0, "interval in milisec");
    }

    public boolean isRunning() {
        return this.run;
    }

    public void start() {
        if (this.run) {
            throw new IllegalStateException("Periodic task is already started");
        }
        PendingTask task = this.nextTask.get();
        if (task != null) {
            task.mayRun = false;
        }
        this.run = true;
        this.enqueueNew();
    }

    protected void enqueueNew() {
        this.enqueueNewWithInterval(this.interval);
    }

    protected void enqueueNewWithInterval(int interval) {
        final PendingTask ptask = new PendingTask(System.currentTimeMillis() + (long)interval);
        this.nextTask.set(ptask);
        Global.LazySingletons.timeoutJobPool().putTimoutJob(interval, new SimpleCall(){

            @Override
            public void call() {
                if (ptask.mayRun) {
                    try {
                        ptask.getCallable().call();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    PeriodicTask.this.enqueueNew();
                }
            }
        });
    }

    public void stop() {
        if (!this.run) {
            throw new IllegalStateException("Periodic task is already stopped");
        }
        this.run = false;
        PendingTask task = this.nextTask.get();
        if (task != null) {
            task.mayRun = false;
        }
    }

    public void adjustInterval(int milisec) {
        if (milisec < 0 || this.interval == milisec) {
            return;
        }
        PendingTask task = this.nextTask.get();
        if (task != null) {
            long commandTime = task.runOnTime - (long)this.interval;
            this.interval = milisec;
            if (commandTime <= System.currentTimeMillis()) {
                Global.LazySingletons.timeoutJobPool().putTimoutJob(0, new SimpleCall(){

                    @Override
                    public void call() {
                        PeriodicTask.this.call.call();
                    }
                });
                this.enqueueNew();
            } else {
                long inter = commandTime + (long)milisec - System.currentTimeMillis();
                this.enqueueNewWithInterval((int)(inter < 0L ? 0L : inter));
            }
        } else if (this.run) {
            this.enqueueNew();
        }
    }

    public class PendingTask {
        protected boolean mayRun = true;
        public final long runOnTime;

        protected PendingTask(long runOnTime) {
            this.runOnTime = runOnTime;
        }

        public SimpleCall getCallable() {
            return PeriodicTask.this.call;
        }
    }
}

