/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.scheduler.periodic;

import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingTools;

public class RepeatTask {
    protected static Logger LOG = JavaExperienceLoggingFacility.getLogger(new Loggable("RepeatAction"));
    protected SimpleCall action;
    protected volatile int interval = 1000;
    protected volatile boolean running = false;
    protected volatile long prevAction = 0L;
    protected volatile long nextAction = 0L;
    protected volatile Thread runner;

    public RepeatTask(SimpleCall action) {
        this.action = action;
    }

    public void setInterval(int interval) {
        if (interval < 0) {
            interval = 0;
        }
        this.interval = interval;
        this.nextAction = this.prevAction + (long)interval;
    }

    public int getInterval() {
        return this.interval;
    }

    protected boolean needExit(Thread t) {
        return !this.running || this.runner != t;
    }

    protected Thread createRunnerThread() {
        return new Thread(){

            @Override
            public void run() {
                block4: while (!RepeatTask.this.needExit(this)) {
                    try {
                        RepeatTask.this.action.call();
                    }
                    catch (Exception e) {
                        LoggingTools.tryLogFormatException(LOG, LogLevel.ERROR, e, "Exception occurred while executing action. `");
                    }
                    if (RepeatTask.this.needExit(this)) {
                        return;
                    }
                    RepeatTask.this.prevAction = System.currentTimeMillis();
                    RepeatTask.this.nextAction = RepeatTask.this.prevAction + (long)RepeatTask.this.interval;
                    while (true) {
                        if (System.currentTimeMillis() >= RepeatTask.this.nextAction) continue block4;
                        long sleep = Math.min(500L, RepeatTask.this.nextAction - System.currentTimeMillis());
                        try {
                            if (sleep > 0L) {
                                Thread.sleep(sleep);
                            }
                            if (!RepeatTask.this.needExit(this)) continue;
                            return;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                    break;
                }
                return;
            }
        };
    }

    public boolean start() {
        if (this.running) {
            return false;
        }
        this.prevAction = System.currentTimeMillis();
        this.nextAction = System.currentTimeMillis() + (long)this.interval;
        this.running = true;
        this.runner = this.createRunnerThread();
        this.runner.start();
        return true;
    }

    public boolean stop() {
        if (!this.running) {
            return false;
        }
        this.runner = null;
        this.running = false;
        return true;
    }

    public boolean isRunning() {
        return this.running;
    }
}

