/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.storage.warehouse.file;

import eu.javaexperience.binary.FramedPacketCutter;
import eu.javaexperience.binary.PacketFramingTools;
import eu.javaexperience.storage.warehouse.DataWarehouse;
import eu.javaexperience.storage.warehouse.DataWarehouseInput;
import eu.javaexperience.storage.warehouse.DataWarehouseOutput;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;

public class FileDataWarehouse
implements DataWarehouse<byte[]> {
    protected final File file;
    protected FileDataWarehouseOutput fout;
    protected static final byte[] PACKET_END_SEQUENCE = new byte[]{0, -1};

    public FileDataWarehouse(File f) throws IOException {
        this.file = f;
        if (!f.exists()) {
            f.createNewFile();
        }
        this.fout = new FileDataWarehouseOutput(new FileOutputStream(this.file, true));
    }

    @Override
    public DataWarehouseOutput<byte[]> openOutput() {
        return new DataWarehouseOutput<byte[]>(){
            boolean opened = true;

            protected void assertNotClosed() {
                if (!this.opened && null != FileDataWarehouse.this.fout.out) {
                    throw new RuntimeException("This DataWarehouseOutput is already closed");
                }
            }

            @Override
            public synchronized void close() throws IOException {
                this.assertNotClosed();
                this.opened = false;
            }

            @Override
            public synchronized void write(byte[] elem) throws IOException {
                this.assertNotClosed();
                FileDataWarehouse.this.fout.write(elem);
            }
        };
    }

    @Override
    public DataWarehouseInput<byte[]> openInput() throws IOException {
        return new DataWarehouseInput<byte[]>(){
            int entry = 0;
            FileInputStream fis;
            boolean opened;
            byte[] readBuff;
            protected Deque<byte[]> packets;
            protected FramedPacketCutter cutter;
            {
                this.fis = new FileInputStream(FileDataWarehouse.this.file);
                this.opened = true;
                this.readBuff = new byte[4096];
                this.packets = new LinkedList<byte[]>();
                this.cutter = new FramedPacketCutter(0, p -> this.packets.add((byte[])p));
            }

            protected void assertNotClosed() {
                if (!this.opened) {
                    throw new RuntimeException("This DataWarehouseInput is already closed");
                }
            }

            @Override
            public void close() throws IOException {
                this.assertNotClosed();
                this.fis.close();
            }

            @Override
            public synchronized byte[] read() throws EOFException, IOException {
                this.assertNotClosed();
                while (true) {
                    byte[] ret;
                    if (null != (ret = this.packets.pollLast())) {
                        ++this.entry;
                        return ret;
                    }
                    int read = 0;
                    read = this.fis.read(this.readBuff);
                    if (read < 1) {
                        return null;
                    }
                    this.cutter.feedBytes(this.readBuff, read);
                }
            }

            @Override
            public synchronized boolean isSeekSupported() {
                this.assertNotClosed();
                return false;
            }

            @Override
            public synchronized long getPosition() {
                this.assertNotClosed();
                return this.entry;
            }
        };
    }

    @Override
    public void close() throws IOException {
        this.fout.close();
    }

    protected class FileDataWarehouseOutput
    implements DataWarehouseOutput<byte[]> {
        protected FileOutputStream out;

        protected FileDataWarehouseOutput(FileOutputStream out) {
            this.out = out;
        }

        @Override
        public synchronized void close() throws IOException {
            this.out.close();
            this.out = null;
        }

        @Override
        public synchronized void write(byte[] elem) throws IOException {
            byte[] w = PacketFramingTools.optEscapeBytes(elem, (byte)0, 0);
            this.out.write(w);
            this.out.write(PACKET_END_SEQUENCE);
            this.out.flush();
        }
    }
}

