/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.text.processor;

import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.reflect.Mirror;
import java.util.HashMap;
import java.util.Map;

public class SlidingProcessor {
    protected Map<String, String> current = new HashMap<String, String>();
    protected Map<String, SlidingProcessorExaminer> examiners = new HashMap<String, SlidingProcessorExaminer>();

    public SlidingProcessor(SlidingProcessorExaminer ... examiners) {
        for (SlidingProcessorExaminer e : examiners) {
            if (this.examiners.containsKey(e.name)) {
                throw new RuntimeException("duplicated name: " + e.name);
            }
            this.examiners.put(e.name, e);
        }
    }

    public Map<String, String> getCurrentValues() {
        return this.current;
    }

    public void reset() {
        this.current.clear();
    }

    public boolean isAllFieldReady() {
        for (Map.Entry<String, SlidingProcessorExaminer> kv : this.examiners.entrySet()) {
            if (this.current.containsKey(kv.getKey())) continue;
            return false;
        }
        return true;
    }

    public void feed(String a) {
        for (Map.Entry<String, SlidingProcessorExaminer> kv : this.examiners.entrySet()) {
            kv.getValue().tryExamineAndPlace(this, a);
        }
    }

    public void fillFields(Object result) {
        Mirror.tryFillMapIntoObjectCast(this.current, result);
    }

    public static class SlidingProcessorExaminer {
        public String name;
        public GetBy1<String, String> examiner;

        public SlidingProcessorExaminer(String name, GetBy1<String, String> examiner) {
            this.name = name;
            this.examiner = examiner;
        }

        public void tryExamineAndPlace(SlidingProcessor sp, String unit) {
            String s = this.examiner.getBy(unit);
            if (null != s) {
                sp.current.put(this.name, s);
            }
        }
    }
}

