/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.time;

import eu.javaexperience.time.TimeLineElement;
import eu.javaexperience.time.TimeLineElementMerger;
import eu.javaexperience.time.TimeLineElementSplitter;
import eu.javaexperience.time.TimeLineElementUnifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public class SimpleTimeLine<T extends TimeLineElement<T>>
implements Iterable<T> {
    private T begin;
    private T end;
    private int ep = 0;

    public static <T extends TimeLineElement<T>> boolean unifyWithNextWithNextOverride(SimpleTimeLine<T> stl, T elem) {
        TimeLineElement next = (TimeLineElement)elem.next;
        if (next != null) {
            stl.delete(next);
            elem.to = next.to;
            elem.dTo = next.dTo;
            return true;
        }
        return false;
    }

    public int unifyElements(TimeLineElementUnifier<T> uni) {
        if (this.begin == null) {
            return 0;
        }
        int num = 0;
        Object el = this.begin;
        while (el != null) {
            if (((TimeLineElement)el).next != null && uni.mayUnify(el, ((TimeLineElement)el).next)) {
                ((TimeLineElement)el).to = ((TimeLineElement)((TimeLineElement)el).next).to;
                ((TimeLineElement)el).dTo = ((TimeLineElement)((TimeLineElement)el).next).dTo;
                this.internal_delete((TimeLineElement)((TimeLineElement)el).next, true);
                ++num;
                continue;
            }
            el = (TimeLineElement)((TimeLineElement)el).next;
        }
        return num;
    }

    public int mergeElements(TimeLineElementMerger<T> merger) {
        if (this.begin == null) {
            return 0;
        }
        int num = 0;
        Object el = this.begin;
        while (el != null) {
            TimeLineElement merge;
            if (((TimeLineElement)el).next != null && (merge = merger.merge((TimeLineElement)el, (TimeLineElement)((TimeLineElement)el).next)) != null) {
                if (((TimeLineElement)el).prev == null) {
                    merge.prev = null;
                    this.begin = merge;
                } else {
                    merge.prev = ((TimeLineElement)el).prev;
                }
                if (((TimeLineElement)((TimeLineElement)el).next).next == null) {
                    this.end = merge;
                    merge.next = null;
                } else {
                    merge.next = ((TimeLineElement)((TimeLineElement)el).next).next;
                }
                el = (TimeLineElement)merge.next;
                ++num;
                continue;
            }
            el = (TimeLineElement)((TimeLineElement)el).next;
        }
        return num;
    }

    public int splitElement(TimeLineElementSplitter<T> splitter, T elem) {
        if (!this.contains(elem)) {
            return 0;
        }
        int nums = 0;
        TimeLineElement[] elems = (TimeLineElement[])splitter.split(elem);
        this.internal_delete(elem, true);
        for (TimeLineElement e : elems) {
            this.add(e);
            ++nums;
        }
        return nums;
    }

    public int splitAllElement(TimeLineElementSplitter<T> splitter) {
        int num = 0;
        for (TimeLineElement e : this) {
            TimeLineElement[] elems = splitter.split(e);
            if (elems.length == 1 && elems[0] == e) continue;
            TimeLineElement next = (TimeLineElement)e.next;
            TimeLineElement prev = (TimeLineElement)e.prev;
            this.internal_delete(e, true);
            for (TimeLineElement i : elems) {
                this.fastAddBTW(prev, i, next);
                prev = i;
                ++num;
            }
        }
        return num;
    }

    public boolean delete(T elem) {
        return this.internal_delete(elem, false);
    }

    private boolean internal_delete(T elem, boolean sureContains) {
        if (this.begin != null) {
            if (elem == this.begin && this.begin == this.end) {
                this.unlinkElement(elem);
                this.end = null;
                this.begin = null;
                this.ep = 0;
                return true;
            }
            if (this.begin == elem) {
                if (((TimeLineElement)((TimeLineElement)this.begin).next).next != null) {
                    this.linkElement(null, (TimeLineElement)((TimeLineElement)this.begin).next, (TimeLineElement)((TimeLineElement)((TimeLineElement)this.begin).next).next);
                } else {
                    this.linkElement(null, (TimeLineElement)((TimeLineElement)this.begin).next, null);
                }
                this.unlinkElement(elem);
                --this.ep;
                return true;
            }
            if (elem == this.end) {
                if (((TimeLineElement)((TimeLineElement)this.end).prev).prev != null) {
                    this.linkElement((TimeLineElement)((TimeLineElement)((TimeLineElement)this.end).prev).prev, (TimeLineElement)((TimeLineElement)this.end).prev, null);
                } else {
                    this.linkElement(null, (TimeLineElement)((TimeLineElement)this.end).prev, null);
                }
                this.unlinkElement(elem);
                --this.ep;
                return true;
            }
        }
        if (sureContains || this.contains(elem)) {
            ((TimeLineElement)((TimeLineElement)elem).prev).next = ((TimeLineElement)elem).next;
            ((TimeLineElement)((TimeLineElement)elem).next).prev = ((TimeLineElement)elem).prev;
            this.unlinkElement(elem);
            --this.ep;
            return true;
        }
        return false;
    }

    public String getInconsistenty() {
        if (this.begin == this.end) {
            return "minden ok\u00e9";
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<T> elems = new ArrayList<T>();
        for (Object i = this.begin; i != this.end; i = (TimeLineElement)((TimeLineElement)i).getNext()) {
            if (i != null) {
                if (elems.contains(i)) {
                    sb.append("Dupla elem: " + i + "\n");
                } else {
                    elems.add(i);
                }
            }
            if (((TimeLineElement)i).getNext() != null) continue;
            sb.append("null menet k\u00f6zben\n");
        }
        return sb.toString();
    }

    public boolean contains(T elem) {
        if (this.begin == null) {
            return false;
        }
        Object e = this.begin;
        while (((TimeLineElement)e).next != null) {
            if (e == elem) {
                return true;
            }
            e = (TimeLineElement)((TimeLineElement)e).next;
        }
        return false;
    }

    public int cutAllBeforeElement(T elem) {
        if (this.begin == null) {
            return 0;
        }
        int num = 1;
        Object e = this.begin;
        while (((TimeLineElement)e).next != null) {
            if (e == elem) {
                this.linkElement(null, e, (TimeLineElement)((TimeLineElement)e).next);
                break;
            }
            e = (TimeLineElement)((TimeLineElement)e).next;
            ++num;
        }
        return num;
    }

    public int cutAllAfterElement(T elem) {
        if (this.end == null) {
            return 0;
        }
        int num = 1;
        Object e = this.end;
        while (((TimeLineElement)e).prev != null) {
            if (e == elem) {
                this.linkElement((TimeLineElement)((TimeLineElement)e).prev, e, null);
                break;
            }
            e = (TimeLineElement)((TimeLineElement)e).prev;
            ++num;
        }
        return num;
    }

    private boolean fastAddBTW(T prev, T disz, T next) {
        if (prev == null || next == null) {
            return this.add(disz);
        }
        if (((TimeLineElement)disz).isBTW(((TimeLineElement)prev).to, ((TimeLineElement)next).from)) {
            this.linkElement(prev, disz, next);
            ++this.ep;
            return true;
        }
        return false;
    }

    public boolean add(T elem) {
        if (this.begin == null) {
            this.linkElement(null, elem, null);
            return true;
        }
        if (((TimeLineElement)elem).isBefore((TimeLineElement<?>)this.begin)) {
            this.linkElement(null, elem, this.begin);
            return true;
        }
        if (((TimeLineElement)elem).isAfter((TimeLineElement<?>)this.end)) {
            this.linkElement(this.end, elem, null);
            return true;
        }
        if (((TimeLineElement)elem).hasCommonSectionWith((TimeLineElement<?>)this.begin)) {
            return false;
        }
        Object el = this.begin;
        while (el != null) {
            if (((TimeLineElement)elem).hasCommonSectionWith((TimeLineElement<?>)el)) {
                return false;
            }
            if (((TimeLineElement)el).next != null) {
                if (((TimeLineElement)elem).isBTW(((TimeLineElement)el).to, ((TimeLineElement)((TimeLineElement)el).next).from)) {
                    this.linkElement(el, elem, (TimeLineElement)((TimeLineElement)el).next);
                    return true;
                }
            } else {
                return false;
            }
            el = (TimeLineElement)((TimeLineElement)el).next;
        }
        System.out.println(this.toString());
        throw new IllegalStateException("Rossz implement\u00e1ci\u00f3! na ekkor mi van?");
    }

    private void unlinkElement(T elem) {
        ((TimeLineElement)elem).next = null;
        ((TimeLineElement)elem).prev = null;
    }

    private void linkElement(T prev, T midd, T next) {
        if (prev == null && next == null) {
            ((TimeLineElement)midd).prev = null;
            ((TimeLineElement)midd).next = null;
            this.begin = midd;
            this.end = midd;
        } else if (prev == null) {
            ((TimeLineElement)midd).next = next;
            ((TimeLineElement)next).prev = midd;
            ((TimeLineElement)midd).prev = null;
            this.begin = midd;
        } else if (next == null) {
            ((TimeLineElement)prev).next = midd;
            ((TimeLineElement)midd).prev = prev;
            ((TimeLineElement)midd).next = null;
            this.end = midd;
        } else {
            ((TimeLineElement)prev).next = midd;
            ((TimeLineElement)midd).next = next;
            ((TimeLineElement)next).prev = midd;
            ((TimeLineElement)midd).prev = prev;
        }
        ++this.ep;
    }

    public T getFirst() {
        return this.begin;
    }

    public T getLast() {
        return this.end;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleTimeLine\n{\n\t");
        Object el = this.begin;
        if (el != null) {
            sb.append(((TimeLineElement)el).toString());
            while ((el = (TimeLineElement)((TimeLineElement)el).next) != null) {
                sb.append("\n\t");
                sb.append(((TimeLineElement)el).toString());
            }
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    public Date getFullRangeStart() {
        if (this.begin == null) {
            return null;
        }
        return ((TimeLineElement)this.begin).getDateFrom();
    }

    public Date getFullRangeEnd() {
        if (this.end == null) {
            return null;
        }
        return ((TimeLineElement)this.end).getDateTo();
    }

    public T getElementAt(Date t) {
        Object elem = this.begin;
        long et = t.getTime();
        while (elem != null) {
            if (((TimeLineElement)elem).isIn(et)) {
                return elem;
            }
            elem = (TimeLineElement)((TimeLineElement)elem).next;
        }
        return null;
    }

    public T getFirstElementAfter(Date t) {
        Object elem = this.begin;
        long et = t.getTime();
        while (elem != null) {
            if (((TimeLineElement)elem).isAfter(et)) {
                return elem;
            }
            elem = (TimeLineElement)((TimeLineElement)elem).next;
        }
        return null;
    }

    public T getFirstElementBetween(Date from, Date to) {
        T ret = this.getFirstElementAfter(from);
        if (null == ret) {
            return null;
        }
        if (((TimeLineElement)ret).isBTW(from, to)) {
            return ret;
        }
        return null;
    }

    public T getFirstElementBetweenIntersects(Date from, Date to) {
        Object elem = this.begin;
        while (elem != null) {
            if (((TimeLineElement)elem).isIntersects(from, to)) {
                return elem;
            }
            elem = (TimeLineElement)((TimeLineElement)elem).next;
        }
        return null;
    }

    public void getElementsDurationIs(long inMilisec, Collection<T> store) {
        Object elem = this.begin;
        while (elem != null) {
            if (((TimeLineElement)elem).duration() == inMilisec) {
                store.add(elem);
            }
            elem = (TimeLineElement)((TimeLineElement)elem).next;
        }
    }

    public void getElementsDurationIsNot(long inMilisec, Collection<T> store) {
        Object elem = this.begin;
        while (elem != null) {
            if (((TimeLineElement)elem).duration() != inMilisec) {
                store.add(elem);
            }
            elem = (TimeLineElement)((TimeLineElement)elem).next;
        }
    }

    public void getElementsDurationGT(long inMilisec, Collection<T> store) {
        Object elem = this.begin;
        while (elem != null) {
            if (((TimeLineElement)elem).duration() > inMilisec) {
                store.add(elem);
            }
            elem = (TimeLineElement)((TimeLineElement)elem).next;
        }
    }

    public void getElementsDurationGTE(long inMilisec, Collection<T> store) {
        Object elem = this.begin;
        while (elem != null) {
            if (((TimeLineElement)elem).duration() >= inMilisec) {
                store.add(elem);
            }
            elem = (TimeLineElement)((TimeLineElement)elem).next;
        }
    }

    public void getElementsDurationLT(long inMilisec, Collection<T> store) {
        Object elem = this.begin;
        while (elem != null) {
            if (((TimeLineElement)elem).duration() < inMilisec) {
                store.add(elem);
            }
            elem = (TimeLineElement)((TimeLineElement)elem).next;
        }
    }

    public void getElementsDurationLTE(long inMilisec, Collection<T> store) {
        Object elem = this.begin;
        while (elem != null) {
            if (((TimeLineElement)elem).duration() <= inMilisec) {
                store.add(elem);
            }
            elem = (TimeLineElement)((TimeLineElement)elem).next;
        }
    }

    public void getElementsAfter(Date date, Collection<T> store) {
        Object elem = this.begin;
        long t0 = date.getTime();
        while (elem != null) {
            if (((TimeLineElement)elem).isAfter(t0)) {
                while (elem != null) {
                    store.add(elem);
                    elem = (TimeLineElement)((TimeLineElement)elem).next;
                }
                continue;
            }
            elem = (TimeLineElement)((TimeLineElement)elem).next;
        }
    }

    public int size() {
        return this.ep;
    }

    public T get(int n) {
        Object ret = this.getFirst();
        while (null != ret && --n >= 0) {
            ret = (TimeLineElement)((TimeLineElement)ret).next;
        }
        return ret;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private T elem;
            {
                this.elem = SimpleTimeLine.this.begin;
            }

            @Override
            public boolean hasNext() {
                return this.elem != null;
            }

            @Override
            public T next() {
                Object ret = this.elem;
                this.elem = this.elem != null ? (TimeLineElement)((TimeLineElement)this.elem).next : null;
                return ret;
            }

            @Override
            public void remove() {
                throw new IllegalStateException("nincs megval\u00f3s\u00edtva");
            }
        };
    }
}

