/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.time;

import eu.javaexperience.generic.SimpleCalculationMemorizer;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish2;
import eu.javaexperience.math.MathTools;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.time.LongInterval;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.TimeZone;

public class TimeCalc {
    private static final SimpleCalculationMemorizer<LongInterval, Integer> yearSummerRange = new SimpleCalculationMemorizer<LongInterval, Integer>(new GetBy1<LongInterval, Integer>(){

        @Override
        public LongInterval getBy(Integer a) {
            Calendar start = TimeCalc.cal();
            start.set(1, a);
            start.set(2, 2);
            start.set(5, 31);
            start.set(7, 1);
            start.set(8, -1);
            start.set(11, 2);
            start.set(12, 0);
            start.set(13, 0);
            start.set(14, 0);
            long s = start.getTimeInMillis();
            Calendar end = start;
            end.set(1, a);
            end.set(2, 9);
            end.set(7, 1);
            end.set(8, -1);
            end.set(11, 3);
            end.set(12, 0);
            end.set(13, 0);
            end.set(14, 0);
            return new LongInterval(s, end.getTimeInMillis());
        }
    });
    public static final long sec_ms = 1000L;
    public static final long minutes_ms = 60000L;
    public static final long hours_ms = 3600000L;
    public static final long day_ms = 86400000L;
    public static final long week_ms = 604800000L;
    public static final long year_ms = 31536000000L;
    public static final Date startOfTime = new Date(0L);
    public static final Date endOfTime = new Date(Long.MAX_VALUE);
    private static final ThreadLocal<Calendar> threadLocalCalendar = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };

    public static boolean isDateInSummer(Date d) {
        LongInterval in = yearSummerRange.calcuate(TimeCalc.getYearOfDate(d));
        return in.isBetween(d.getTime());
    }

    public static Date utcToHun(Date utc) {
        return new Date(TimeCalc.isDateInSummer(utc) ? utc.getTime() + 0x6DDD00L : utc.getTime() + 3600000L);
    }

    public static Date hunToUtc(Date hun) {
        return new Date(TimeCalc.isDateInSummer(hun) ? hun.getTime() - 0x6DDD00L : hun.getTime() - 3600000L);
    }

    public static int getOfDate(Date d, int Calendar_dot_prop) {
        Calendar cal = TimeCalc.cal();
        cal.setTime(d);
        return cal.get(Calendar_dot_prop);
    }

    public static boolean isStartOfDay(Date d) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        return c.get(11) == 0 && c.get(12) == 0 && c.get(14) % 1000 < 500;
    }

    public static boolean isStartOfWeek(Date d) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        return c.get(7) == 2 && c.get(11) == 0 && c.get(12) == 0 && c.get(13) == 0 && c.get(14) % 1000 < 500;
    }

    public static boolean isEndOfDay(Date d) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        return c.get(11) == 23 && c.get(12) == 59 && c.get(14) % 1000 > 500;
    }

    public static Date roundByMilisec(Date d) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        int milli = c.get(14);
        if (milli > 499) {
            c.add(14, 1000 - milli);
        } else {
            c.add(14, -milli);
        }
        return c.getTime();
    }

    public static String toStringCalendar(Date d) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\n\tCalendar.YEAR: ");
        sb.append(c.get(1));
        sb.append("\n\tCalendar.MONTH: ");
        sb.append(c.get(2));
        sb.append("\n\tCalendar.WEEK_OF_YEAR: ");
        sb.append(c.get(3));
        sb.append("\n\tCalendar.WEEK_OF_MONTH: ");
        sb.append(c.get(4));
        sb.append("\n\tCalendar.DAY_OF_MONTH: ");
        sb.append(c.get(5));
        sb.append("\n\tCalendar.DAY_OF_WEEK: ");
        sb.append(c.get(7));
        sb.append("\n\tCalendar.DAY_OF_YEAR: ");
        sb.append(c.get(6));
        sb.append("\n\tCalendar.DAY_OF_WEEK_IN_MONTH: ");
        sb.append(c.get(8));
        sb.append("\n\tCalendar.HOUR: ");
        sb.append(c.get(10));
        sb.append("\n\tCalendar.HOUR_OF_DAY: ");
        sb.append(c.get(11));
        sb.append("\n\tCalendar.MINUTE: ");
        sb.append(c.get(12));
        sb.append("\n\tCalendar.SECOND: ");
        sb.append(c.get(13));
        sb.append("\n\tCalendar.MILLISECOND: ");
        sb.append(c.get(14));
        sb.append("\n}");
        return sb.toString();
    }

    public static int getYearOfDate(Date d) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        return c.get(1);
    }

    public static String magyarHetNapRovid(Date d) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        switch (c.get(7)) {
            case 1: {
                return "V";
            }
            case 2: {
                return "H";
            }
            case 3: {
                return "K";
            }
            case 4: {
                return "Sze";
            }
            case 5: {
                return "Cs";
            }
            case 6: {
                return "P";
            }
            case 7: {
                return "Szo";
            }
        }
        return "Hiba";
    }

    public static long absWeek(Date d) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        long y = c.get(1);
        long w = c.get(3);
        if (c.get(2) == 11 && w == 1L) {
            return y * 52L + 53L;
        }
        return y * 52L + w;
    }

    public static int absHourMinOfDay(Date time) {
        Calendar c = TimeCalc.cal();
        c.setTime(time);
        return c.get(11) * 60 + c.get(12);
    }

    public static long durationInThisWeek(Date base, Date from, Date to) {
        long b = TimeCalc.absWeek(base);
        long f = TimeCalc.absWeek(from);
        long t = TimeCalc.absWeek(to);
        if (f == b && b == t) {
            return to.getTime() - from.getTime();
        }
        if (b == f) {
            return TimeCalc.actionInThisWeek(from, to);
        }
        if (b == t) {
            return TimeCalc.duration(from.getTime(), to.getTime()) - TimeCalc.actionInThisWeek(from, to);
        }
        return -1L;
    }

    public static Date setTodayTime(Date day, int hour, int min, int sec, int milis) {
        Calendar c = TimeCalc.cal();
        c.setTime(day);
        c.set(11, hour);
        c.set(12, min);
        c.set(13, sec);
        c.set(14, milis);
        return c.getTime();
    }

    public static boolean hasCommonSectionWith(long from1, long to1, long from2, long to2) {
        return from1 <= to2 && to2 <= to1 || from1 <= from2 && from2 <= to1;
    }

    public static long union(long from1, long to1, long from2, long to2) {
        long min = from1 > from2 ? from1 : from2;
        long max = to1 > to2 ? to2 : to1;
        long ret = max - min;
        return ret < 0L ? 0L : ret;
    }

    public static boolean isBTW(Date min, Date toCheck, Date max) {
        return toCheck.after(min) && toCheck.before(max);
    }

    public static Date addToDate(Date d, int year, int month, int day, int hour, int min, int sec, int milisec) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        if (year != 0) {
            c.set(1, c.get(1) + year);
        }
        if (month != 0) {
            c.set(2, c.get(2) + month);
        }
        if (day != 0) {
            c.set(6, c.get(6) + day);
        }
        if (hour != 0) {
            c.set(11, c.get(11) + hour);
        }
        if (min != 0) {
            c.set(12, c.get(12) + min);
        }
        if (sec != 0) {
            c.set(13, c.get(13) + sec);
        }
        if (milisec != 0) {
            c.set(14, c.get(14) + milisec);
        }
        return c.getTime();
    }

    public static Date setToDate(Date d, int year, int month, int day, int hour, int min, int sec, int milisec) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        if (year > -1) {
            c.set(1, year);
        }
        if (month > -1) {
            c.set(2, month);
        }
        if (day > -1) {
            c.set(5, day);
        }
        if (hour > -1) {
            c.set(11, hour);
        }
        if (min > -1) {
            c.set(12, min);
        }
        if (sec > -1) {
            c.set(13, sec);
        }
        if (milisec > -1) {
            c.set(14, milisec);
        }
        return c.getTime();
    }

    public static Date date(int year, int month, int day, int hour, int min, int sec, int milisec) {
        Calendar c = TimeCalc.cal();
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        c.set(11, hour);
        c.set(12, min);
        c.set(13, sec);
        c.set(14, milisec);
        return c.getTime();
    }

    public static Date dateUtc(int year, int month, int day, int hour, int min, int sec, int milisec) {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.set(1, year);
        c.set(2, month - 1);
        c.set(5, day);
        c.set(11, hour);
        c.set(12, min);
        c.set(13, sec);
        c.set(14, milisec);
        return c.getTime();
    }

    public static String durationToHourMin(long dt) {
        return dt / 3600000L + ":" + TimeCalc.leading0IgNeeded(StringTools.untilTerminator(String.valueOf((double)(dt % 3600000L) / 60000.0), '.'));
    }

    public static String durationToHourMinSec(long dt) {
        return dt / 3600000L + ":" + TimeCalc.leading0IgNeeded(StringTools.untilTerminator(String.valueOf((double)(dt % 3600000L) / 60000.0), '.')) + ":" + TimeCalc.leading0IgNeeded(StringTools.untilTerminator(String.valueOf((double)(dt % 60000L) / 1000.0), '.'));
    }

    public static CharSequence leading0IgNeeded(CharSequence str) {
        if (str.length() == 1) {
            return "0" + str;
        }
        return str;
    }

    public static long absDay(Date d) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        int y = c.get(1);
        return (long)(y * 365) + (long)c.get(6) + (long)((y - 1) / 4);
    }

    public static int absMonth(Date d) {
        Calendar c = TimeCalc.cal();
        c.setTime(d);
        return c.get(1) * 12 + (c.get(2) + 1);
    }

    public static Date absDayToDate(long absDay) {
        int y = (int)(absDay / 365L);
        int d = (int)(absDay % 365L - (long)((y - 1) / 4));
        return TimeCalc.date(y, 1, d, 0, 0, 0, 0);
    }

    public static boolean dateEqualsByUnits(Date d1, Date d2, boolean year, boolean month, boolean day, boolean hour, boolean minute, boolean secound, boolean ms) {
        if (year && TimeCalc.getOfDate(d1, 1) != TimeCalc.getOfDate(d2, 1)) {
            return false;
        }
        if (month && TimeCalc.getOfDate(d1, 2) != TimeCalc.getOfDate(d2, 2)) {
            return false;
        }
        if (day && TimeCalc.getOfDate(d1, 5) != TimeCalc.getOfDate(d2, 5)) {
            return false;
        }
        if (hour && TimeCalc.getOfDate(d1, 11) != TimeCalc.getOfDate(d2, 11)) {
            return false;
        }
        if (minute && TimeCalc.getOfDate(d1, 12) != TimeCalc.getOfDate(d2, 12)) {
            return false;
        }
        if (secound && TimeCalc.getOfDate(d1, 13) != TimeCalc.getOfDate(d2, 13)) {
            return false;
        }
        return !ms || TimeCalc.getOfDate(d1, 14) == TimeCalc.getOfDate(d2, 14);
    }

    public static void main(String[] args) {
    }

    public static long durationInThisDay(Date base, Date from, Date to) {
        long b = TimeCalc.absDay(base);
        long f = TimeCalc.absDay(from);
        long t = TimeCalc.absDay(to);
        if (f == b && b == t) {
            return to.getTime() - from.getTime();
        }
        if (b == f) {
            return TimeCalc.actionInThisDay(from, to);
        }
        if (b == t) {
            return TimeCalc.duration(from.getTime(), to.getTime()) - TimeCalc.actionInThisDay(from, to);
        }
        return -1L;
    }

    public static long actionInThisDay(Date t0, Date to) {
        Calendar c = TimeCalc.cal();
        c.setTime(t0);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime().getTime() - t0.getTime();
    }

    public static Date dec(Date d) {
        return new Date(d.getTime() - 1L);
    }

    public static Date inc(Date d) {
        return new Date(d.getTime() + 1L);
    }

    public static long actionInThisWeek(Date t0, Date to) {
        Calendar c = TimeCalc.cal();
        c.setTime(t0);
        c.set(7, 1);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime().getTime() - t0.getTime();
    }

    public static boolean isAfterNthWeek(Date t0, Date now, int plusWeeks) {
        return TimeCalc.absWeek(t0) < TimeCalc.absWeek(now) + (long)plusWeeks;
    }

    public static boolean isAfterNthDay(Date t0, Date now, int plusDays) {
        return TimeCalc.absDay(t0) < TimeCalc.absDay(now) + (long)plusDays;
    }

    public static boolean isNextWeek(Date t0, Date now) {
        return TimeCalc.isAfterNthWeek(t0, now, 0);
    }

    public static boolean isNextDay(Date t0, Date now) {
        return TimeCalc.isAfterNthDay(t0, now, 0);
    }

    public static long duration(long t0, long t1) {
        return t1 - t0;
    }

    public static Date firstDayOfMonth(Date date) {
        Calendar c = TimeCalc.cal();
        c.setTime(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date lastDayOfMonth(Date date) {
        Calendar c = TimeCalc.cal();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    private static Calendar cal() {
        return threadLocalCalendar.get();
    }

    public static Date firstDayOfWeek(Date date) {
        Calendar c = TimeCalc.cal();
        c.setTime(date);
        c.set(7, 2);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date lastDayOfWeek(Date date) {
        Calendar c = TimeCalc.cal();
        c.setTime(date);
        c.set(7, 1);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Date startOfDay(Date date) {
        Calendar c = TimeCalc.cal();
        c.setTime(date);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date endOfDay(Date date) {
        Calendar c = TimeCalc.cal();
        c.setTime(date);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
        return c.getTime();
    }

    public static Date startOfMonth(Date date) {
        Calendar c = TimeCalc.cal();
        c.setTime(date);
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date endOfMonth(Date date) {
        date = TimeCalc.startOfMonth(date);
        return TimeCalc.addToDate(date, 0, 1, 0, 0, 0, 0, -1);
    }

    public static boolean isBetween(Date from, Date date, Date to) {
        long d = date.getTime();
        return from.getTime() <= d && d <= to.getTime();
    }

    public static long getDurationFromDayStartMs(Date time) {
        return (long)TimeCalc.absHourMinOfDay(time) * 60000L;
    }

    public static long getDurationBetween(Date in_from, Date in_to, Date subject_from, Date subject_to) {
        return TimeCalc.union(in_from.getTime(), in_to.getTime(), subject_from.getTime(), subject_to.getTime());
    }

    public static Date max(Date t1, Date t2) {
        return t1.getTime() > t2.getTime() ? t1 : t2;
    }

    public static Date min(Date t1, Date t2) {
        return t1.getTime() < t2.getTime() ? t1 : t2;
    }

    public static long duration(Date start, Date end) {
        return TimeCalc.duration(start.getTime(), end.getTime());
    }

    public static boolean dateEqualsByUnits(Date nap, int year, int month, int day, int hour, int min, int sec, int ms) {
        return TimeCalc.dateEqualsByUnits(nap, TimeCalc.date(MathTools.clamp(0, year, Integer.MAX_VALUE), MathTools.clamp(0, month, Integer.MAX_VALUE), MathTools.clamp(0, day, Integer.MAX_VALUE), MathTools.clamp(0, hour, Integer.MAX_VALUE), MathTools.clamp(0, min, Integer.MAX_VALUE), MathTools.clamp(0, sec, Integer.MAX_VALUE), MathTools.clamp(0, ms, Integer.MAX_VALUE)), year > -1, month > -1, day > -1, hour > -1, min > -1, sec > -1, ms > -1);
    }

    public static <T> Date[] minMaxDateFromTo(Collection<T> fs, SimplePublish2<T, Date[]> examiner) {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        Date[] ds = new Date[2];
        for (T f : fs) {
            ds[1] = null;
            ds[0] = null;
            examiner.publish(f, ds);
            long from = Long.MAX_VALUE;
            long to = Long.MIN_VALUE;
            if (null != ds[0]) {
                from = ds[0].getTime();
            }
            if (null != ds[1]) {
                to = ds[1].getTime();
            }
            if (from < min) {
                min = from;
            }
            if (to <= max) continue;
            max = to;
        }
        if (min != Long.MAX_VALUE && max != Long.MIN_VALUE) {
            return new Date[]{new Date(min), new Date(max)};
        }
        return null;
    }

    public static <T> Date[] minMaxDateTimePoints(Collection<T> fs, final GetBy1<Date, T> examiner) {
        return TimeCalc.minMaxDateFromTo(fs, new SimplePublish2<T, Date[]>(){

            @Override
            public void publish(T a, Date[] b) {
                b[0] = b[1] = (Date)examiner.getBy(a);
            }
        });
    }

    public static boolean isLeapYear(int year) {
        return year % 100 == 0 && year % 400 == 0 || year % 100 > 0 && year % 4 == 0;
    }
}

