/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.url;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.url.UrlTools;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;

public class UrlBuilder
implements Cloneable {
    protected int defaultPort;
    protected String protocol = "url";
    protected String user;
    protected int port;
    protected ArrayList<String> domain = new ArrayList();
    protected ArrayList<String> path = new ArrayList();
    protected Map<String, String[]> params;

    public UrlBuilder() {
    }

    public UrlBuilder(String url) {
        this.process(url);
    }

    private void process(String url) {
        try {
            this.process(new URL(url));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public UrlBuilder(URL url) {
        this.process(url);
    }

    public UrlBuilder(String protocol, String user, String domain, int port, int defaultPort, String path, String params) {
        this.process(protocol, user, domain, port, defaultPort, path, params);
    }

    public UrlBuilder(String protocol, String user, String domain, int port, int defaultPort, String path, Map<String, String[]> params) {
        this.process(protocol, user, domain, port, defaultPort, path, params);
    }

    protected void process(URL url) {
        this.process(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort() == -1 ? url.getDefaultPort() : url.getPort(), url.getDefaultPort(), url.getPath(), url.getQuery());
    }

    protected void process(String protocol, String user, String domain, int port, int defaultPort, String path, String params) {
        this.process(protocol, user, domain, port, defaultPort, path, params == null ? null : UrlTools.resolvMap(params));
    }

    private void process(String protocol, String user, String domain, int port, int defaultPort, String path, Map<String, String[]> params) {
        this.protocol = protocol;
        this.user = user;
        this.port = port;
        this.defaultPort = defaultPort;
        this.setDomain(domain);
        this.setPath(path);
        this.params = null == params ? new SmallMap() : params;
    }

    public UrlBuilder setProtocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public UrlBuilder setPort(int port) {
        this.port = port;
        return this;
    }

    public String[] getPathSegments() {
        return this.path.toArray(Mirror.emptyStringArray);
    }

    public UrlBuilder setPathSegments(String[] arr) {
        this.path.clear();
        arr = ArrayTools.copy(arr);
        UrlTools.modifyUrlDecode(arr);
        CollectionTools.copyInto(arr, this.path);
        return this;
    }

    public UrlBuilder setPath(String path) {
        String[] paths = StringTools.whitoutNullAndEmptyString(UrlTools.pathSplit.split(path));
        UrlTools.modifyUrlDecode(paths);
        this.path.clear();
        CollectionTools.copyInto(paths, this.path);
        return this;
    }

    public UrlBuilder setDomain(String domain) {
        this.domain.clear();
        CollectionTools.copyReverseInto(UrlTools.domSplit.split(domain), this.domain);
        return this;
    }

    public UrlBuilder withAddedParameter(String key, String value) {
        String[] arr = this.params.get(key);
        if (null == key || null == arr) {
            this.params.put(key, new String[]{value});
            return this;
        }
        this.params.put(key, ArrayTools.arrayAppend(value, arr));
        return this;
    }

    public UrlBuilder withoutParameterValue(String key, String value) {
        String[] vals = this.params.get(key);
        if (null != vals && ArrayTools.contains(vals, value)) {
            this.params.put(key, ArrayTools.whitoutElement(vals, value));
        }
        return this;
    }

    public UrlBuilder clone() {
        UrlBuilder ret = new UrlBuilder();
        ret.defaultPort = this.defaultPort;
        ret.protocol = this.protocol;
        ret.user = this.user;
        ret.port = this.port;
        ret.domain = new ArrayList<String>(this.domain);
        ret.path = new ArrayList<String>(this.path);
        ret.params = new SmallMap<String, String[]>(this.params);
        return ret;
    }

    public UrlBuilder withoutParameters() {
        this.params.clear();
        return this;
    }

    public Map<String, String[]> getParams() {
        return this.params;
    }

    public void renderHost(Appendable sb) {
        try {
            for (int i = this.domain.size() - 1; i >= 0; --i) {
                if (i != this.domain.size() - 1) {
                    sb.append(".");
                }
                sb.append(this.domain.get(i));
            }
        }
        catch (Exception e) {
            Mirror.propagateAnyway(e);
        }
    }

    public String getUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.protocol);
        sb.append("://");
        this.renderHost(sb);
        if (this.port > 1 && this.port != this.defaultPort) {
            sb.append(":");
            sb.append(this.port);
        }
        for (String s : this.path) {
            sb.append("/");
            sb.append(s);
        }
        UrlTools.renderRequestParams(this.params, sb);
        return sb.toString();
    }

    public UrlBuilder withExactParameters(Map<String, String[]> params) {
        this.params = params;
        return this;
    }

    public String getParameter(String name) {
        String[] arr = this.params.get(name);
        if (null != arr && arr.length > 0) {
            return arr[0];
        }
        return null;
    }

    public String getHost() {
        StringBuilder sb = new StringBuilder();
        this.renderHost(sb);
        return sb.toString();
    }
}

