/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.url;

import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.proxy.ProxyStorage;
import eu.javaexperience.proxy.TorProxySpawner;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.semantic.references.MayNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class UrlDownloadTools {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger(new Loggable("UrlDownloadTools"));

    public static byte[] download(String url) throws MalformedURLException, IOException {
        return UrlDownloadTools.download(url, null);
    }

    public static byte[] download(String url, @MayNull Map<String, String> headers) throws MalformedURLException, IOException {
        return UrlDownloadTools.download(url, headers, null);
    }

    public static byte[] download(Proxy proxy, String url, @MayNull Map<String, String> headers) throws MalformedURLException, IOException {
        return UrlDownloadTools.download(proxy, url, headers, null);
    }

    public static byte[] download(String url, @MayNull Map<String, String> headers, String post_data) throws MalformedURLException, IOException {
        return UrlDownloadTools.download(null, new URL(url), headers, -1, null == post_data ? null : post_data.getBytes());
    }

    public static byte[] download(Proxy proxy, String url, @MayNull Map<String, String> headers, String post_data) throws MalformedURLException, IOException {
        return UrlDownloadTools.download(proxy, new URL(url), headers, -1, null == post_data ? null : post_data.getBytes());
    }

    public static byte[] download(URL url, Map<String, String> headers) throws IOException {
        return UrlDownloadTools.download(null, url, headers, -1, null);
    }

    public static byte[] download(Proxy proxy, URL url, Map<String, String> headers) throws IOException {
        return UrlDownloadTools.download(proxy, url, headers, -1, null);
    }

    public static byte[] download(Proxy proxy, URL url, Map<String, String> headers, byte[] POST_data) throws IOException {
        return UrlDownloadTools.download(proxy, url, headers, 60000, POST_data);
    }

    public static byte[] download(Proxy proxy, URL url, Map<String, String> headers, int timeoutMs, byte[] POST_data) throws IOException {
        Throwable throwable;
        URLConnection connection = null;
        connection = null == proxy ? url.openConnection() : url.openConnection(proxy);
        if (timeoutMs > 0) {
            connection.setConnectTimeout(timeoutMs);
        }
        if (null != headers) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                if (null == header.getValue()) continue;
                connection.addRequestProperty(header.getKey(), header.getValue());
            }
        }
        if (null != POST_data) {
            connection.addRequestProperty("Content-Length", String.valueOf(POST_data.length));
            connection.setDoOutput(true);
            throwable = null;
            try (OutputStream os = connection.getOutputStream();){
                if (null != POST_data) {
                    os.write(POST_data);
                    os.flush();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        throwable = null;
        try (InputStream is = connection.getInputStream();){
            int ep = 0;
            int read = 0;
            byte[] ret = new byte[10240];
            while ((read = is.read(ret, ep, ret.length - ep)) >= 0) {
                if (ep + read == ret.length) {
                    ret = Arrays.copyOf(ret, ret.length * 2);
                }
                ep += read;
            }
            HttpURLConnection conn = (HttpURLConnection)connection;
            int status = conn.getResponseCode();
            if (status == 302 || status == 301 || status == 303) {
                byte[] byArray = UrlDownloadTools.download(proxy, new URL(conn.getHeaderField("Location")), headers, timeoutMs, POST_data);
                return byArray;
            }
            byte[] byArray = Arrays.copyOf(ret, ep);
            return byArray;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    public static HttpRequestResult httpDownload(Proxy proxy, URL url, Map<String, String> headers, byte[] POST_data) throws IOException {
        return UrlDownloadTools.httpDownload(proxy, url, headers, 0, POST_data);
    }

    public static HttpRequestResult httpDownload(Proxy proxy, URL url, Map<String, String> headers, int timeoutMs, byte[] POST_data) throws IOException {
        URLConnection connection = null;
        connection = null == proxy ? url.openConnection() : url.openConnection(proxy);
        if (timeoutMs > 0) {
            connection.setConnectTimeout(timeoutMs);
        }
        if (null != headers) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                if (null == header.getValue()) continue;
                connection.addRequestProperty(header.getKey(), header.getValue());
            }
        }
        if (null != POST_data) {
            Map.Entry<String, String> header;
            connection.addRequestProperty("Content-Length", String.valueOf(POST_data.length));
            connection.setDoOutput(true);
            OutputStream os = connection.getOutputStream();
            header = null;
            try {
                if (null != POST_data) {
                    os.write(POST_data);
                    os.flush();
                }
            }
            catch (Throwable throwable) {
                header = throwable;
                throw throwable;
            }
            finally {
                if (os != null) {
                    if (header != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)((Object)header)).addSuppressed(throwable);
                        }
                    } else {
                        os.close();
                    }
                }
            }
        }
        HttpURLConnection httpConn = (HttpURLConnection)connection;
        HttpRequestResult res = new HttpRequestResult();
        res.responseCode = httpConn.getResponseCode();
        res.headers = httpConn.getHeaderFields();
        try {
            res.responseStatus = res.headers.get(null).get(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try (InputStream is = 200 == res.responseCode ? httpConn.getInputStream() : httpConn.getErrorStream();){
            if (null != is) {
                int ep = 0;
                int read = 0;
                byte[] ret = new byte[10240];
                while ((read = is.read(ret, ep, ret.length - ep)) > 0) {
                    if (ep + read == ret.length) {
                        ret = Arrays.copyOf(ret, ret.length * 2);
                    }
                    ep += read;
                }
                res.data = Arrays.copyOf(ret, ep);
            } else {
                res.data = Mirror.emptyByteArray;
            }
        }
        return res;
    }

    public static void downloadPagesIntoParallelWithProxies(Map<String, byte[]> dst, Collection<String> src, ProxyStorage spawnerStorage, int proxies, int concurrency, boolean skip_exists) {
        UrlDownloadTools.downloadPagesIntoParallelWithProxies(null, dst, src, null, spawnerStorage, proxies, concurrency, skip_exists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadPagesIntoParallelWithProxies(final @MayNull GetBy2<byte[], Proxy, URL> downloader, final Map<String, byte[]> dst, Collection<String> src, final @MayNull Map<String, String> headers, final ProxyStorage spawnerStorage, final int proxies, int concurrency, final boolean skip_exists) {
        final LinkedBlockingQueue<String> urls_queue = new LinkedBlockingQueue<String>();
        urls_queue.addAll(src);
        final AtomicInteger nums = new AtomicInteger(concurrency);
        int i = 0;
        while (i < concurrency) {
            final int thread_ordinal = i++;
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String toDownload = null;
                        while (null != (toDownload = (String)urls_queue.poll())) {
                            if (skip_exists && dst.containsKey(toDownload)) continue;
                            try {
                                long t0 = System.currentTimeMillis();
                                byte[] data = null;
                                int try_count = 10;
                                int i = 0;
                                while (true) {
                                    block12: {
                                        try {
                                            TorProxySpawner.ProxySource tp = spawnerStorage.getAtOffset(thread_ordinal % proxies);
                                            Proxy p = tp.getProxy();
                                            data = null == downloader ? UrlDownloadTools.download(p, toDownload, (Map<String, String>)headers) : (byte[])downloader.getBy(p, new URL(toDownload));
                                            if (null != data) {
                                            }
                                            break block12;
                                        }
                                        catch (Exception e) {
                                            if (10 != i) break block12;
                                            LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.WARNING, "Can't download URL \"%s\" %s", (Object)toDownload, (Object)e.getMessage());
                                        }
                                        break;
                                    }
                                    ++i;
                                }
                                if (null == data) continue;
                                LoggingTools.tryLogFormat(LOG, (LoggingDetailLevel)LogLevel.MEASURE, "Url download \"%s\" took %s ms", (Object)toDownload, (Object)(System.currentTimeMillis() - t0));
                                dst.put(toDownload, data);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    AtomicInteger atomicInteger = nums;
                    synchronized (atomicInteger) {
                        nums.decrementAndGet();
                        nums.notifyAll();
                    }
                }
            }.start();
        }
        AtomicInteger atomicInteger = nums;
        synchronized (atomicInteger) {
            while (0 != nums.get()) {
                try {
                    nums.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void disableSslVerification() {
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
    }

    public static class HttpRequestResult {
        public String responseStatus;
        public int responseCode;
        public byte[] data;
        public Map<String, List<String>> headers;
    }
}

