/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.url;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.reflect.Mirror;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class UrlTools {
    public static final Pattern domSplit = Pattern.compile("\\.");
    public static final Pattern pathSplit = Pattern.compile("/+");

    private UrlTools() {
    }

    public static void modifyUrlDecode(String[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = URLDecoder.decode(arr[i]);
        }
    }

    public static Map<String, String[]> resolvMap(String params) {
        String[] pairs = params.split("&");
        SmallMap<String, String[]> ret = new SmallMap<String, String[]>();
        for (String pair : pairs) {
            String[] add;
            String value;
            int idx = pair.indexOf("=");
            String key = idx > 0 ? pair.substring(0, idx) : pair;
            String string = value = idx > 0 && pair.length() > idx + 1 ? pair.substring(idx + 1) : "";
            if (null != value) {
                value = URLDecoder.decode(value);
            }
            if (null == (add = (String[])ret.get(key))) {
                add = new String[]{value};
            } else {
                add = Arrays.copyOf(add, add.length + 1);
                add[add.length - 1] = value;
            }
            ret.put(key, add);
        }
        return ret;
    }

    public static Map<String, String> convMapMulti(Map<String, String[]> map) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, String[]> kv : map.entrySet()) {
            if (kv.getValue() == null || kv.getValue().length <= 0) continue;
            ret.put(kv.getKey(), kv.getValue()[0]);
        }
        return ret;
    }

    public static void fillMultiMap(Map<String, String> dst, Map<String, String[]> map) {
        for (Map.Entry<String, String[]> kv : map.entrySet()) {
            if (kv.getValue() == null || kv.getValue().length <= 0) continue;
            dst.put(kv.getKey(), kv.getValue()[0]);
        }
    }

    public static Map<String, String> convMap(Map<String, String> map) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (Map.Entry<String, String> kv : map.entrySet()) {
            if (kv.getValue() == null) continue;
            ret.put(kv.getKey(), kv.getValue());
        }
        return ret;
    }

    public static void processArgsRequest(String line, Map<String, String[]> target) throws UnsupportedEncodingException {
        String[] pairs;
        if ("".equals(line)) {
            return;
        }
        for (String pair : pairs = line.split("&")) {
            int idx = pair.indexOf("=");
            String key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), "UTF-8") : pair;
            String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), "UTF-8") : "";
            UrlTools.putParam(target, key, value);
        }
    }

    public static void putParam(Map<String, String[]> map, String key, String value) {
        String[] in = map.get(key);
        if (in == null) {
            map.put(key, new String[]{value});
        } else {
            map.put(key, ArrayTools.arrayAppend(in, value));
        }
    }

    public static String getParam(Map<String, String[]> map, String key) {
        return UrlTools.optParam(map, key, null);
    }

    public static String optParam(Map<String, String[]> map, String key, String def) {
        String[] ks = map.get(key);
        if (ks == null) {
            return def;
        }
        if (ks.length > 0) {
            return ks[0];
        }
        return def;
    }

    public static String renderRequestParams(Map<String, Object> params) {
        StringBuilder sb = new StringBuilder();
        UrlTools.renderRequestParams(params, sb);
        return sb.toString();
    }

    public static void renderRequestParams(Map<String, ? extends Object> params, Appendable app) {
        if (null == params || params.size() == 0) {
            return;
        }
        try {
            boolean nfirst = false;
            app.append("?");
            for (Map.Entry<String, ? extends Object> kv : params.entrySet()) {
                String k = kv.getKey();
                Object val = kv.getValue();
                if (null == k) continue;
                if (nfirst) {
                    app.append("&");
                }
                nfirst = true;
                if (val instanceof String[]) {
                    for (String s : (String[])val) {
                        UrlTools.appendParam(app, k, s);
                    }
                    continue;
                }
                if (val instanceof String) {
                    UrlTools.appendParam(app, k, (String)val);
                    continue;
                }
                if (null == val) {
                    UrlTools.appendParam(app, k, null);
                    continue;
                }
                UrlTools.appendParam(app, k, val.toString());
            }
        }
        catch (Exception e) {
            Mirror.throwSoftOrHardButAnyway(e);
        }
    }

    public static void appendParam(Appendable app, String key, String val) throws IOException {
        app.append(key);
        if (null != val && val.length() > 0) {
            app.append("=");
            app.append(URLEncoder.encode(val));
        }
    }
}

