/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multilang;

import eu.javaexperience.cli.CliEntry;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.collection.map.MultiMap;
import eu.javaexperience.csv.SillyCSVFormatReader;
import eu.javaexperience.csv.SimpleCSVOutput;
import eu.javaexperience.database.ConnectionCreator;
import eu.javaexperience.database.JDBC;
import eu.javaexperience.database.annotations.Indexed;
import eu.javaexperience.database.annotations.Length;
import eu.javaexperience.database.annotations.Type;
import eu.javaexperience.database.impl.UsualDbModel;
import eu.javaexperience.database.jdbc.Id;
import eu.javaexperience.database.mysql.MysqlIndexTools;
import eu.javaexperience.database.mysql.TableIndex;
import eu.javaexperience.database.pojodb.Model;
import eu.javaexperience.database.pojodb.SqlDatabase;
import eu.javaexperience.database.pojodb.dialect.MysqlDialect;
import eu.javaexperience.database.pojodb.dialect.SqlDialect;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish5;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.multithread.MultithreadingTools;
import eu.javaexperience.process.ProcessTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.text.StringTools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class TranslationCollector {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("TranslationCollector"));
    protected static ThreadPoolExecutor EXEC = new ThreadPoolExecutor(4, 4, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    protected static final ThreadLocal<CsvRender> CSV_RENDER = new ThreadLocal<CsvRender>(){

        @Override
        protected CsvRender initialValue() {
            return new CsvRender();
        }
    };
    public static final CliEntry<Integer> CONCURRENCY = CliEntry.createFirstArgParserEntry(e -> Integer.parseInt(e), (String)"Number of worker threads when doing parallel operation", (String[])new String[]{"c", "-concurrency"});
    protected static final String LOCALES = "aa_DJ aa_ER aa_ET af_ZA ak_GH am_ET an_ES anp_IN ar_AE ar_BH ar_DZ ar_EG ar_IN ar_IQ ar_JO ar_KW ar_LB ar_LY ar_MA ar_OM ar_QA ar_SA ar_SD ar_SS ar_SY ar_TN ar_YE as_IN ast_ES ayc_PE az_AZ be_BY bem_ZM ber_DZ ber_MA bg_BG bhb_IN bho_IN bn_BD bn_IN bo_CN bo_IN br_FR brx_IN bs_BA byn_ER C ca_AD ca_ES ca_FR ca_IT ce_RU chr_US cmn_TW crh_UA cv_RU cy_GB csb_PL cs_CZ da_DK de_AT de_BE de_CH de_DE de_IT de_LI de_LU doi_IN dv_MV dz_BT el_CY el_GR en_AG en_AU en_BW en_CA en_DK en_GB en_HK en_IE en_IL en_IN en_NG en_NZ en_PH en_SG en_US en_ZA en_ZM en_ZW eo es_AR es_BO es_CL es_CO es_CR es_CU es_DO es_EC es_ES es_GT es_HN es_MX es_NI es_PA es_PE es_PR es_PY es_SV es_US es_UY es_VE et_EE eu_ES eu_FR fa_IR ff_SN fi_FI fil_PH fo_FO fr_BE fr_CA fr_CH fr_FR fr_LU fur_IT fy_DE fy_NL ga_IE gd_GB gez_ER gez_ET gl_ES gu_IN gv_GB hak_TW ha_NG he_IL hi_IN hne_IN hr_HR hsb_DE ht_HT hu_HU hy_AM ia_FR id_ID ig_NG ik_CA is_IS it_CH it_IT iu_CA ja_JP ka_GE kk_KZ kl_GL km_KH kn_IN kok_IN ko_KR ks_IN ku_TR kw_GB ky_KG lb_LU lg_UG li_BE lij_IT li_NL ln_CD lo_LA lt_LT lv_LV lzh_TW mag_IN mai_IN mg_MG mhr_RU mi_NZ mk_MK ml_IN mni_IN mn_MN mr_IN ms_MY mt_MT my_MM nan_TW nb_NO nds_DE nds_NL ne_NP nhn_MX niu_NU niu_NZ nl_AW nl_BE nl_NL nn_NO nr_ZA nso_ZA oc_FR om_ET om_KE or_IN os_RU pa_IN pap_AW pap_CW pa_PK pl_PL ps_AF pt_BR pt_PT quz_PE raj_IN ro_RO ru_RU ru_UA rw_RW sa_IN sat_IN sc_IT sd_IN se_NO sgs_LT shs_CA sid_ET si_LK sk_SK sl_SI so_DJ so_ET so_KE so_SO sq_AL sq_MK sr_ME sr_RS ss_ZA st_ZA sv_FI sv_SE sw_KE sw_TZ szl_PL ta_IN ta_LK tcy_IN te_IN tg_TJ the_NP th_TH ti_ER ti_ET tig_ER tk_TM tl_PH tn_ZA tr_CY tr_TR ts_ZA tt_RU ug_CN uk_UA unm_US ur_IN ur_PK uz_UZ ve_ZA vi_VN wa_BE wae_CH wal_ET wo_SN xh_ZA yi_US yo_NG yue_HK zh_CN zh_HK zh_SG zh_TW zu_ZA";
    protected static Set<Map.Entry<Pattern, String>> SEARCH_LOCALES = new HashSet<Map.Entry<Pattern, String>>();
    protected Map<String, DebPackage> debPackages = new HashMap<String, DebPackage>();

    protected static String extract(String txt) {
        if ((txt = txt.trim()).startsWith("\"") && txt.endsWith("\"")) {
            txt = txt.substring(1, txt.length() - 1);
        }
        return txt;
    }

    public static Map<String, String> loadPo(InputStream is) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = null;
        boolean sMsgId = false;
        boolean sMsgStr = false;
        StringBuilder msgId = new StringBuilder();
        StringBuilder msgStr = new StringBuilder();
        HashMap<String, String> ret = new HashMap<String, String>();
        while (null != (line = br.readLine())) {
            if (0 == line.length()) {
                sMsgId = false;
                sMsgStr = false;
            }
            if (line.startsWith("msgid ")) {
                if (msgId.length() > 0 && msgStr.length() > 0) {
                    ret.put(msgId.toString(), msgStr.toString());
                }
                msgId.setLength(0);
                msgStr.setLength(0);
                sMsgId = true;
                msgId.append(TranslationCollector.extract(StringTools.getSubstringAfterFirstString((String)line, (String)"msgid ", (String)line)));
                continue;
            }
            if (line.startsWith("msgstr ")) {
                sMsgId = false;
                sMsgStr = true;
                msgStr.append(TranslationCollector.extract(StringTools.getSubstringAfterFirstString((String)line, (String)"msgstr ", (String)line)));
                continue;
            }
            if (sMsgId) {
                msgId.append(TranslationCollector.extract(line));
                continue;
            }
            if (!sMsgStr) continue;
            msgStr.append(TranslationCollector.extract(line));
        }
        return ret;
    }

    public static String getRootPackage(String name) {
        name = StringTools.getSubstringBeforeFirstString((String)name, (String)"-l10n");
        name = StringTools.getSubstringBeforeFirstString((String)name, (String)"-i18n");
        return name;
    }

    protected static DebPackage getOrCreatePackage(Map<String, DebPackage> packages, String packageName) {
        String root = TranslationCollector.getRootPackage(packageName);
        DebPackage ret = packages.get(root);
        if (null == ret) {
            ret = new DebPackage();
            ret.packageName = root;
            packages.put(root, ret);
        }
        return ret;
    }

    protected void unpackFiles(int concurrency) throws IOException, InterruptedException {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"Executing step `%s`", (Object)TranslationCollectorStages.unpack_packages.name());
        File dir = new File("./debs");
        File files = new File("./files");
        files.mkdirs();
        MultithreadingTools.processAllConcurrently((int)concurrency, (Collection)CollectionTools.inlineArrayList((Object[])dir.list()), f -> {
            try {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"Unpack deb file: `%s`", (Object)f);
                ProcessBuilder pb = new ProcessBuilder("bash", "-c", "cd ./files; dpkg --fsys-tarfile ../debs/" + f + " | tar x");
                pb.inheritIO();
                pb.start().waitFor();
            }
            catch (Exception e) {
                LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Exception while extracting debian package `%s` ", (Object)f);
            }
            return null;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> loadTranslationFile(String file) throws Exception {
        try {
            if (file.endsWith(".po")) {
                try (FileInputStream fis = new FileInputStream(file);){
                    Map<String, String> map = TranslationCollector.loadPo(fis);
                    return map;
                }
            }
            if (file.endsWith(".mo")) {
                ProcessBuilder pb = new ProcessBuilder("msgunfmt", file);
                Process proc = pb.start();
                long start = System.currentTimeMillis();
                EXEC.execute(() -> {
                    long sleep = start + 2000L - System.currentTimeMillis();
                    if (sleep > 0L) {
                        try {
                            Thread.sleep(sleep);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (proc.isAlive()) {
                        proc.destroyForcibly();
                    }
                });
                return TranslationCollector.loadPo(proc.getInputStream());
            }
        }
        catch (Exception e) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (String)"Can't process file: %s", (Object)file);
            return null;
        }
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"File is not useful: %s", (Object)file);
        return null;
    }

    public static <T extends Model, K> Map<K, T> getIndexed(SqlDatabase db, Class<T> cls, GetBy1<K, T> indexer) throws Exception {
        HashMap<Object, Model> ret = new HashMap<Object, Model>();
        ArrayList elems = new ArrayList();
        db.getAllInstance(cls, elems);
        for (Model t : elems) {
            ret.put(indexer.getBy((Object)t), t);
        }
        return ret;
    }

    public static <T extends Model, K> Map<K, T> loadAndCreateKey(SqlDatabase db, Class<T> cls, GetBy1<K, T> indexer, GetBy1<T, K> creator, Collection<K> keyset) throws Exception {
        Map<K, T> ret = TranslationCollector.getIndexed(db, cls, indexer);
        for (K key : keyset) {
            if (ret.containsKey(key)) continue;
            try {
                Model save = (Model)creator.getBy(key);
                db.insert(save);
                ret.put(key, save);
            }
            catch (Exception e) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.FATAL, (String)"Fatal exception while saving model `%s` with key `%s`", (Object)cls.getName(), key);
                Mirror.propagateAnyway((Throwable)e);
            }
        }
        return ret;
    }

    protected static Map<String, Language> getLanguages(SqlDatabase db) throws Exception {
        HashSet<String> locales = new HashSet<String>();
        for (Map.Entry<Pattern, String> l2 : SEARCH_LOCALES) {
            locales.add(l2.getValue());
        }
        return TranslationCollector.loadAndCreateKey(db, Language.class, l -> l.language, lang -> new Language((String)lang), locales);
    }

    protected static Map<String, Package> getPackages(SqlDatabase db, Collection<String> packages) throws Exception {
        return TranslationCollector.loadAndCreateKey(db, Package.class, l -> l.package_name, Package::new, packages);
    }

    protected static Map<String, SourceFile> getFiles(SqlDatabase db, Collection<String> files) throws Exception {
        return TranslationCollector.loadAndCreateKey(db, SourceFile.class, l -> l.file, SourceFile::new, files);
    }

    protected void importTransaltionsToCsv(int concurrency) throws Exception {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"executing step `%s`", (Object)TranslationCollectorStages.import_translations_csv.name());
        try (PrintStream ps = new PrintStream("translations.csv");){
            ps.println(CSV_RENDER.get().writeCsv("english", "package", "file", "language", "content"));
            this.importTransaltionsInto(concurrency, (SimplePublish5<String, String, String, String, String>)((SimplePublish5)(en, pack, file, lang, tr) -> {
                try {
                    ps.print(CSV_RENDER.get().writeCsv((String)en, (String)pack, (String)file, (String)lang, (String)tr));
                }
                catch (IOException e) {
                    LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.WARNING, (Throwable)e, (String)"Exception while writing record to CSV file: en: `%s`, pack: `%s`, file: `%s`, lang: `%s`, content: `%s` ", (Object[])new Object[]{en, pack, file, lang, tr});
                }
            }));
            ps.flush();
        }
    }

    public static final String determineFileLocale(String file) {
        for (Map.Entry<Pattern, String> tr : SEARCH_LOCALES) {
            if (!tr.getKey().matcher(file).find()) continue;
            return tr.getValue();
        }
        return null;
    }

    protected void importTransaltionsInto(int concurrency, SimplePublish5<String, String, String, String, String> save) throws Exception {
        ArrayList<TranslationParseTask> tasks = new ArrayList<TranslationParseTask>();
        HashSet<String> usedFile = new HashSet<String>();
        for (Map.Entry<String, DebPackage> dps : this.debPackages.entrySet()) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"importing package : `%s`", (Object)dps.getKey());
            DebPackage dp = dps.getValue();
            for (String file : dp.files.values()) {
                String lang = TranslationCollector.determineFileLocale(file);
                if (null == lang || !usedFile.add(file = file.trim())) continue;
                tasks.add(new TranslationParseTask(dps.getKey(), file, lang));
            }
        }
        MultithreadingTools.processAllConcurrently((int)concurrency, tasks, t -> t.execute(save));
    }

    public static SqlDatabase openDatabase() {
        return new SqlDatabase(new ConnectionCreator(){

            public Connection get() {
                try {
                    return DriverManager.getConnection("jdbc:mysql://127.0.0.1:3306/" + System.getenv("MYSQL_DATABASE") + "?useUnicode=true&characterEncoding=utf8&useSSL=false&useLegacyDatetimeCode=false&serverTimezone=UTC", System.getenv("MYSQL_USER"), System.getenv("MYSQL_PASSWORD"));
                }
                catch (SQLException e) {
                    Mirror.propagateAnyway((Throwable)e);
                    return null;
                }
            }
        }, (SqlDialect)new MysqlDialect());
    }

    protected static SqlDatabase openAndInitDatabase(boolean erase) throws Exception {
        Throwable throwable;
        Connection conn;
        SqlDatabase db = TranslationCollector.openDatabase();
        if (erase) {
            conn = db.getConnection();
            throwable = null;
            try {
                for (String s : new String[]{"english", "package", "language", "translation", "file"}) {
                    JDBC.execute((Connection)conn, (String)("DROP TABLE IF EXISTS `" + s + "`"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (conn != null) {
                    if (throwable != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        conn.close();
                    }
                }
            }
        }
        db.ensureTable(EnTranslation.class);
        db.ensureTable(SourceFile.class);
        db.ensureTable(Language.class);
        db.ensureTable(Package.class);
        db.ensureTable(Translation.class);
        conn = db.getConnection();
        throwable = null;
        try {
            ArrayList<TableIndex> indexes = new ArrayList<TableIndex>();
            indexes.add(new TableIndex("english", "index_translation", new String[]{"translation"}));
            indexes.add(new TableIndex("translation", "index_content", new String[]{"content"}));
            indexes.add(new TableIndex("translation", "index_exact", new String[]{"en_translation_id", "package_id", "lang_id"}));
            indexes.add(new TableIndex("translation", "index_which_packages", new String[]{"en_translation_id", "lang_id"}));
            indexes.add(new TableIndex("translation", "index_which_languages", new String[]{"en_translation_id", "package_id"}));
            indexes.add(new TableIndex("translation", "index_which_translation", new String[]{"package_id", "lang_id"}));
            MysqlIndexTools.bulkEnsureIndexes((Connection)conn, indexes, (boolean)true);
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (conn != null) {
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    conn.close();
                }
            }
        }
        return db;
    }

    protected void importTranslationsDatabase(int concurrency, boolean erase) throws Exception {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"Executing step `%s`", (Object)TranslationCollectorStages.import_translations_db.name());
        DatabaseImportContext ctx = DatabaseImportContext.create(this, TranslationCollector.openAndInitDatabase(erase));
        this.importTransaltionsInto(concurrency, (SimplePublish5<String, String, String, String, String>)((SimplePublish5)(en, pack, file, lang, tr) -> ctx.importTranslationToDb((String)en, (String)pack, (String)file, (String)lang, (String)tr)));
    }

    public static void printHelpAndExit() {
        System.exit(10);
    }

    public static void main(String ... args) throws Exception {
        JavaExperienceLoggingFacility.addStdOut();
        JavaExperienceLoggingFacility.startLoggingIntoDirectory((File)new File("./log/"), (String)"multilang-");
        TranslationCollector tc = new TranslationCollector();
        tc.searchPackages();
        int concurrency = 100;
        tc.collectTranslationFiles();
        tc.importTranslationsDatabase(concurrency, true);
        EXEC.shutdown();
        System.exit(0);
    }

    protected static boolean isUsefulFile(String file) {
        return null != TranslationCollector.determineFileLocale(file);
    }

    protected void searchPackages() throws IOException, InterruptedException {
        ProcessTools.assertedProcessExitStatus((String[])new String[]{"bash", "-c", "apt-file search .po | grep -P \"\\\\.po$\" > translation-lists"});
        ProcessTools.assertedProcessExitStatus((String[])new String[]{"bash", "-c", "apt-file search .mo | grep -P \"\\\\.mo$\" >> translation-lists"});
    }

    protected void collectTranslationFiles() throws IOException {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"Executing step `%s`", (Object)TranslationCollectorStages.search_translation_packages.name());
        IOTools.feedAllLine((String)"translation-lists", line -> {
            String pkg = StringTools.getSubstringBeforeFirstString((String)line, (String)":", null);
            String file = StringTools.getSubstringAfterFirstString((String)line, (String)":", null);
            if (null == pkg || null == file) {
                return;
            }
            if (TranslationCollector.isUsefulFile(file)) {
                DebPackage p = TranslationCollector.getOrCreatePackage(this.debPackages, pkg);
                p.files.put((Object)pkg, (Object)file.trim());
            }
        });
    }

    protected void downloadDebFiles(int concurrency) throws IOException, InterruptedException {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"Executing step `%s`", (Object)TranslationCollectorStages.download_packages.name());
        HashSet ps = new HashSet();
        for (Map.Entry<String, DebPackage> pe : this.debPackages.entrySet()) {
            ps.addAll(pe.getValue().files.keySet());
        }
        File dir = new File("./debs");
        dir.mkdirs();
        HashSet<String> downloadedPackages = new HashSet<String>();
        for (String f : dir.list()) {
            downloadedPackages.add(StringTools.getSubstringBeforeFirstString((String)f, (String)"_"));
        }
        ps.removeAll(downloadedPackages);
        MultithreadingTools.processAllConcurrently((int)concurrency, ps, p -> {
            try {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"Downloading debinan package: `%s`", (Object)p);
                ProcessTools.processExitStatus((String[])new String[]{"bash", "-c", "cd debs;apt-get download -y " + p});
            }
            catch (Exception e) {
                LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Exception while downloading debian package `%s` ", (Object)p);
            }
            return null;
        });
    }

    public static void csvToDb(String ... args) throws Exception {
        boolean erase = false;
        int concurrency = 5;
        TranslationCollector tc = new TranslationCollector();
        final SillyCSVFormatReader csv = new SillyCSVFormatReader(new File("./translations.csv").toURI().toURL(), '\"', ',', Charset.forName("UTF-8"), Mirror.emptyStringArray);
        csv.init();
        csv.readHeaders();
        tc.collectTranslationFiles();
        final DatabaseImportContext ctx = DatabaseImportContext.create(tc, TranslationCollector.openAndInitDatabase(false));
        for (int i = 0; i < 5; ++i) {
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (true) {
                        Map row = null;
                        SillyCSVFormatReader sillyCSVFormatReader = csv;
                        synchronized (sillyCSVFormatReader) {
                            row = csv.getRow();
                        }
                        if (null == row) {
                            return;
                        }
                        try {
                            ctx.importTranslationToDb((String)row.get("english"), (String)row.get("package"), (String)row.get("file"), (String)row.get("language"), (String)row.get("content"));
                            continue;
                        }
                        catch (Exception e) {
                            LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Exception while getting data from row `%s`. ", (Object)row);
                            continue;
                        }
                        break;
                    }
                }
            }.start();
        }
    }

    static {
        ArrayList<String> locales = new ArrayList<String>();
        for (String l : LOCALES.split(" ")) {
            if (locales.contains(l = l.toLowerCase())) continue;
            locales.add(l);
        }
        for (String l : LOCALES.split(" ")) {
            if (null == (l = StringTools.getSubstringBeforeFirstString((String)l, (String)"_", null)) || locales.contains(l = l.toLowerCase())) continue;
            locales.add(l);
        }
        StringBuilder sb = new StringBuilder();
        for (String l : locales) {
            sb.setLength(0);
            sb.append("(");
            sb.append("(/" + l + "/)");
            sb.append("|");
            sb.append("([^0-9a-zA-Z]" + l + "\\.(po|mo)$)");
            sb.append(")");
            SEARCH_LOCALES.add((Map.Entry<Pattern, String>)new KeyVal((Object)Pattern.compile(sb.toString(), 2), (Object)l));
        }
    }

    public static enum TranslationCollectorStages {
        search_translation_packages("Creates or updates the file `translation-lists`"),
        download_packages("Downloads the found .deb pacakges into the folder `./debs/`"),
        unpack_packages("Unpacks the files in the `./debs/` folder into `./files/`"),
        import_translations_csv("Collects all translations and writes into file `translations.csv`"),
        import_translations_db("Collects all translations and inserts into a Mysql database");

        protected String description;

        private TranslationCollectorStages(String description) {
            this.description = description;
        }
    }

    protected static class DatabaseImportContext {
        public TranslationCollector coll;
        public SqlDatabase db;
        public Map<String, Language> languages;
        public Map<String, Package> packages;
        public Map<String, SourceFile> files;

        protected DatabaseImportContext() {
        }

        public static DatabaseImportContext create(TranslationCollector coll, SqlDatabase db) throws Exception {
            DatabaseImportContext ret = new DatabaseImportContext();
            ret.coll = coll;
            ret.db = db;
            ret.loadFromDb();
            return ret;
        }

        public void loadFromDb() throws Exception {
            this.languages = TranslationCollector.getLanguages(this.db);
            this.packages = TranslationCollector.getPackages(this.db, this.coll.debPackages.keySet());
            HashSet<String> fileList = new HashSet<String>();
            for (DebPackage dp : this.coll.debPackages.values()) {
                fileList.addAll(dp.files.values());
            }
            this.files = TranslationCollector.getFiles(this.db, fileList);
        }

        public void importTranslationToDb(String en, String pack, String file, String lang, String tr) {
            if (en.length() < 500) {
                try {
                    EnTranslation et = (EnTranslation)this.db.getInstance(EnTranslation.class, "translation", (Object)en);
                    if (null == et) {
                        et = new EnTranslation();
                        et.translation = en;
                        this.db.insert((Model)et);
                    }
                    Translation t = new Translation();
                    t.en_translation_id = et.id;
                    t.file_id = this.files.get((Object)file).id;
                    t.package_id = this.packages.get((Object)pack).id;
                    t.lang_id = this.languages.get((Object)lang).id;
                    t.content = tr;
                    this.db.insert((Model)t);
                }
                catch (Exception e) {
                    LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Exception while trying to store transaltion. English: `%s`, Package: `%s`, Language: `%s`, Translation: `%s`", (Object[])new Object[]{en, pack, lang, tr});
                }
            }
        }
    }

    protected static class TranslationParseTask {
        public String pack;
        public String file;
        public String lang;

        public TranslationParseTask(String pack, String file, String lang) {
            this.pack = pack;
            this.file = file;
            this.lang = lang;
        }

        public String toString() {
            return Mirror.usualToString((Object)this);
        }

        public TranslationParseTask execute(SimplePublish5<String, String, String, String, String> save) {
            try {
                Map<String, String> po = TranslationCollector.loadTranslationFile("./files/" + this.file);
                if (null != po) {
                    for (Map.Entry<String, String> tr : po.entrySet()) {
                        String content = tr.getValue();
                        if (StringTools.isNullOrTrimEmpty((String)content)) continue;
                        save.publish((Object)tr.getKey(), (Object)this.pack, (Object)this.file, (Object)this.lang, (Object)content);
                    }
                }
            }
            catch (Exception e) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (String)"Exceltion while parsing translation file `%s`", (Object)this);
            }
            return this;
        }
    }

    protected static class CsvRender {
        protected StringBuilder sb = new StringBuilder();
        protected SimpleCSVOutput csv = new SimpleCSVOutput((Appendable)this.sb);

        protected CsvRender() {
        }

        public String writeCsv(String ... rows) throws IOException {
            this.sb.setLength(0);
            this.csv.putRow(rows);
            return this.sb.toString();
        }
    }

    public static class DebPackage {
        public String packageName;
        public MultiMap<String, String> files = new MultiMap();
    }

    public static class Translation
    extends UsualDbModel {
        @Id
        public int id;
        public int en_translation_id;
        public int file_id;
        public int package_id;
        public int lang_id;
        @Type(type="VARCHAR(700) CHARACTER SET utf8 COLLATE utf8_bin")
        @Indexed
        public String content;

        public String getTable() {
            return "translation";
        }
    }

    public static class EnTranslation
    extends UsualDbModel {
        @Id
        public int id;
        @Type(type=" VARCHAR(512) CHARACTER SET utf8 COLLATE utf8_bin")
        @Indexed
        public String translation;

        public String getTable() {
            return "english";
        }
    }

    public static class SourceFile
    extends UsualDbModel {
        @Id
        public int id;
        @Length(length=256)
        @Indexed
        public String file;

        public SourceFile() {
        }

        public SourceFile(String p) {
            this.file = p;
        }

        public String getTable() {
            return "file";
        }
    }

    public static class Package
    extends UsualDbModel {
        @Id
        public int id;
        @Length(length=64)
        @Indexed
        public String package_name;

        public Package() {
        }

        public Package(String p) {
            this.package_name = p;
        }

        public String getTable() {
            return "package";
        }
    }

    public static class Language
    extends UsualDbModel {
        @Id
        public int id;
        @Length(length=16)
        @Indexed
        public String language;

        public Language() {
        }

        public Language(String lang) {
            this.language = lang;
        }

        public String getTable() {
            return "language";
        }
    }
}

