/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multilang.web;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.database.DbQueryResultTable;
import eu.javaexperience.database.JDBC;
import eu.javaexperience.database.pojodb.SqlDatabase;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.convertFrom.DataWrapper;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.multilang.TranslationCollector;
import eu.javaexperience.multilang.web.CtxEnvKeys;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcDefaultProtocol;
import eu.javaexperience.text.StringTools;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.JavaClassURLNode;
import eu.javaexperience.web.facility.SiteFacilityTools;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ajax
extends JavaClassURLNode {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("MultilangSql"));
    public static final ajax INSTANCE = new ajax();
    public static final SqlDatabase DATABASE = TranslationCollector.openDatabase();
    public static final DataWrapper SER = BidirectionalRpcDefaultProtocol.DEFAULT_RPC_DATA_WRAPPER;

    protected boolean beforeCall(Context ctx, Method m) {
        return true;
    }

    protected void afterCall(Context ctx, Method m) {
    }

    protected void backward(Context ctx) {
    }

    public static int extractInt(String str, int def) {
        return ParsePrimitive.tryParseInt((String)StringTools.getFirstBetween((String)str, (String)"[", (String)"]", (String)str), (int)def);
    }

    public static DataObject extractSearch(Context ctx, int i) {
        String req = ctx.getRequest().getParameter("columns[" + i + "][search][value]");
        if (StringTools.isNullOrTrimEmpty((String)req)) {
            return null;
        }
        return DataObjectJsonImpl.instane.objectFromBlob(StringTools.getFirstBetween((String)req, (String)"[", (String)"]", (String)req).getBytes());
    }

    public static boolean addSearchField(boolean hasBefore, StringBuilder to, List<Object> toVars, String fieldName, DataObject data) {
        if (null == data) {
            return false;
        }
        String val = data.getString("value");
        if (StringTools.isNullOrTrimEmpty((String)val)) {
            return false;
        }
        String op = null;
        String wrap = null;
        switch (data.optString("type", "exact")) {
            case "exact": {
                op = " = ";
                break;
            }
            case "contains": {
                op = " LIKE ";
                wrap = "%";
                break;
            }
            case "regex": {
                op = " REGEXP ";
                break;
            }
        }
        if (null == op) {
            return false;
        }
        if (hasBefore) {
            to.append(" AND ");
        }
        to.append(fieldName);
        to.append(op);
        to.append("? ");
        if (null != wrap) {
            val = wrap + val + wrap;
        }
        toVars.add(val);
        return true;
    }

    public static PreparedQuery constructQuery(Context ctx) {
        DataObject sEnglish = ajax.extractSearch(ctx, 0);
        DataObject sPackage = ajax.extractSearch(ctx, 1);
        DataObject sLanguage = ajax.extractSearch(ctx, 2);
        DataObject sContent = ajax.extractSearch(ctx, 3);
        DataObject sFile = ajax.extractSearch(ctx, 4);
        StringBuilder sb = new StringBuilder();
        ArrayList<Object> vars = new ArrayList<Object>();
        sb.append("SELECT $SELECTION$ FROM english AS en JOIN translation as t ON en.id = t.en_translation_id JOIN language AS lang ON t.lang_id = lang.id JOIN package AS pack ON t.package_id = pack.id JOIN file as f ON f.id = t.file_id ");
        boolean hasPrevArg = false;
        StringBuilder sub = new StringBuilder();
        hasPrevArg |= ajax.addSearchField(hasPrevArg, sub, vars, "en.translation", sEnglish);
        hasPrevArg |= ajax.addSearchField(hasPrevArg, sub, vars, "pack.package_name", sPackage);
        hasPrevArg |= ajax.addSearchField(hasPrevArg, sub, vars, "lang.language", sLanguage);
        hasPrevArg |= ajax.addSearchField(hasPrevArg, sub, vars, "t.content", sContent);
        hasPrevArg |= ajax.addSearchField(hasPrevArg, sub, vars, "f.file", sFile);
        if (sub.length() > 0) {
            sb.append(" WHERE ");
            sb.append((CharSequence)sub);
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"`%s` inquiring for mysql query `%s`, vars `%s`", ctx.getEnv().get(CtxEnvKeys.request_id.name()), (Object)sub, vars);
        }
        return new PreparedQuery(sb.toString(), vars);
    }

    public static void searchWord(Context ctx) throws SQLException {
        int start = ajax.extractInt(ctx.getRequest().getParameter("start"), 0);
        int length = ajax.extractInt(ctx.getRequest().getParameter("length"), Integer.MAX_VALUE);
        PreparedQuery pq = ajax.constructQuery(ctx);
        try (Connection conn = DATABASE.getConnection();){
            DatatablesResult ret = new DatatablesResult();
            ret.recordsTotal = JDBC.getInt((Connection)conn, (String)"SELECT count(*) FROM translation");
            ret.recordsFiltered = JDBC.getIntPrepared((Connection)conn, (String)StringTools.replaceAllStrings((String)pq.query, (String)"$SELECTION$", (String)"count(*)"), (Object[])pq.values);
            String req = StringTools.replaceAllStrings((String)pq.query, (String)"$SELECTION$", (String)"en.translation AS english,  pack.package_name AS package, lang.language AS language, t.content AS content, f.file AS file ") + " LIMIT ? OFFSET ?";
            DbQueryResultTable table = JDBC.getAsDataTablePrepared((Connection)conn, (String)req, (Object[])pq.withVars(length, start));
            ret.data = table.rows;
            ret.response(ctx);
        }
        ctx.finishOperation();
    }

    protected boolean endpoint(Context ctx) {
        return false;
    }

    protected boolean access(Context ctx) {
        return true;
    }

    public static class PreparedQuery {
        public String query;
        public Object[] values;

        public PreparedQuery(String query, Object ... values) {
            this.query = query;
            this.values = values;
        }

        public PreparedQuery(String query, List<Object> values) {
            this.query = query;
            this.values = values.toArray(Mirror.emptyObjectArray);
        }

        public Object[] withVars(Object ... vars) {
            return ArrayTools.arrayConcat((Object[])this.values, (Object[])vars);
        }
    }

    public static class DatatablesResult {
        public int draw;
        public int recordsTotal;
        public int recordsFiltered;
        public Object data;

        public void response(Context ctx) {
            DataCommon ret = SER.wrap(SER, DataObjectJsonImpl.instane, (Object)this);
            SiteFacilityTools.finishWithMimeSend((Context)ctx, (byte[])ret.toBlob(), (String)"text/json");
            ctx.finishOperation();
        }
    }
}

