/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multilang.web;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.list.NullList;
import eu.javaexperience.file.AbstractFile;
import eu.javaexperience.file.FileSystemTools;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.multilang.web.CtxEnvKeys;
import eu.javaexperience.multilang.web.ajax;
import eu.javaexperience.multilang.web.webapp.MultilangWebapp;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.teasite.TeasiteBundle;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.url.URLNode;
import eu.javaexperience.web.dom.build.WebSoftwareBundle;
import eu.javaexperience.web.template.WebsiteTemplate;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class MultilangWebStart {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("MultilangWebStart"));

    public static Server createServer(final WebsiteTemplate wt, int port) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server, 1, 1);
        connector.setPort(port);
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                wt.service(request, response);
            }
        });
        return server;
    }

    protected static WebSoftwareBundle wrapBundle(String[] _css, String[] _preJs, String[] _postJs) {
        NullList css = null == _css ? NullList.instance : Collections.unmodifiableList(CollectionTools.inlineArrayList((Object[])_css));
        NullList preJs = null == _preJs ? NullList.instance : Collections.unmodifiableList(CollectionTools.inlineArrayList((Object[])_preJs));
        NullList postJs = null == _postJs ? NullList.instance : Collections.unmodifiableList(CollectionTools.inlineArrayList((Object[])_postJs));
        return new WebSoftwareBundle((List)css, (List)preJs, (List)postJs){
            final /* synthetic */ List val$css;
            final /* synthetic */ List val$preJs;
            final /* synthetic */ List val$postJs;
            {
                this.val$css = list;
                this.val$preJs = list2;
                this.val$postJs = list3;
            }

            public List<String> getCss() {
                return this.val$css;
            }

            public List<String> getPreJs() {
                return this.val$preJs;
            }

            public List<String> getPostJs() {
                return this.val$postJs;
            }
        };
    }

    public static AbstractFile resourceFile(String file) {
        return FileSystemTools.DEFAULT_FILESYSTEM.fromUri(file);
    }

    public static void main(String[] args) throws Throwable {
        JavaExperienceLoggingFacility.addStdOut();
        JavaExperienceLoggingFacility.startLoggingIntoDirectory((File)new File("./web-log/"), (String)"multilang-");
        WebSoftwareBundle bootstrap = MultilangWebStart.wrapBundle(new String[]{"https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css", "https://cdn.datatables.net/v/dt/dt-1.10.20/datatables.min.css"}, new String[]{"https://code.jquery.com/jquery-3.4.1.min.js", "https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js", "https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js", "https://cdn.datatables.net/v/dt/dt-1.10.20/datatables.min.js"}, null);
        TeasiteBundle bundle = new TeasiteBundle("", MultilangWebStart.isInDevelMode(), MultilangWebStart.resourceFile(MultilangWebStart.isInDevelMode() ? "src/main/resources/web_resources" : "web_resources"), "/tmp/multilang_webapp", MultilangWebStart.resourceFile((MultilangWebStart.isInDevelMode() ? "src/main/resources/" : "") + "web_resources/site/webapp.js"), MultilangWebapp.class, null, MultilangWebStart.getRpcNodes());
        bundle.setWebSoftwareBundles(new WebSoftwareBundle[]{bootstrap});
        bundle.script.getScriptNode().setCheckModifiedOnRequest(MultilangWebStart.isInDevelMode());
        WebsiteTemplate.WebsiteTemplateTemplateBuilder b = WebsiteTemplate.WebsiteTemplateTemplateBuilder.createDefaults();
        b.handleApp = MultilangWebStart.wrapLogger((SimplePublish1<Context>)bundle.asPathDispatch());
        b.sessionCookieName = "jvx-multilang-session";
        WebsiteTemplate wt = new WebsiteTemplate(b);
        bundle.addChild((URLNode)ajax.INSTANCE);
        Server server = MultilangWebStart.createServer(wt, 11111);
        server.start();
    }

    protected static SimplePublish1<Context> wrapLogger(SimplePublish1<Context> dispatch) {
        AtomicLong requesId = new AtomicLong();
        return ctx -> {
            long t0 = System.currentTimeMillis();
            long rid = requesId.incrementAndGet();
            try {
                ctx.getEnv().put(CtxEnvKeys.request_start_time.name(), t0);
                ctx.getEnv().put(CtxEnvKeys.request_id.name(), rid);
                dispatch.publish(ctx);
            }
            catch (Throwable throwable) {
                HttpServletRequest request = ctx.getRequest();
                String ip = request.getHeader("X-Forwarded-For");
                if (null == ip) {
                    ip = request.getRemoteAddr();
                }
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"HTTP Request `%d` served `%s` from `%s` under %s ms", (Object[])new Object[]{rid, request.getRequestURL().toString(), ip, System.currentTimeMillis() - t0});
                throw throwable;
            }
            HttpServletRequest request = ctx.getRequest();
            String ip = request.getHeader("X-Forwarded-For");
            if (null == ip) {
                ip = request.getRemoteAddr();
            }
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"HTTP Request `%d` served `%s` from `%s` under %s ms", (Object[])new Object[]{rid, request.getRequestURL().toString(), ip, System.currentTimeMillis() - t0});
        };
    }

    public static RpcFacility[] getRpcNodes() {
        return new RpcFacility[0];
    }

    protected static boolean isInDevelMode() {
        try {
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

