/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.multilang.web.webapp;

import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.multilang.web.commons.MultilangConstants;
import eu.javaexperience.teavm.datareprez.DataObjectTeaVMImpl;
import eu.javaexperience.text.StringTools;
import eu.jvx.js.lib.NativeJs;
import eu.jvx.js.lib.NativeJsSupport;
import eu.jvx.js.lib.bindings.H;
import eu.jvx.js.lib.history.HistoryTools;
import eu.jvx.js.lib.layout.BaseLayout;
import eu.jvx.js.lib.style.StyleCollection;
import eu.jvx.js.lib.teavm.NativeJsSupportTeaVM;
import java.util.Map;
import org.teavm.jso.JSObject;
import org.teavm.jso.browser.Window;
import org.teavm.jso.dom.events.EventListener;
import org.teavm.jso.dom.html.HTMLInputElement;
import org.teavm.jso.json.JSON;

public class MultilangWebapp {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("MultilangWebapp"));
    public static final StyleCollection STYLE;

    public static String getPath() {
        String ret = HistoryTools.getPath();
        if (ret.endsWith("/")) {
            ret = StringTools.getSubstringBeforeLastString((String)ret, (String)"/");
        }
        return ret;
    }

    public static void main(String[] args) {
        LogLevel level = LogLevel.DEBUG;
        LogLevel nll = (LogLevel)EnumTools.recogniseSymbol(LogLevel.class, (Object)HistoryTools.$_GET((String)"JVX_DEFAULT_LOG_LEVEL"));
        if (null != nll) {
            level = nll;
        }
        JavaExperienceLoggingFacility.addStdOut();
        JavaExperienceLoggingFacility.setFutureDefaultLoglevel((LoggingDetailLevel)level);
        JavaExperienceLoggingFacility.setAllFacilityLoglevel((LogLevel)level);
        STYLE.addStyle("#datatables_filter{display:none}");
        MultilangWebapp.startApp();
    }

    public static void startApp() {
        H base = BaseLayout.getDesignedRoot().attrs(new String[]{"style", "width:100%"});
        SearchTable table = SearchTable.createTable(MultilangConstants.FIELDS);
        base.addChilds(new H[]{table.table});
        table.initServerSide("/ajax/searchWord");
        for (SearchTable.HeaderField hf : table.headerFields.values()) {
            hf.root.addChilds(new H[]{new SearchBox((SearchTable.HeaderField)hf).root});
        }
    }

    static {
        NativeJsSupportTeaVM.init();
        STYLE = StyleCollection.createStyleDomCollection();
        H h = BaseLayout.getDesignedRoot();
    }

    public static class SearchBox {
        public SearchTable.HeaderField field;
        public H root;
        public H input;
        public H radio;
        public static final int TYPING_DELAY = 500;
        protected String prevState;

        public String serailize() {
            DataObjectTeaVMImpl ser = new DataObjectTeaVMImpl();
            ser.putString("value", ((HTMLInputElement)this.input.getHtml()).getValue());
            ser.putString("type", StringTools.getSubstringBeforeFirstString((String)((HTMLInputElement)this.root.getHtml().querySelector("input[type='radio']:checked")).getValue(), (String)"_"));
            return JSON.stringify((JSObject)((JSObject)ser.getImpl()));
        }

        public SearchBox(SearchTable.HeaderField hf) {
            this.field = hf;
            this.input = new H("input").attrs(new String[]{"name", "value"});
            String ns = StringTools.randomString((int)10);
            H opts = new H("div");
            int i = 0;
            for (String s : MultilangConstants.SEARCH_TYPES) {
                String id = StringTools.randomString((int)20);
                this.radio = new H("input").attrs(new String[]{"type", "radio", "name", "type_" + ns, "value", s, "id", id, "style", "transform: scale(1.5);margin-top: 12px;"});
                if (0 == i++) {
                    this.radio.attrs(new String[]{"checked", "checked"});
                }
                opts.addChilds(new H[]{new H("div").addChilds(new H[]{this.radio, new H("label").attrs(new String[]{"#text", s, "for", id, "style", "margin-left:5px"})})});
            }
            this.root = new H("div").addChilds(new H[]{new H("div").attrs(new String[]{"#text", hf.name}), this.input, opts});
            EventListener handler = e -> {
                String old = this.serailize();
                Window.setTimeout(() -> {
                    String now = this.serailize();
                    if (old.equals(now) && !now.equals(this.prevState)) {
                        this.prevState = now;
                        this.field.getTable().dataTable.columns(this.field.index).search(now).draw();
                    }
                }, (int)500);
            };
            this.root.on("change", handler);
            this.root.on("keyup", handler);
        }
    }

    public static interface DataTable
    extends JSObject {
        public DataTable search(String var1);

        public DataTable draw();

        public DataTableColumn columns(int var1);
    }

    public static interface DataTableColumn
    extends JSObject {
        public DataTable search(String var1);
    }

    public static class SearchTable {
        public DataTable dataTable;
        public H table;
        public String[] headers;
        public Map<String, HeaderField> headerFields = new SmallMap();

        public static SearchTable createTable(String ... headers) {
            SearchTable ret = new SearchTable();
            H h = new H("tr");
            H search = new H("tr");
            int i = 0;
            for (String s : headers) {
                SearchTable searchTable = ret;
                searchTable.getClass();
                HeaderField hf = searchTable.new HeaderField(new H("td"), s, i++);
                ret.headerFields.put(s, hf);
                search.addChilds(new H[]{hf.root});
                h.addChilds(new H[]{new H("td").attrs(new String[]{"#text", s})});
            }
            ret.table = new H("table").attrs(new String[]{"id", "datatables", "class", "dataTable"}).addChilds(new H[]{new H("thead").addChilds(new H[]{search, h})});
            return ret;
        }

        public void initServerSide(String url) {
            NativeJs js = NativeJsSupport.getSupport();
            this.dataTable = (DataTable)js.eval((JSObject)this.table.getHtml(), "$(param).DataTable({\n        \"processing\": true,\n        \"serverSide\": true,\n        \"ajax\": \"" + url + "\"\n    });");
        }

        public class HeaderField {
            public H root;
            public String name;
            public int index;

            public HeaderField(H root, String name, int index) {
                this.root = root;
                this.name = name;
                this.index = index;
            }

            public SearchTable getTable() {
                return SearchTable.this;
            }
        }
    }
}

