/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc;

import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.RpcSession;
import eu.javaexperience.semantic.references.MayNotNull;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleRpcSession
implements RpcSession {
    protected RpcProtocolHandler handler;
    protected long creationTime = System.currentTimeMillis();
    protected long lastAccess;
    protected Map<String, Object> attr = new ConcurrentHashMap<String, Object>();

    public Object get(String key) {
        return this.attr.get(key);
    }

    public void put(String key, Object value) {
        if (null == value) {
            this.attr.remove(key);
        } else {
            this.attr.put(key, value);
        }
    }

    public SimpleRpcSession(RpcProtocolHandler handler) {
        this.handler = handler;
    }

    public long getLastAccess() {
        return this.lastAccess;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccess;
    }

    @Override
    @MayNotNull
    public RpcProtocolHandler getDefaultRpcProtocolHandler() {
        return this.handler;
    }

    @Override
    public void destroy() {
    }

    public void setProtocolHandler(RpcProtocolHandler defaultProtocol) {
        this.handler = defaultProtocol;
    }

    public Map<String, Object> getExtraDataMap() {
        return this.attr;
    }
}

