/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.external_lang;

import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.JavaClassRpcFunctions;
import eu.javaexperience.rpc.SimpleRpcRequest;
import eu.javaexperience.rpc.SimpleRpcSession;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class QueueStorageExampleApi
extends JavaClassRpcFunctions<SimpleRpcRequest> {
    protected static QueueStorageExampleApi instance = new QueueStorageExampleApi();
    protected static Queue<String> QUEUE = new LinkedBlockingQueue<String>();

    public QueueStorageExampleApi() {
        super(QueueStorageExampleApi.class);
    }

    public static void staticAdd(SimpleRpcRequest req, String add) {
        if (null == add) {
            throw new RuntimeException("Value may not null");
        }
        QUEUE.add(add);
    }

    public static String staticGetValuable(SimpleRpcRequest req) {
        String ret = QUEUE.poll();
        if (null == ret) {
            throw new RuntimeException("No value in the queue.");
        }
        return ret;
    }

    public static String staticTryGetOrNull(SimpleRpcRequest req) {
        return QUEUE.poll();
    }

    public static String staticPeek(SimpleRpcRequest req) {
        return QUEUE.peek();
    }

    public static String[] staticGetAll(SimpleRpcRequest req) {
        return QUEUE.toArray(Mirror.emptyStringArray);
    }

    public static void staticClear(SimpleRpcRequest req) {
        QUEUE.clear();
    }

    protected static Queue<String> getOrCreateSessionQueue(SimpleRpcRequest req) {
        SimpleRpcSession sess = (SimpleRpcSession)req.getRpcSession();
        if (null == sess) {
            throw new RuntimeException("No session associated with this request.");
        }
        LinkedBlockingQueue q = (LinkedBlockingQueue)sess.get("QUEUE");
        if (null != q) {
            q = new LinkedBlockingQueue();
            sess.put("QUEUE", q);
        }
        return q;
    }

    public static void sessionAdd(SimpleRpcRequest req, String add) {
        if (null == add) {
            throw new RuntimeException("Value may not null");
        }
        QueueStorageExampleApi.getOrCreateSessionQueue(req).add(add);
    }

    public static String sessionGetValuable(SimpleRpcRequest req) {
        String ret = QueueStorageExampleApi.getOrCreateSessionQueue(req).poll();
        if (null == ret) {
            throw new RuntimeException("No value in the getOrCreateSessionQueue(req).");
        }
        return ret;
    }

    public static String sessionTryGetOrNull(SimpleRpcRequest req) {
        return QueueStorageExampleApi.getOrCreateSessionQueue(req).poll();
    }

    public static String sessionPeek(SimpleRpcRequest req) {
        return QueueStorageExampleApi.getOrCreateSessionQueue(req).peek();
    }

    public static String[] sessionGetAll(SimpleRpcRequest req) {
        return QueueStorageExampleApi.getOrCreateSessionQueue(req).toArray(Mirror.emptyStringArray);
    }

    public static void sessionClear(SimpleRpcRequest req) {
        QueueStorageExampleApi.getOrCreateSessionQueue(req).clear();
    }
}

