/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.cli;

import eu.javaexperience.cli.CliEntry;
import eu.javaexperience.cli.CliTools;
import eu.javaexperience.collection.map.NullMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.rpc.RpcFunction;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.RpcSession;
import eu.javaexperience.rpc.RpcSessionTools;
import eu.javaexperience.rpc.SimpleRpcSession;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcDefaultProtocol;
import eu.javaexperience.rpc.codegen.JavaRpcInterfaceGenerator;
import eu.javaexperience.rpc.function.JavaFunctionRpcWrapper;
import eu.javaexperience.semantic.references.MayNull;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;

public class RpcCliTools {
    private RpcCliTools() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataObject cliExecute(@MayNull RpcSession session, RpcFacility rpc, String ... args) {
        if (null == session) {
            session = new SimpleRpcSession(BidirectionalRpcDefaultProtocol.DEFAULT_PROTOCOL_HANDLER_WITH_CLASS);
        }
        BidirectionalRpcDefaultProtocol proto = (BidirectionalRpcDefaultProtocol)session.getDefaultRpcProtocolHandler();
        RpcRequest req = proto.createClientRequest(session);
        if (args.length > 0) {
            Method m;
            Parameter[] pcs;
            RpcFunction func = null;
            String name = args[0];
            for (RpcFunction f : rpc.getWrappedFunctions()) {
                if (!f.getMethodName().equals(name)) continue;
                func = f;
                break;
            }
            proto.putRequestFunctionName(req, name);
            Object[] params = Arrays.copyOfRange(args, 1, args.length);
            if (func instanceof JavaFunctionRpcWrapper && 0 != (pcs = (m = ((JavaFunctionRpcWrapper)func).getJavaMethod()).getParameters()).length && pcs[pcs.length - 1].isVarArgs()) {
                T[] p2 = Arrays.copyOfRange(args, 1, pcs.length + 1, Object[].class);
                Object[] va = Mirror.emptyObjectArray;
                if (params.length >= pcs.length) {
                    va = Arrays.copyOfRange(args, pcs.length, params.length + 1, Object[].class);
                }
                p2[p2.length - 1] = va;
                params = p2;
            }
            proto.putParameters(req, params);
        }
        RpcSessionTools.setCurrentRpcSession(session);
        try {
            DataObject dataObject = rpc.dispatch(req);
            return dataObject;
        }
        finally {
            RpcSessionTools.setCurrentRpcSession(null);
        }
    }

    public static String generateCliHelp(RpcFacility facility) {
        return JavaRpcInterfaceGenerator.BASIC_JAVA_SOURCE_BUILDER.buildRpcClientSource("Cli", facility.getWrappedFunctions(), (Map<String, Object>)NullMap.instance);
    }

    public static DataObject cliExecOrHelp(@MayNull RpcSession session, RpcFacility rpc, String ... args) {
        if (0 == args.length) {
            System.out.println(RpcCliTools.generateCliHelp(rpc));
            return null;
        }
        return RpcCliTools.cliExecute(session, rpc, args);
    }

    public static void printHelpAndExit(String programName, int exitCode, CliEntry ... entries) {
        System.err.println("Usage of " + programName + ":\n");
        System.err.println(CliTools.renderListAllOption((CliEntry[])entries));
        System.exit(exitCode);
    }
}

