/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.exceptions.OperationSuccessfullyEnded;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.rpc.RpcDefaultProtocol;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.RpcSession;
import eu.javaexperience.rpc.RpcSessionTools;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.server.AbstractServer;
import java.io.IOException;

public abstract class SocketRpcServer<SOCK extends IOStream, SESS extends RpcSession>
extends AbstractServer<SOCK> {
    protected final RpcProtocolHandler handler;

    public SocketRpcServer(IOStreamServer<SOCK> srv, int initialWorkerCount, RpcProtocolHandler handler) {
        super(srv, initialWorkerCount);
        this.handler = handler;
        AssertArgument.assertNotNull((Object)this.handler, (String)"rpc protocolhandler");
    }

    public SocketRpcServer(IOStreamServer<SOCK> srv, int initialWorkerCount) {
        this(srv, initialWorkerCount, new RpcDefaultProtocol((DataCommon)new DataObjectJsonImpl()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(SOCK sock) {
        this.manageLoad();
        DataCommon prototype = this.handler.getDefaultCommunicationProtocolPrototype();
        DataSender ds = null;
        DataReceiver rec = null;
        try {
            ds = prototype.newDataSender(sock.getOutputStream());
            rec = prototype.newDataReceiver(sock.getInputStream());
            SESS session = this.init(sock);
            RpcSessionTools.setCurrentRpcSession(session);
            while (!sock.isClosed()) {
                try {
                    DataObject req = rec.receiveDataObject();
                    if (null == req) {
                        break;
                    }
                    DataObject resp = this.handleRequest(session, req);
                    if (null == resp) continue;
                    ds.send(resp);
                }
                catch (OperationSuccessfullyEnded skk) {}
            }
        }
        catch (Throwable e) {
            this.onException(e);
        }
        finally {
            RpcSessionTools.setCurrentRpcSession(null);
            IOTools.silentClose(sock);
        }
        this.manageLoad();
    }

    protected void onException(Throwable t) {
        if (!(t instanceof IOException)) {
            t.printStackTrace();
        }
    }

    protected abstract SESS init(SOCK var1);

    @MayNull
    protected abstract DataObject handleRequest(SESS var1, DataObject var2);
}

