/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.codegen;

import eu.javaexperience.rpc.RpcFunction;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.codegen.JavaRpcExportTools;
import eu.javaexperience.rpc.codegen.RpcSourceBuilder;
import eu.javaexperience.rpc.function.RpcFunctionParameter;
import java.util.Collection;
import java.util.Map;

public class JavascriptRpcSourceGenerator {
    public static final String AJAX_TRANSMIT_SOURCE_CODE = "function ajaxTransmit(url)\n{\n\tthis.is_valuable = function(elem)\n\t{\n\t\treturn undefined != elem && null != elem;\n\t};\n\n\tthis.rxtx = function(request, response)\n\t{\n\t\tvar cb = this.is_valuable();\n\n\t\tvar xhr = new XMLHttpRequest();\n\t\tvar ajaxTrans = this;\n\t\tif(this.is_valuable(response))\n\t\t{\n\t\t\txhr.open('POST', url);\n\t\t\tvar called = [false];\n\t\t\txhr.onreadystatechange = function()\n\t\t\t{\n\t\t\t\tif(called[0])\n\t\t\t\t{\n\t\t\t\t\treturn;\n\t\t\t\t}\n\n\t\t\t\tcalled[0] = true;\n\n\t\t\t\tif(xhr.status === 200)\n\t\t\t\t{\n\t\t\t\t\tvar data = JSON.parse(xhr.responseText);\n\t\t\t\t\tif(ajaxTrans.is_valuable(data.r))\n\t\t\t\t\t{\n\t\t\t\t\t\tresponse(data.r, null);\n\t\t\t\t\t}\n\t\t\t\t\telse if(ajaxTrans.is_valuable(data.e))\n\t\t\t\t\t{\n\t\t\t\t\t\tresponse(null, data.e);\n\t\t\t\t\t}\n\t\t\t\t\treturn null;\n\t\t\t\t}\n\t\t\t}\n\t\t\txhr.send(JSON.stringify(request));\n\t\t}\n\t\telse\n\t\t{\n\t\t\txhr.open('POST', url, false);\n\t\t\txhr.send(JSON.stringify(request));\n\n\t\t\tvar data = JSON.parse(xhr.responseText);\n\t\t\tif(this.is_valuable(data.r))\n\t\t\t{\n\t\t\t\treturn data.r;\n\t\t\t}\n\t\t\telse if(this.is_valuable(data.e))\n\t\t\t{\n\t\t\t\tthrow data.e;\n\t\t\t}\n\t\t\treturn null;\n\t\t}\n\t}\n}\n\n";
    public static final String WEBSOCKET_BIDIRECTIONAL_SOURCE = "\twindow.WebsocketTransfer = function(url, serverRequestHandler)\n\t{\n\t\tthis.NEXT_PACKET_ID = 0;\n\n\t\tthis.PENDING_PACKETS = {};\n\n\t\tthis.is_valuable = function(o)\n\t\t{\n\t\t\treturn null != o && undefined != o;\n\t\t}\n\n\t\tthis.is_function = function(o)\n\t\t{\n\t\t\treturn \"function\" === typeof o;\n\t\t}\n\n\t\tthis.serverRequestHandler = serverRequestHandler;\n\t\tthis.SOCKET = new WebSocket(url);\n\t\tthis.SOCKET.onmessage = function(event)\n\t\t{\n\t\t\tvar data = JSON.parse(event.data);\n\t\t\tvar id = data.t;\n\t\t\tif(this.is_valuable(id))\n\t\t\t{\n\t\t\t\tvar descriptor = this.PENDING_PACKETS[id];\n\t\t\t\tdelete this.PENDING_PACKETS[id];\n\t\t\t\tif(this.is_function(descriptor.handler))\n\t\t\t\t{\n\t\t\t\t\tdescriptor.handler(descriptor.request, data, event);\n\t\t\t\t}\n\t\t\t}\n\t\t\telse\n\t\t\t{\n\t\t\t\tif(this.is_function(this.serverRequestHandler))\n\t\t\t\t{\n\t\t\t\t\tthis.serverRequestHandler(event.data, event);\n\t\t\t\t}\n\t\t\t}\n\t\t}.bind(this);\n\n\t\tthis.request = function(request, handler)\n\t\t{\n\t\t\tvar id = \"c\"+(++this.NEXT_PACKET_ID);\n\t\t\trequest.t = id;\n\t\t\tthis.PENDING_PACKETS[id] =\n\t\t\t{\n\t\t\t\tid: id,\n\t\t\t\trequest: request,\n\t\t\t\thandler: handler\n\t\t\t};\n\n\t\t\tvar send = JSON.stringify(request);\n\t\t\tthis.SOCKET.send(send);\n\t\t}\n\n\t\tthis.simple_request = function(send, opt_notify)\n\t\t{\n\t\t\tthis.request\n\t\t\t(\n\t\t\t\tsend,\n\t\t\t\tfunction(req, response, event)\n\t\t\t\t{\n\t\t\t\t\tif(this.is_function(opt_notify))\n\t\t\t\t\t{\n\t\t\t\t\t\topt_notify(req, response, event);\n\t\t\t\t\t}\n\t\t\t\t}.bind(this)\n\t\t\t);\n\t\t}\n\n\t\tthis.rxtx = function(request, cb)\n\t\t{\n\t\t\tthis.simple_request\n\t\t\t(\n\t\t\t\trequest,\n\t\t\t\tfunction(req, response, event)\n\t\t\t\t{\n\t\t\t\t\tif(this.is_function(cb))\n\t\t\t\t\t{\n\t\t\t\t\t\tcb(response.r, response.e, req, event);\n\t\t\t\t\t}\n\t\t\t\t}.bind(this)\n\t\t\t);\n\t\t}\n}";
    public static RpcSourceBuilder<RpcFunctionParameter, RpcFunction<RpcRequest, RpcFunctionParameter>> BASIC_JAVASCRIPT_SOURCE_BUILDER = new RpcSourceBuilder<RpcFunctionParameter, RpcFunction<RpcRequest, RpcFunctionParameter>>(){

        @Override
        public String buildRpcClientSource(String compilationUnitName, Collection<RpcFunction<RpcRequest, RpcFunctionParameter>> functions, Map<String, Object> options) {
            StringBuilder sb = new StringBuilder();
            boolean use_cb = false;
            if (null != options && (options.containsKey("using_callback_return") || options.containsKey("async"))) {
                use_cb = true;
            }
            sb.append("function ");
            sb.append(compilationUnitName);
            sb.append("(conn)");
            boolean teavm = false;
            if (options.containsKey("teavm")) {
                teavm = true;
            }
            sb.append("\n{\n\tthis.transfer = conn;\n\n");
            for (RpcFunction<RpcRequest, RpcFunctionParameter> f : functions) {
                int p;
                String comment = JavaRpcExportTools.renderFunctionComment(f);
                if (null != comment) {
                    sb.append(comment);
                }
                sb.append("\tthis.");
                if (teavm) {
                    sb.append("$");
                }
                sb.append(f.getMethodName());
                sb.append(" = function(");
                RpcFunctionParameter[] params = f.getParameterClasses();
                if (use_cb) {
                    sb.append("callback");
                }
                for (p = 0; p < params.length; ++p) {
                    if (use_cb || p != 0) {
                        sb.append(", ");
                    }
                    sb.append((char)(97 + p));
                }
                sb.append(")\n\t{\n\t\t");
                if (f.getReturningClass() != null && !Void.TYPE.equals(f.getReturningClass())) {
                    sb.append("return ");
                }
                if (teavm) {
                    sb.append("this.transfer.$publish({'f': '");
                } else {
                    sb.append("this.transfer.rxtx({'f': '");
                }
                sb.append(f.getMethodName());
                sb.append("', 'p' : [");
                for (p = 0; p < params.length; ++p) {
                    if (0 != p) {
                        sb.append(", ");
                    }
                    sb.append((char)(97 + p));
                }
                sb.append("]}, ");
                sb.append(use_cb ? "callback" : "null");
                sb.append(");\n\t};\n\n");
            }
            sb.append("};\n");
            return sb.toString();
        }
    };
}

