/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.database.annotations.Ignore;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.rpc.JavaClassRpcFunctions;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.rpc.RpcFunction;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.RpcTools;
import eu.javaexperience.rpc.function.JavaFunctionRpcWrapper;
import eu.javaexperience.rpc.function.RpcFunctionParameter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class JavaClassRpcCollector<REQ extends RpcRequest>
implements RpcFacility<REQ> {
    protected static final Logger DEFAULT_LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("RpcFunctionStorage"));
    public static JavaClassRpcFunctions[] emptyJavaClassRpcFunctionsArray = new JavaClassRpcFunctions[0];
    public static JavaClassRpcCollector[] emptyJavaClassRpcCollector = new JavaClassRpcCollector[0];
    public static RpcFacility[] emptyRpcFacilityArray = new RpcFacility[0];
    protected Logger LOG = DEFAULT_LOG;
    protected Class<?> requestClass;
    protected Map<String, JavaFunctionRpcWrapper<REQ>> METHODS;
    protected Object javaMethodThisParam;
    protected String rpcName;
    protected static final AtomicInteger REQUEST_ID = new AtomicInteger(0);

    public JavaClassRpcCollector(Class<?> toWrap) {
        this.requestClass = toWrap;
    }

    protected JavaClassRpcCollector() {
        this.requestClass = this.getClass();
    }

    protected void initalize() {
        Method[] ms;
        HashMap<String, JavaFunctionRpcWrapper> methods = new HashMap<String, JavaFunctionRpcWrapper>();
        for (Method m : ms = this.requestClass.getMethods()) {
            try {
                if (!this.mayRegister(m)) continue;
                JavaFunctionRpcWrapper func = this.wrapFunction(m);
                methods.put(func.getMethodName(), func);
            }
            catch (Exception e) {
                LoggingTools.tryLogFormat((Logger)this.LOG, (LoggingDetailLevel)LogLevel.WARNING, (String)"Method: %s", (Object)m);
                LoggingTools.tryLogSimple((Logger)this.LOG, (LoggingDetailLevel)LogLevel.WARNING, (Throwable)e);
            }
        }
        this.METHODS = Collections.unmodifiableMap(methods);
    }

    protected JavaFunctionRpcWrapper wrapFunction(Method m) {
        return JavaFunctionRpcWrapper.wrapJavaFunction(m);
    }

    protected void onException(Throwable t) {
        t.printStackTrace();
    }

    public Collection<JavaFunctionRpcWrapper<REQ>> getWrappedMethods() {
        return this.METHODS.values();
    }

    @Override
    public Collection<JavaFunctionRpcWrapper<REQ>> getWrappedFunctions() {
        return this.METHODS.values();
    }

    public void fillFunctionList(Collection<RpcFunction<REQ, RpcFunctionParameter>> fill) {
        for (Map.Entry<String, JavaFunctionRpcWrapper<REQ>> kv : this.METHODS.entrySet()) {
            fill.add(kv.getValue());
        }
    }

    public Map<String, JavaFunctionRpcWrapper<REQ>> getWrappedMethodsWithName() {
        return this.METHODS;
    }

    public List<RpcFunction<REQ, RpcFunctionParameter>> getFunctionList() {
        ArrayList<RpcFunction<REQ, RpcFunctionParameter>> ret = new ArrayList<RpcFunction<REQ, RpcFunctionParameter>>();
        this.fillFunctionList(ret);
        return ret;
    }

    public void setLogger(Logger logger) {
        AssertArgument.assertNotNull((Object)logger, (String)"logger");
        this.LOG = logger;
    }

    public static boolean mayRegisterMethod(Method m, Class<?> rpcThisClass) {
        Class<?>[] clss;
        int mod = m.getModifiers();
        return Modifier.isPublic(mod) && Modifier.isStatic(mod) && null == m.getAnnotation(Ignore.class) && (clss = m.getParameterTypes()).length > 0 && rpcThisClass.isAssignableFrom(clss[0]);
    }

    protected void beforeCall(REQ ctx, JavaFunctionRpcWrapper<REQ> m) throws Throwable {
    }

    protected boolean mayRegister(Method m) {
        return JavaClassRpcCollector.mayRegisterMethod(m, RpcRequest.class);
    }

    protected DataObject onMethodNotFound(REQ ctx, String name) {
        throw new RuntimeException("Method not found: " + name);
    }

    @Override
    public DataObject dispatch(REQ ctx) {
        RpcProtocolHandler protocol = ctx.getProtocolHandler();
        int req_id = -1;
        if (this.LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) {
            req_id = REQUEST_ID.incrementAndGet();
            this.LOG.logFormat((LoggingDetailLevel)LogLevel.TRACE, "%d Request: %s", new Object[]{req_id, ctx.getRequestData().getImpl().toString()});
        }
        try {
            String name = ctx.getProtocolHandler().getRequestFunctionName((RpcRequest)ctx);
            JavaFunctionRpcWrapper<REQ> func = this.METHODS.get(name);
            if (null != func) {
                this.beforeCall(ctx, func);
                DataObject ret = RpcTools.callFunction(ctx, this.javaMethodThisParam, func);
                if (ret instanceof DataObject) {
                    return ret;
                }
                return RpcTools.wrapReturningValue(ctx, (Object)ret);
            }
            return this.onMethodNotFound(ctx, name);
        }
        catch (Throwable t) {
            this.onException(t);
            DataObject ret = protocol.createException((RpcRequest)ctx, t);
            if (-1 != req_id && this.LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) {
                this.LOG.logFormat((LoggingDetailLevel)LogLevel.TRACE, "%d Exception response: %s", new Object[]{req_id, ret.getImpl().toString()});
            }
            return ret;
        }
    }

    public DataObject getBy(REQ a) {
        return this.dispatch(a);
    }

    @Override
    public String getRpcName() {
        if (null != this.rpcName) {
            return this.rpcName;
        }
        return this.requestClass.getSimpleName();
    }

    public Class getWrappedClass() {
        return this.requestClass;
    }
}

