/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.tor;

import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.fd.IOStreamFactory;
import eu.javaexperience.parse.ParsePrimitive;
import eu.javaexperience.proxy.TorProxySpawner;
import eu.javaexperience.rpc.JavaClassRpcFunctions;
import eu.javaexperience.rpc.RpcDefaultProtocol;
import eu.javaexperience.rpc.RpcSession;
import eu.javaexperience.rpc.RpcTools;
import eu.javaexperience.rpc.SimpleRpcRequest;
import eu.javaexperience.rpc.SimpleRpcSession;
import eu.javaexperience.rpc.SocketRpcServer;
import eu.javaexperience.rpc.codegen.JavaRpcInterfaceGenerator;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;

public class TorProxyServer {
    protected static TorProxySpawner TOR_SPAWN = TorProxySpawner.runtimeThrowCreate((String)"./tor");
    protected static final HashMap<Integer, TorProxySpawner.TorProxy> TORS = new HashMap();

    public static void main(String[] args) throws IOException {
        new File("./tor").mkdirs();
        RpcDefaultProtocol proto = new RpcDefaultProtocol((DataCommon)new DataObjectJsonImpl());
        JavaClassRpcFunctions api = new JavaClassRpcFunctions(TorProxyServer.class);
        SocketRpcServer<IOStream, SimpleRpcSession> srv = RpcTools.newServer(IOStreamFactory.fromServerSocket((ServerSocket)new ServerSocket(9049)), 5, proto, RpcTools.getSimpleSessionCreator(), (a, b) -> api.dispatch(new SimpleRpcRequest((RpcSession)a, (DataObject)b)));
        srv.start();
        System.out.println(RpcTools.generateRpcClassWithBuilder(JavaRpcInterfaceGenerator.BASIC_JAVA_SOURCE_BUILDER, "TorProxyServer", api.getFunctionList()));
        String sp = System.getProperties().getProperty("start_proxies");
        Integer pre = ParsePrimitive.tryParseInt((String)sp);
        System.out.println("-Dstart_proxies: " + sp + " " + pre);
        if (pre != null) {
            for (int i = 0; i < pre; ++i) {
                try {
                    TorProxyServer.getTorAtOffset(i);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static synchronized TorProxySpawner.TorProxy getTorAtOffset(int offset) throws InterruptedException, IOException {
        TorProxySpawner.TorProxy tp = TORS.get(offset);
        if (tp == null) {
            tp = TOR_SPAWN.spawnWithOffset(offset);
            TORS.put(offset, tp);
        }
        return tp;
    }

    public static int get_proxy_offset(SimpleRpcRequest req, int index) throws InterruptedException, IOException {
        return TorProxyServer.getTorAtOffset(index).getPort();
    }
}

