/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.convertFrom.ArrayLike;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.FieldSelectTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.NotatedCaster;
import eu.javaexperience.text.Format;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RpcCastTools {
    protected static ConcurrentMap<Class, NotatedCaster> WELL_KNOWN_CASTERS = new ConcurrentHashMap<Class, NotatedCaster>();
    protected static ConcurrentMap<Class<?>, NotatedCaster> CASTERS;

    public static NotatedCaster arrayCaster(final Class<?> cls) {
        Class<?> component;
        NotatedCaster c;
        if (cls.isArray() && null != (c = RpcCastTools.tryCreateCaster(component = cls.getComponentType()))) {
            return new NotatedCaster(){

                public Object cast(Object in) {
                    if (null == in) {
                        return null;
                    }
                    if (cls.isAssignableFrom(in.getClass())) {
                        return in;
                    }
                    int len = RpcCastTools.tryGetLength(in);
                    if (-1 == len) {
                        return null;
                    }
                    Object[] ret = (Object[])Array.newInstance(component, len);
                    for (int i = 0; i < len; ++i) {
                        ret[i] = c.cast(RpcCastTools.tryGetIndex(in, i));
                    }
                    return ret;
                }

                public String getTypeShortName() {
                    return c.getTypeShortName() + "[]";
                }

                public String getTypeFullQualifiedName() {
                    return c.getTypeFullQualifiedName() + "[]";
                }
            };
        }
        return null;
    }

    protected static int tryGetLength(Object o) {
        if (null != o) {
            if (o.getClass().isArray()) {
                return Array.getLength(o);
            }
            if (o instanceof ArrayLike) {
                return ((ArrayLike)o).size();
            }
            if (o instanceof List) {
                return ((List)o).size();
            }
        }
        return -1;
    }

    protected static Object tryGetIndex(Object o, int i) {
        if (null != o) {
            if (o.getClass().isArray()) {
                return Array.get(o, i);
            }
            if (o instanceof ArrayLike) {
                return ((ArrayLike)o).get(i);
            }
            if (o instanceof List) {
                return ((List)o).get(i);
            }
        }
        return -1;
    }

    public static NotatedCaster tryCreateCaster(Type type) {
        Class<?> cls = RpcCastTools.extractClass(type);
        NotatedCaster ret = (NotatedCaster)WELL_KNOWN_CASTERS.get(cls);
        if (null != ret) {
            return ret;
        }
        if (cls.isArray()) {
            NotatedCaster c = RpcCastTools.arrayCaster(cls);
            if (null != c) {
                return c;
            }
        } else {
            CastTo c = CastTo.getCasterRestrictlyForTargetClass(cls);
            if (null != c) {
                return c;
            }
        }
        return null;
    }

    public static NotatedCaster getDirectCaster(Type type) {
        final Class<?> clss = RpcCastTools.extractClass(type);
        NotatedCaster ret = (NotatedCaster)CASTERS.get(clss);
        if (null == ret) {
            ret = new NotatedCaster(){

                public Object cast(Object in) {
                    if (null == in) {
                        return null;
                    }
                    if (clss.isAssignableFrom(in.getClass())) {
                        return in;
                    }
                    return null;
                }

                public String getTypeShortName() {
                    return clss.getSimpleName();
                }

                public String getTypeFullQualifiedName() {
                    return clss.getName();
                }
            };
            CASTERS.put(clss, ret);
        }
        return ret;
    }

    public static Class<?> extractClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            return RpcCastTools.extractClass(t.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType t = (GenericArrayType)type;
            return RpcCastTools.extractClass(t.getGenericComponentType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return RpcCastTools.extractClass(tv.getBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return RpcCastTools.extractClass(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            // empty if block
        }
        throw new RuntimeException("Can't extract class of type: " + type);
    }

    static {
        WELL_KNOWN_CASTERS.put(Map.class, new NotatedCaster(){

            public Object cast(Object in) {
                if (in instanceof Map) {
                    return in;
                }
                if (in instanceof DataObject) {
                    return DataReprezTools.extractToJavaPrimitiveTypes((Object)in);
                }
                SmallMap ret = new SmallMap();
                try {
                    Mirror.extractFieldsToMap((Object)in, (Map)ret, (Mirror.FieldSelector)FieldSelectTools.SELECT_ALL_INSTANCE_FIELD);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ret;
            }

            public String getTypeShortName() {
                return "Map";
            }

            public String getTypeFullQualifiedName() {
                return "java.lang.Map";
            }
        });
        WELL_KNOWN_CASTERS.put(byte[].class, new NotatedCaster(){

            public Object cast(Object in) {
                if (in instanceof byte[]) {
                    return in;
                }
                if (in instanceof String) {
                    return Format.base64Decode((String)((String)in));
                }
                return null;
            }

            public String getTypeShortName() {
                return "byte[]";
            }

            public String getTypeFullQualifiedName() {
                return "byte[]";
            }
        });
        CASTERS = new ConcurrentHashMap();
    }
}

