/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.codegen;

import eu.javaexperience.rpc.RpcFunction;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.codegen.JavaRpcExportTools;
import eu.javaexperience.rpc.codegen.RpcSourceBuilder;
import eu.javaexperience.rpc.function.RpcFunctionParameter;
import eu.javaexperience.text.StringTools;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class JavaRpcInterfaceGenerator {
    protected static final HashMap<String, String> CLASSIZE_TYPES = new HashMap<String, String>(){
        {
            this.put("void", "Void");
            this.put("boolean", "Boolean");
            this.put("byte", "Byte");
            this.put("char", "Character");
            this.put("short", "Short");
            this.put("int", "Integer");
            this.put("long", "Long");
            this.put("float", "Float");
            this.put("double", "Double");
        }
    };
    public static RpcSourceBuilder<RpcFunctionParameter, RpcFunction<RpcRequest, RpcFunctionParameter>> BASIC_JAVA_SOURCE_BUILDER = new RpcSourceBuilder<RpcFunctionParameter, RpcFunction<RpcRequest, RpcFunctionParameter>>(){

        @Override
        public String buildRpcClientSource(String compilationUnitName, Collection<RpcFunction<RpcRequest, RpcFunctionParameter>> functions, Map<String, Object> options) {
            StringBuilder sb = new StringBuilder();
            sb.append("public interface ");
            sb.append(compilationUnitName);
            sb.append("\n{\n");
            String cb = null;
            if (null != options) {
                cb = (String)options.get("async");
            }
            String cbt = null;
            if (null != cb) {
                cbt = (String)options.get("async_rettype_replace");
            }
            HashSet<String> types = new HashSet<String>();
            for (RpcFunction<RpcRequest, RpcFunctionParameter> f : functions) {
                sb.append("\tpublic ");
                JavaRpcInterfaceGenerator.fillFunctionShortInterfaceSignature(sb, f, types, cb, cbt);
                sb.append("\n");
            }
            sb.append("}");
            return sb.toString();
        }
    };

    public static void fillFunctionShortInterfaceSignature(StringBuilder sb, RpcFunction<? extends RpcRequest, RpcFunctionParameter> f, Collection<String> types_full_name) {
        JavaRpcInterfaceGenerator.fillFunctionShortInterfaceSignature(sb, f, types_full_name, null, null);
    }

    public static String renderCallbackType(String retType, String callbackClass, String replace) {
        if (null == replace) {
            return callbackClass;
        }
        String atype = CLASSIZE_TYPES.get(retType);
        if (null != atype) {
            retType = atype;
        }
        return StringTools.replaceAllStrings((String)callbackClass, (String)replace, (String)retType);
    }

    public static void fillFunctionShortInterfaceSignature(StringBuilder sb, RpcFunction<? extends RpcRequest, RpcFunctionParameter> f, Collection<String> types_full_name, String callbackClass, String callbackReplaceName) {
        String comment = JavaRpcExportTools.renderFunctionComment(f);
        if (null != comment) {
            sb.append(comment);
        }
        if (null == callbackClass) {
            sb.append(f.getReturningClass().getTypeName());
        } else {
            sb.append("void");
        }
        if (null != types_full_name) {
            types_full_name.add(f.getReturningClass().getTypeFullQualifiedName());
        }
        sb.append(" ");
        sb.append(f.getMethodName());
        sb.append("(");
        RpcFunctionParameter[] params = f.getParameterClasses();
        if (null != callbackClass) {
            sb.append(JavaRpcInterfaceGenerator.renderCallbackType(f.getReturningClass().getTypeName(), callbackClass, callbackReplaceName));
            sb.append(" cb");
        }
        for (int p = 0; p < params.length; ++p) {
            if (p != 0 || null != callbackClass) {
                sb.append(", ");
            }
            sb.append(params[p].getTypeName());
            if (null != types_full_name) {
                types_full_name.add(params[p].getTypeFullQualifiedName());
            }
            sb.append(" ");
            sb.append((char)(97 + p));
        }
        sb.append(");");
    }

    public static String getFunctionShortInterfaceSignature(RpcFunction<? extends RpcRequest, RpcFunctionParameter> f, Collection<String> types_full_name) {
        StringBuilder sb = new StringBuilder();
        JavaRpcInterfaceGenerator.fillFunctionShortInterfaceSignature(sb, f, types_full_name);
        return sb.toString();
    }
}

