/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.codegen;

import eu.javaexperience.rpc.RpcFunction;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.codegen.JavaRpcExportTools;
import eu.javaexperience.rpc.codegen.RpcSourceBuilder;
import eu.javaexperience.rpc.function.RpcFunctionParameter;
import java.util.Collection;
import java.util.Map;

public class PhpRpcInterfaceGenerator {
    public static RpcSourceBuilder<RpcFunctionParameter, RpcFunction<RpcRequest, RpcFunctionParameter>> BASIC_PHP_SOURCE_BUILDER = new RpcSourceBuilder<RpcFunctionParameter, RpcFunction<RpcRequest, RpcFunctionParameter>>(){

        @Override
        public String buildRpcClientSource(String compilationUnitName, Collection<RpcFunction<RpcRequest, RpcFunctionParameter>> functions, Map<String, Object> options) {
            StringBuilder sb = new StringBuilder();
            sb.append("class ");
            sb.append(compilationUnitName);
            sb.append("\n{\n\tprivate $conn;\n\n\tpublic function __construct($conn");
            sb.append(")\n\t{\n\t\t$this->conn = $conn;\n");
            sb.append("\t}\n\n");
            for (RpcFunction<RpcRequest, RpcFunctionParameter> f : functions) {
                int p;
                String comment = JavaRpcExportTools.renderFunctionComment(f);
                if (null != comment) {
                    sb.append(JavaRpcExportTools.withTabIndent(comment, 1));
                    sb.append("\n");
                }
                sb.append("\tpublic function ");
                sb.append(f.getMethodName());
                sb.append("(");
                RpcFunctionParameter[] params = f.getParameterClasses();
                for (p = 0; p < params.length; ++p) {
                    if (p != 0) {
                        sb.append(", $");
                    } else {
                        sb.append("$");
                    }
                    sb.append((char)(97 + p));
                }
                sb.append(")\n\t{\n\t\t");
                if (f.getReturningClass() != null && !Void.TYPE.equals(f.getReturningClass())) {
                    sb.append("return ");
                }
                sb.append("$this->conn->txrx(array(");
                sb.append("'f' => '");
                sb.append(f.getMethodName());
                sb.append("', 'p' => array(");
                for (p = 0; p < params.length; ++p) {
                    if (0 != p) {
                        sb.append(", ");
                    }
                    sb.append(" $");
                    sb.append((char)(97 + p));
                }
                sb.append(")));\n\t}\n\n");
            }
            sb.append("}");
            return sb.toString();
        }
    };

    private static void _() {
        StringBuilder sb = new StringBuilder();
        String comm = null;
        if (comm != null) {
            sb.append("\t/*");
            sb.append(comm.replace("\n", "\n\t *"));
            sb.append("\t*/\n");
        }
    }
}

