/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc;

import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.database.annotations.Ignore;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.JavaClassRpcCollector;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.function.JavaAsIsFunctionWrapper;
import eu.javaexperience.rpc.function.JavaFunctionRpcWrapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;

public class JavaClassRpcUnboundFunctionsInstance<REQ extends RpcRequest>
extends JavaClassRpcCollector<REQ> {
    public JavaClassRpcUnboundFunctionsInstance(Class ... otherInterfaces) {
        this.javaMethodThisParam = this;
        this.initalize(null, otherInterfaces);
    }

    public JavaClassRpcUnboundFunctionsInstance(Object rpcServiceInstance, Class ... otherInterfaces) {
        this(null, rpcServiceInstance, otherInterfaces);
    }

    public JavaClassRpcUnboundFunctionsInstance(String rpcName, Object rpcServiceInstance, Class ... otherInterfaces) {
        this.rpcName = rpcName;
        this.javaMethodThisParam = rpcServiceInstance;
        this.initalize(null, otherInterfaces);
    }

    protected void initalize(Class root, Class[] otherInterfaces) {
        HashMap<String, JavaFunctionRpcWrapper> methods = new HashMap<String, JavaFunctionRpcWrapper>();
        if (null != root) {
            otherInterfaces = (Class[])ArrayTools.arrayAppend((Object)root, (Object[])otherInterfaces);
        }
        for (Class cls : otherInterfaces) {
            Method[] ms;
            for (Method m : ms = cls.getMethods()) {
                try {
                    if (!this.mayRegister(m)) continue;
                    JavaFunctionRpcWrapper func = this.wrapFunction(m);
                    methods.put(func.getMethodName(), func);
                }
                catch (Exception e) {
                    LoggingTools.tryLogFormat((Logger)this.LOG, (LoggingDetailLevel)LogLevel.WARNING, (String)"Method: %s", (Object)m);
                    LoggingTools.tryLogSimple((Logger)this.LOG, (LoggingDetailLevel)LogLevel.WARNING, (Throwable)e);
                }
            }
        }
        this.METHODS = Collections.unmodifiableMap(methods);
    }

    @Override
    public boolean mayRegister(Method m) {
        int mod = m.getModifiers();
        if (Modifier.isPublic(mod) && null == m.getAnnotation(Ignore.class) && null == m.getAnnotation(eu.javaexperience.generic.annotations.Ignore.class)) {
            for (Method om : Mirror.getClassData(Object.class).getAllMethods()) {
                if (!om.equals(m)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected JavaFunctionRpcWrapper wrapFunction(Method m) {
        return JavaAsIsFunctionWrapper.wrapJavaFunctionAsIs(m);
    }
}

