/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.function;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.convertFrom.ArrayLike;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.FieldSelectTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.NotatedCaster;
import eu.javaexperience.rpc.RpcFunction;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.function.RpcFunctionParameter;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class JavaFunctionRpcWrapper<C extends RpcRequest>
implements RpcFunction<C, RpcFunctionParameter> {
    protected Method javaMethod;
    protected String name;
    protected RpcFunctionParameter returningType;
    protected RpcFunctionParameter[] params;
    protected static ConcurrentMap<Class, NotatedCaster> WELL_KNOWN_CASTERS = new ConcurrentHashMap<Class, NotatedCaster>();
    protected static ConcurrentMap<Class<?>, NotatedCaster> CASTERS;

    public static JavaFunctionRpcWrapper<RpcRequest> wrapJavaFunction(Method m) {
        JavaFunctionRpcWrapper<RpcRequest> ret = new JavaFunctionRpcWrapper<RpcRequest>();
        ret.javaMethod = m;
        ret.javaMethod.setAccessible(true);
        ret.name = m.getName();
        ret.returningType = JavaFunctionRpcWrapper.createByType(m.getGenericReturnType());
        Type[] params = m.getGenericParameterTypes();
        ret.params = new RpcFunctionParameter[params.length - 1];
        for (int i = 1; i < params.length; ++i) {
            ret.params[i - 1] = JavaFunctionRpcWrapper.createByType(params[i]);
        }
        return ret;
    }

    @Override
    public String getMethodName() {
        return this.name;
    }

    public RpcFunctionParameter[] getParameterClasses() {
        return this.params;
    }

    @Override
    public RpcFunctionParameter getReturningClass() {
        return this.returningType;
    }

    public Method getJavaMethod() {
        return this.javaMethod;
    }

    protected Object[] assembleJavaFunctionParameters(C ctx, Object thisContext, String functionName, Object ... params) {
        Object[] cll = new Object[params.length + 1];
        cll[0] = ctx;
        for (int i = 0; i < params.length; ++i) {
            cll[i + 1] = params[i];
        }
        return cll;
    }

    @Override
    public Object call(C ctx, Object thisContext, String functionName, Object ... params) throws Throwable {
        Object[] cll = this.assembleJavaFunctionParameters(ctx, thisContext, functionName, params);
        try {
            return this.javaMethod.invoke(thisContext, cll);
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof Throwable) {
                throw ex.getCause();
            }
            throw ex;
        }
    }

    protected static int tryGetLength(Object o) {
        if (null != o) {
            if (o.getClass().isArray()) {
                return Array.getLength(o);
            }
            if (o instanceof ArrayLike) {
                return ((ArrayLike)o).size();
            }
            if (o instanceof List) {
                return ((List)o).size();
            }
        }
        return -1;
    }

    protected static Object tryGetIndex(Object o, int i) {
        if (null != o) {
            if (o.getClass().isArray()) {
                return Array.get(o, i);
            }
            if (o instanceof ArrayLike) {
                return ((ArrayLike)o).get(i);
            }
            if (o instanceof List) {
                return ((List)o).get(i);
            }
        }
        return -1;
    }

    public static NotatedCaster arrayCaster(final Class<?> cls) {
        Class<?> component;
        NotatedCaster c;
        if (cls.isArray() && null != (c = JavaFunctionRpcWrapper.tryCreateCaster(component = cls.getComponentType()))) {
            return new NotatedCaster(){

                public Object cast(Object in) {
                    if (null == in) {
                        return null;
                    }
                    if (cls.isAssignableFrom(in.getClass())) {
                        return in;
                    }
                    int len = JavaFunctionRpcWrapper.tryGetLength(in);
                    if (-1 == len) {
                        return null;
                    }
                    Object[] ret = (Object[])Array.newInstance(component, len);
                    for (int i = 0; i < len; ++i) {
                        ret[i] = c.cast(JavaFunctionRpcWrapper.tryGetIndex(in, i));
                    }
                    return ret;
                }

                public String getTypeShortName() {
                    return c.getTypeShortName() + "[]";
                }

                public String getTypeFullQualifiedName() {
                    return c.getTypeFullQualifiedName() + "[]";
                }
            };
        }
        return null;
    }

    public static NotatedCaster tryCreateCaster(Type type) {
        Class<?> cls = JavaFunctionRpcWrapper.extractClass(type);
        if (cls.isArray()) {
            NotatedCaster c = JavaFunctionRpcWrapper.arrayCaster(cls);
            if (null != c) {
                return c;
            }
        } else {
            CastTo c = CastTo.getCasterRestrictlyForTargetClass(cls);
            if (null != c) {
                return c;
            }
        }
        return (NotatedCaster)WELL_KNOWN_CASTERS.get(cls);
    }

    protected static NotatedCaster getDirectCaster(Type type) {
        final Class<?> clss = JavaFunctionRpcWrapper.extractClass(type);
        NotatedCaster ret = (NotatedCaster)CASTERS.get(clss);
        if (null == ret) {
            ret = new NotatedCaster(){

                public Object cast(Object in) {
                    if (null == in) {
                        return null;
                    }
                    if (clss.isAssignableFrom(in.getClass())) {
                        return in;
                    }
                    return null;
                }

                public String getTypeShortName() {
                    return clss.getSimpleName();
                }

                public String getTypeFullQualifiedName() {
                    return clss.getName();
                }
            };
            CASTERS.put(clss, ret);
        }
        return ret;
    }

    public static Class<?> extractClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType t = (ParameterizedType)type;
            return JavaFunctionRpcWrapper.extractClass(t.getRawType());
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType t = (GenericArrayType)type;
            return JavaFunctionRpcWrapper.extractClass(t.getGenericComponentType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return JavaFunctionRpcWrapper.extractClass(tv.getBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            return JavaFunctionRpcWrapper.extractClass(((GenericArrayType)type).getGenericComponentType());
        }
        if (type instanceof WildcardType) {
            // empty if block
        }
        throw new RuntimeException("Can't extract class of type: " + type);
    }

    public static RpcFunctionParameter createByType(Type type) {
        Class<?> cls = JavaFunctionRpcWrapper.extractClass(type);
        if (Void.TYPE == cls || Void.class == cls) {
            return new RpcFunctionParameter(new NotatedCaster(){

                public Object cast(Object in) {
                    return null;
                }

                public String getTypeShortName() {
                    return "void";
                }

                public String getTypeFullQualifiedName() {
                    return "void";
                }
            });
        }
        NotatedCaster c = JavaFunctionRpcWrapper.tryCreateCaster(type);
        if (null != c) {
            return new RpcFunctionParameter(c);
        }
        if (null == cls) {
            throw new RuntimeException("No suitable automatic caster for type: " + type);
        }
        return new RpcFunctionParameter(JavaFunctionRpcWrapper.getDirectCaster(cls));
    }

    public static void teszt(RpcRequest req, int[] values) {
        System.out.println("Values: " + Arrays.toString(values));
    }

    public static void main(String[] args) throws Throwable {
        Method m = JavaFunctionRpcWrapper.class.getMethod("teszt", RpcRequest.class, int[].class);
        JavaFunctionRpcWrapper<RpcRequest> func = JavaFunctionRpcWrapper.wrapJavaFunction(m);
        func.call(null, null, "", new Object[]{new int[]{10, 20}});
    }

    static {
        WELL_KNOWN_CASTERS.put(Map.class, new NotatedCaster(){

            public Object cast(Object in) {
                if (in instanceof Map) {
                    return in;
                }
                if (in instanceof DataObject) {
                    return DataReprezTools.extractToJavaPrimitiveTypes((Object)in);
                }
                SmallMap ret = new SmallMap();
                try {
                    Mirror.extractFieldsToMap((Object)in, (Map)ret, (Mirror.FieldSelector)FieldSelectTools.SELECT_ALL_INSTANCE_FIELD);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ret;
            }

            public String getTypeShortName() {
                return "Map";
            }

            public String getTypeFullQualifiedName() {
                return "java.lang.Map";
            }
        });
        CASTERS = new ConcurrentHashMap();
    }
}

