/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.javaclient;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.multithread.notify.WaitForSingleEvent;
import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.javaclient.JavaRpcClientTools;
import eu.javaexperience.semantic.references.MayNull;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class JavaRpcParallelClient {
    protected EventMediator<DataObject> serverEvents = new EventMediator();
    protected RpcProtocolHandler proto;
    protected AtomicLong trasactionId = new AtomicLong();
    protected LinkedList<JavaClientRpcPendingRequest> pendingRequests = new LinkedList();
    SimplePublish1<DataObject> send;
    SimpleGet<DataObject> receive;
    protected GetBy1<DataObject, DataObject> transactionHandler = req -> {
        JavaClientRpcPendingRequest p = new JavaClientRpcPendingRequest((DataObject)req);
        LinkedList<JavaClientRpcPendingRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            this.pendingRequests.addFirst(p);
        }
        this.sendPacket((DataObject)req);
        while (!p.isResponsed() && !p.isRevoked()) {
            try {
                this.readResponse();
            }
            catch (IOException e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        }
        if (p.isRevoked()) {
            throw new RuntimeException("Request has been revoked.");
        }
        if (!p.isResponsed()) {
            throw new RuntimeException("Response error: null response returned.");
        }
        return p.response;
    };

    public JavaRpcParallelClient(DataSender send, DataReceiver rec, RpcProtocolHandler proto) {
        this.send = o -> {
            try {
                send.send(o);
            }
            catch (IOException e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        };
        this.receive = () -> {
            try {
                return rec.receiveDataObject();
            }
            catch (IOException e) {
                Mirror.propagateAnyway((Throwable)e);
                return null;
            }
        };
        this.proto = proto;
    }

    public JavaRpcParallelClient(SimplePublish1<DataObject> send, SimpleGet<DataObject> rec, RpcProtocolHandler proto) {
        this.send = send;
        this.receive = rec;
        this.proto = proto;
    }

    public EventMediator<DataObject> getServerEventMediator() {
        return this.serverEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPacket(DataObject req) {
        SimplePublish1<DataObject> simplePublish1 = this.send;
        synchronized (simplePublish1) {
            this.send.publish((Object)req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishResponse(DataObject resp) {
        LinkedList<JavaClientRpcPendingRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            for (JavaClientRpcPendingRequest p : this.pendingRequests) {
                if (!p.tryAcceptResponse(resp)) continue;
                this.pendingRequests.remove(p);
                return;
            }
        }
        linkedList = this.serverEvents;
        synchronized (linkedList) {
            this.serverEvents.dispatchEvent((Object)resp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readResponse() throws IOException {
        DataObject rec = null;
        SimpleGet<DataObject> simpleGet = this.receive;
        synchronized (simpleGet) {
            rec = (DataObject)this.receive.get();
        }
        AssertArgument.assertNotNull((Object)rec, (String)"Received packet");
        this.publishResponse(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean revokePendingRequest(JavaClientRpcPendingRequest req) {
        LinkedList<JavaClientRpcPendingRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            boolean ret = this.pendingRequests.remove(req);
            if (ret) {
                req.revoke();
            }
            return ret;
        }
    }

    public <T> T createApiObject(Class<T> cls, @MayNull String namespace) {
        return JavaRpcClientTools.createApiWithTransactionHandler(cls, this.transactionHandler, namespace, this.proto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shudown() {
        LinkedList<JavaClientRpcPendingRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            for (JavaClientRpcPendingRequest p : this.pendingRequests) {
                p.revoke();
            }
        }
    }

    protected class JavaClientRpcPendingRequest
    implements Closeable {
        protected Object originalTid;
        protected final long tid;
        protected DataObject response = null;
        protected boolean revoked = false;
        protected WaitForSingleEvent wait = new WaitForSingleEvent();

        public JavaClientRpcPendingRequest(DataObject req) {
            this.tid = JavaRpcParallelClient.this.trasactionId.incrementAndGet();
            this.originalTid = req.opt("t");
            req.putLong("t", this.tid);
        }

        @Override
        public void close() throws IOException {
            this.revoked = true;
            JavaRpcParallelClient.this.revokePendingRequest(this);
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public boolean isResponsed() {
            return null != this.response;
        }

        public boolean isRevoked() {
            return null != this.response && this.revoked;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean waitResponse(long timeout, TimeUnit unit) throws InterruptedException {
            AssertArgument.assertTrue((!this.isRevoked() ? 1 : 0) != 0, (String)"Request has been revoked");
            this.wait.waitForEvent(timeout, unit);
            AssertArgument.assertTrue((!this.isRevoked() ? 1 : 0) != 0, (String)"Request has been revoked");
            JavaClientRpcPendingRequest javaClientRpcPendingRequest = this;
            synchronized (javaClientRpcPendingRequest) {
                return null != this.response;
            }
        }

        public DataObject ensureResponse(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            return this.ensureResponse(timeout, unit, null);
        }

        public DataObject ensureResponse(long timeout, TimeUnit unit, String errAppendMsg) throws InterruptedException, TimeoutException {
            if (!this.waitResponse(timeout, unit)) {
                throw new TimeoutException("Request (`" + this.tid + "`) not responded within " + timeout + " " + (Object)((Object)unit) + " for the request. " + errAppendMsg);
            }
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void receiveResponse(DataObject data) {
            AssertArgument.assertNotNull((Object)data, (String)"data");
            if (null != this.originalTid) {
                DataReprezTools.put((DataObject)data, (String)"t", (Object)this.originalTid);
            }
            JavaClientRpcPendingRequest javaClientRpcPendingRequest = this;
            synchronized (javaClientRpcPendingRequest) {
                this.response = data;
            }
            this.wait.evenOcurred();
        }

        public boolean tryAcceptResponse(DataObject a) {
            if (this.tid == a.optLong("t", -1L)) {
                try {
                    this.receiveResponse(a);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return true;
            }
            return false;
        }

        public void revoke() {
            this.revoked = true;
            this.wait.evenOcurred();
        }
    }
}

