/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.javaclient;

import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.NotatedCaster;
import eu.javaexperience.rpc.RpcCastTools;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.RpcTools;
import eu.javaexperience.rpc.SimpleRpcSession;
import eu.javaexperience.rpc.bidirectional.RpcClientProtocolHandler;
import eu.javaexperience.rpc.javaclient.JavaRpcParallelClient;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.url.UrlDownloadTools;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class JavaRpcClientTools {
    protected static List<Map.Entry<Class, Class>> mapImpl = new ArrayList<Map.Entry<Class, Class>>();
    protected static List<Map.Entry<Class, Class>> collImpl = new ArrayList<Map.Entry<Class, Class>>();
    protected static final ConcurrentMap<String, Class> CLASS_LOOKUP;

    public static <T> T createApiWithIpPort(Class<T> type, String ip, int port, @MayNull String namespace, RpcProtocolHandler proto) throws IOException {
        Socket s = new Socket(ip, port);
        return JavaRpcClientTools.createApiWithSocket(type, s, namespace, proto);
    }

    public static <T> T createApiWithSocket(Class<T> type, Socket s, @MayNull String namespace, RpcProtocolHandler proto) throws IOException {
        return JavaRpcClientTools.createApiWithTxRx(type, proto.getDefaultCommunicationProtocolPrototype().newDataSender(s.getOutputStream()), proto.getDefaultCommunicationProtocolPrototype().newDataReceiver(s.getInputStream()), namespace, proto);
    }

    public static <T> T createApiWithIOAndProto(Class<T> type, IOStream io, @MayNull String namespace, RpcProtocolHandler proto) throws IOException {
        return JavaRpcClientTools.createApiWithTxRx(type, proto.getDefaultCommunicationProtocolPrototype().newDataSender(io.getOutputStream()), proto.getDefaultCommunicationProtocolPrototype().newDataReceiver(io.getInputStream()), namespace, proto);
    }

    public static <T> T createApiWithTxRx(Class<T> type, final DataSender send, final DataReceiver rec, @MayNull String namespace, RpcProtocolHandler proto) {
        return JavaRpcClientTools.createApiWithTransactionHandler(type, new GetBy1<DataObject, DataObject>(){

            public DataObject getBy(DataObject a) {
                try {
                    send.send(a);
                    return rec.receiveDataObject();
                }
                catch (IOException e) {
                    Mirror.propagateAnyway((Throwable)e);
                    return null;
                }
            }
        }, namespace, proto);
    }

    public static <T> T createApiHttp(Class<T> type, final URL url, @MayNull String namespace, RpcProtocolHandler proto) {
        return JavaRpcClientTools.createApiWithTransactionHandler(type, new GetBy1<DataObject, DataObject>(){

            public DataObject getBy(DataObject a) {
                try {
                    return a.objectFromBlob(UrlDownloadTools.download(null, (URL)url, null, (byte[])a.toBlob()));
                }
                catch (IOException e) {
                    Mirror.propagateAnyway((Throwable)e);
                    return null;
                }
            }
        }, namespace, proto);
    }

    public static <T> Object extractToJavaObject(Object src, Class retType) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException {
        if (null == src) {
            return null;
        }
        if (retType.isAssignableFrom(src.getClass())) {
            return src;
        }
        if (src instanceof DataArray) {
            DataArray arr = (DataArray)src;
            if (retType.isArray()) {
                ArrayList<Object> ret = new ArrayList<Object>();
                Class<?> cls = retType.getComponentType();
                for (int i = 0; i < arr.size(); ++i) {
                    ret.add(JavaRpcClientTools.extractToJavaObject(arr.get(i), cls));
                }
                return ret.toArray((Object[])Array.newInstance(cls, 0));
            }
            for (Map.Entry<Class, Class> a : collImpl) {
                if (!retType.isAssignableFrom(a.getKey())) continue;
                Collection ret = (Collection)a.getValue().newInstance();
                for (int i = 0; i < arr.size(); ++i) {
                    ret.add(JavaRpcClientTools.extractToJavaObject(arr.get(i), Object.class));
                }
                return ret;
            }
        } else if (src instanceof DataObject) {
            DataObject obj = (DataObject)src;
            for (Map.Entry<Class, Class> a : mapImpl) {
                if (!retType.isAssignableFrom(a.getKey())) continue;
                Map ret = (Map)a.getValue().newInstance();
                for (String k : obj.keys()) {
                    ret.put(k, JavaRpcClientTools.extractToJavaObject(obj.get(k), Object.class));
                }
                return ret;
            }
            Iterator<Map.Entry<Class<Object>, Class<Object>>> ret = null;
            ret = obj.has("class") ? Class.forName(obj.getString("class")).newInstance() : retType.newInstance();
            Mirror.ClassData cd = Mirror.getClassData(ret.getClass());
            for (String k : obj.keys()) {
                Field f = cd.getFieldByName(k);
                if (null == f) continue;
                f.set(ret, JavaRpcClientTools.extractToJavaObject(obj.get(k), f.getType()));
            }
            return ret;
        }
        return src;
    }

    protected static Object extractReturnOrThrow(RpcRequest req, Class<?> retType) throws Throwable {
        RpcClientProtocolHandler hand = (RpcClientProtocolHandler)((Object)req.getProtocolHandler());
        Throwable t = hand.extractException(req);
        if (null != t) {
            throw t;
        }
        Object ret = hand.extractReturningValue(req);
        return JavaRpcClientTools.extractToJavaObject(ret, retType);
    }

    public static <T> T createApiWithTransactionHandler(Class<T> type, final GetBy1<DataObject, DataObject> transact, final @MayNull String namespace, final RpcProtocolHandler proto) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{type}, new InvocationHandler(){
            AtomicLong tid = new AtomicLong();
            SimpleRpcSession session = new SimpleRpcSession(proto);

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (null == args) {
                    args = Mirror.emptyObjectArray;
                }
                String func = method.getName();
                long id = this.tid.incrementAndGet();
                RpcRequest req = RpcTools.createClientNamespaceInvocation(this.session, id, namespace, null, method.getName(), args);
                DataObject ret = (DataObject)transact.getBy((Object)req.getRequestData());
                req.fillResponse(ret);
                Object ex = JavaRpcClientTools.extractReturnOrThrow(req, method.getReturnType());
                if (null != ex) {
                    Object e;
                    Class<?> r = method.getReturnType();
                    if (r.isAssignableFrom(ex.getClass())) {
                        return ex;
                    }
                    NotatedCaster caster = RpcCastTools.tryCreateCaster(r);
                    if (null != caster && null != (e = caster.cast(ex))) {
                        return e;
                    }
                }
                return ex;
            }
        });
    }

    public static JavaRpcParallelClient createClientWithIpPort(String ip, int port, RpcProtocolHandler proto) throws IOException {
        Socket s = new Socket(ip, port);
        return JavaRpcClientTools.createClientWithSocket(s, proto);
    }

    public static JavaRpcParallelClient createClientWithSocket(Socket s, RpcProtocolHandler proto) throws IOException {
        return JavaRpcClientTools.createClientWithTxRx(proto.getDefaultCommunicationProtocolPrototype().newDataSender(s.getOutputStream()), proto.getDefaultCommunicationProtocolPrototype().newDataReceiver(s.getInputStream()), proto);
    }

    public static JavaRpcParallelClient createClientWithIOAndProto(IOStream io, RpcProtocolHandler proto) throws IOException {
        return JavaRpcClientTools.createClientWithTxRx(proto.getDefaultCommunicationProtocolPrototype().newDataSender(io.getOutputStream()), proto.getDefaultCommunicationProtocolPrototype().newDataReceiver(io.getInputStream()), proto);
    }

    public static JavaRpcParallelClient createClientWithTxRx(DataSender send, DataReceiver rec, RpcProtocolHandler proto) {
        return new JavaRpcParallelClient(send, rec, proto);
    }

    public static JavaRpcParallelClient createClientHttp(URL url, RpcProtocolHandler proto) {
        return new JavaRpcParallelClient((SimplePublish1<DataObject>)((SimplePublish1)obj -> {
            try {
                UrlDownloadTools.download(null, (URL)url, null, (byte[])obj.toBlob());
            }
            catch (IOException e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        }), (SimpleGet<DataObject>)((SimpleGet)() -> {
            try {
                return proto.getDefaultCommunicationProtocolPrototype().objectFromBlob(UrlDownloadTools.download(null, (URL)url, null));
            }
            catch (IOException e) {
                Mirror.propagateAnyway((Throwable)e);
                return null;
            }
        }), proto);
    }

    static {
        mapImpl.add((Map.Entry<Class, Class>)new KeyVal(ConcurrentMap.class, ConcurrentHashMap.class));
        mapImpl.add((Map.Entry<Class, Class>)new KeyVal(Map.class, HashMap.class));
        collImpl.add((Map.Entry<Class, Class>)new KeyVal(Set.class, HashSet.class));
        collImpl.add((Map.Entry<Class, Class>)new KeyVal(List.class, ArrayList.class));
        collImpl.add((Map.Entry<Class, Class>)new KeyVal(Collection.class, ArrayList.class));
        CLASS_LOOKUP = new ConcurrentHashMap<String, Class>();
    }
}

