/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc;

import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.RpcSession;
import eu.javaexperience.semantic.references.MayNotNull;
import java.util.Map;

public class SimpleRpcRequest
implements RpcRequest {
    protected final RpcSession session;
    protected final DataObject request;
    protected DataObject response;
    protected final Map<String, Object> reqProps = new SmallMap();

    public SimpleRpcRequest(RpcSession session) {
        this.session = session;
        this.request = session.getDefaultRpcProtocolHandler().getDefaultCommunicationProtocolPrototype().newObjectInstance();
    }

    public SimpleRpcRequest(RpcSession session, DataObject request) {
        this.session = session;
        this.request = request;
    }

    @Override
    @MayNotNull
    public RpcSession getRpcSession() {
        return this.session;
    }

    @Override
    @MayNotNull
    public RpcProtocolHandler getProtocolHandler() {
        return this.session.getDefaultRpcProtocolHandler();
    }

    @Override
    public DataObject getRequestData() {
        return this.request;
    }

    @Override
    public DataObject getResponseData() {
        return this.response;
    }

    public Map<String, Object> getRequestProperties() {
        return this.reqProps;
    }

    @Override
    public DataObject fillResponse(DataObject response) {
        DataObject prev = this.response;
        this.response = response;
        return prev;
    }
}

