/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.exceptions.OperationSuccessfullyEnded;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOStream;
import eu.javaexperience.io.IOStreamServer;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.RpcDefaultProtocol;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.RpcSession;
import eu.javaexperience.rpc.RpcSessionTools;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.server.AbstractServer;
import java.io.Closeable;
import java.io.IOException;

public abstract class SocketRpcServer<SOCK extends IOStream, SESS extends RpcSession>
extends AbstractServer<SOCK>
implements Closeable {
    protected final RpcProtocolHandler handler;

    public SocketRpcServer(IOStreamServer<SOCK> srv, int initialWorkerCount, RpcProtocolHandler handler) {
        super(srv, initialWorkerCount);
        this.handler = handler;
        AssertArgument.assertNotNull((Object)this.handler, (String)"rpc protocolhandler");
    }

    public SocketRpcServer(IOStreamServer<SOCK> srv, int initialWorkerCount) {
        this(srv, initialWorkerCount, new RpcDefaultProtocol((DataCommon)new DataObjectJsonImpl()));
    }

    protected Object createExtraContext(SOCK sock, SESS session) {
        return null;
    }

    protected void destoryExtraContext(Object o) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(SOCK sock) {
        this.manageLoad();
        DataCommon prototype = this.handler.getDefaultCommunicationProtocolPrototype();
        DataReceiver rec = null;
        RpcSession session = null;
        Object ctx = null;
        try {
            DataSender ds = prototype.newDataSender(sock.getOutputStream());
            SimplePublish1 response = resp -> {
                DataSender dataSender = ds;
                synchronized (dataSender) {
                    try {
                        ds.send(resp);
                    }
                    catch (IOException e) {
                        Mirror.propagateAnyway((Throwable)e);
                    }
                }
            };
            rec = prototype.newDataReceiver(sock.getInputStream());
            session = this.init(sock);
            RpcSessionTools.setCurrentRpcSession(session);
            ctx = this.createExtraContext(sock, session);
            while (!sock.isClosed()) {
                try {
                    DataObject req = rec.receiveDataObject();
                    if (null == req) {
                        break;
                    }
                    this.responseRequest((SimplePublish1<DataObject>)response, session, req, ctx);
                }
                catch (OperationSuccessfullyEnded skk) {}
            }
        }
        catch (Throwable e) {
            this.onException(e);
        }
        finally {
            try {
                if (null != session) {
                    session.destroy();
                }
            }
            catch (Exception ds) {}
            RpcSessionTools.setCurrentRpcSession(null);
            IOTools.silentClose(sock);
        }
        this.manageLoad();
    }

    protected void onException(Throwable t) {
        if (!(t instanceof IOException)) {
            t.printStackTrace();
        }
    }

    protected void responseRequest(SimplePublish1<DataObject> response, SESS sess, DataObject request, Object extraCtx) {
        DataObject resp = this.handleRequest(sess, request);
        if (null != resp) {
            response.publish((Object)resp);
        }
    }

    protected abstract SESS init(SOCK var1);

    @MayNull
    protected abstract DataObject handleRequest(SESS var1, DataObject var2);

    @Override
    public void close() throws IOException {
        this.srv.close();
    }
}

