/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc.javaclient;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReceiver;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.patterns.behavioral.mediator.EventMediator;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.javaclient.JavaRpcClientTools;
import eu.javaexperience.semantic.references.MayNull;
import java.io.Closeable;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

public class JavaRpcParallelClient {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("JavaRpcParallelClient"));
    protected EventMediator<DataObject> serverEvents = new EventMediator();
    protected RpcProtocolHandler proto;
    protected AtomicLong trasactionId = new AtomicLong();
    protected LinkedList<JavaClientRpcPendingRequest> pendingRequests = new LinkedList();
    SimplePublish1<DataObject> send;
    SimpleGet<DataObject> receive;
    protected Thread reader;
    protected boolean readResponses = false;
    protected GetBy1<DataObject, DataObject> transactionHandler = req -> {
        JavaClientRpcPendingRequest p = new JavaClientRpcPendingRequest((DataObject)req);
        LinkedList<JavaClientRpcPendingRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            this.pendingRequests.addFirst(p);
        }
        this.sendPacket((DataObject)req);
        try {
            p.lock.acquire();
        }
        catch (InterruptedException e) {
            Mirror.propagateAnyway((Throwable)e);
        }
        if (p.isRevoked()) {
            throw new RuntimeException("Request has been revoked.");
        }
        if (!p.isResponsed()) {
            throw new RuntimeException("Response error: null response returned.");
        }
        return p.response;
    };

    public JavaRpcParallelClient(DataSender send, DataReceiver rec, RpcProtocolHandler proto) {
        this.send = o -> {
            try {
                send.send(o);
            }
            catch (IOException e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        };
        this.receive = () -> {
            try {
                return rec.receiveDataObject();
            }
            catch (IOException e) {
                Mirror.propagateAnyway((Throwable)e);
                return null;
            }
        };
        this.proto = proto;
    }

    public JavaRpcParallelClient(SimplePublish1<DataObject> send, SimpleGet<DataObject> rec, RpcProtocolHandler proto) {
        this.send = send;
        this.receive = rec;
        this.proto = proto;
    }

    public EventMediator<DataObject> getServerEventMediator() {
        return this.serverEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPacket(DataObject req) {
        if (LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"Sending packet `%s`", (Object)req);
        }
        SimplePublish1<DataObject> simplePublish1 = this.send;
        synchronized (simplePublish1) {
            this.send.publish((Object)req);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishResponse(DataObject resp) {
        JavaClientRpcPendingRequest target = null;
        LinkedList<JavaClientRpcPendingRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            for (JavaClientRpcPendingRequest p : this.pendingRequests) {
                if (!p.isResponseMatches(resp)) continue;
                this.pendingRequests.remove(p);
                target = p;
                break;
            }
        }
        if (null != target) {
            if (LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"Answer request `%s` with response `%s`", (Object)target, (Object)resp);
            }
            target.receiveResponse(resp);
        } else {
            if (LOG.mayLog((LoggingDetailLevel)LogLevel.TRACE)) {
                LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.TRACE, (String)"Server event received: `%s`", (Object)resp);
            }
            linkedList = this.serverEvents;
            synchronized (linkedList) {
                this.serverEvents.dispatchEvent((Object)resp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readResponse() {
        DataObject rec = null;
        SimpleGet<DataObject> simpleGet = this.receive;
        synchronized (simpleGet) {
            rec = (DataObject)this.receive.get();
        }
        AssertArgument.assertNotNull((Object)rec, (String)"Received packet");
        this.publishResponse(rec);
    }

    public synchronized void startPacketRead() {
        if (null != this.reader) {
            throw new RuntimeException("Packet reader thread already started");
        }
        this.readResponses = true;
        this.reader = new Thread(){

            @Override
            public void run() {
                while (JavaRpcParallelClient.this.readResponses) {
                    JavaRpcParallelClient.this.readResponse();
                }
            }
        };
        this.reader.start();
    }

    public synchronized void stopPacketRead() {
        if (null == this.reader) {
            throw new RuntimeException("Packet reader thread not started");
        }
        this.readResponses = false;
        this.reader.interrupt();
        this.reader = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean revokePendingRequest(JavaClientRpcPendingRequest req) {
        LinkedList<JavaClientRpcPendingRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            boolean ret = this.pendingRequests.remove(req);
            if (ret) {
                req.revoke();
            }
            return ret;
        }
    }

    public <T> T createApiObject(Class<T> cls, @MayNull String namespace) {
        return JavaRpcClientTools.createApiWithTransactionHandler(cls, this.transactionHandler, namespace, this.proto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shudown() {
        LinkedList<JavaClientRpcPendingRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            for (JavaClientRpcPendingRequest p : this.pendingRequests) {
                p.revoke();
            }
        }
    }

    protected class JavaClientRpcPendingRequest
    implements Closeable {
        protected Object originalTid;
        protected final long tid;
        protected DataObject response = null;
        protected boolean revoked = false;
        protected Semaphore lock = new Semaphore(0);

        public JavaClientRpcPendingRequest(DataObject req) {
            this.tid = JavaRpcParallelClient.this.trasactionId.incrementAndGet();
            this.originalTid = req.opt("t");
            req.putLong("t", this.tid);
        }

        @Override
        public void close() throws IOException {
            this.revoked = true;
            JavaRpcParallelClient.this.revokePendingRequest(this);
        }

        protected void finalize() throws Throwable {
            this.close();
        }

        public synchronized boolean isResponsed() {
            return null != this.response;
        }

        public synchronized boolean isRevoked() {
            return null != this.response && this.revoked;
        }

        public boolean waitResponse(long timeout, TimeUnit unit) throws InterruptedException {
            AssertArgument.assertTrue((!this.isRevoked() ? 1 : 0) != 0, (String)"Request has been revoked");
            this.lock.tryAcquire(timeout, unit);
            AssertArgument.assertTrue((!this.isRevoked() ? 1 : 0) != 0, (String)"Request has been revoked");
            return this.isResponsed();
        }

        public DataObject ensureResponse(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            return this.ensureResponse(timeout, unit, null);
        }

        public DataObject ensureResponse(long timeout, TimeUnit unit, String errAppendMsg) throws InterruptedException, TimeoutException {
            if (!this.waitResponse(timeout, unit)) {
                throw new TimeoutException("Request (`" + this.tid + "`) not responded within " + timeout + " " + (Object)((Object)unit) + " for the request. " + errAppendMsg);
            }
            return this.response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void receiveResponse(DataObject data) {
            AssertArgument.assertNotNull((Object)data, (String)"data");
            if (null != this.originalTid) {
                DataReprezTools.put((DataObject)data, (String)"t", (Object)this.originalTid);
            }
            JavaClientRpcPendingRequest javaClientRpcPendingRequest = this;
            synchronized (javaClientRpcPendingRequest) {
                this.response = data;
            }
            this.lock.release(Integer.MAX_VALUE);
        }

        public boolean isResponseMatches(DataObject a) {
            return this.tid == a.optLong("t", -1L);
        }

        public void revoke() {
            this.revoked = true;
            this.lock.release(Integer.MAX_VALUE);
        }
    }
}

