/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.rpc;

import eu.javaexperience.asserts.AssertArgument;
import eu.javaexperience.collection.map.KeyVal;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.convertFrom.DataWrapper;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.RpcProtocolHandler;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcDefaultProtocol;
import eu.javaexperience.rpc.function.RpcFunctionParameter;
import eu.javaexperience.text.Format;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class RpcDefaultProtocol
implements RpcProtocolHandler {
    protected final DataCommon transferDatatype;
    protected DataWrapper dataWrapper;
    protected static final Mirror.FieldSelector fs = new Mirror.FieldSelector(true, Mirror.Visibility.Public, Mirror.BelongTo.Instance, Mirror.Select.All, Mirror.Select.IsNot, Mirror.Select.IsNot);
    protected Mirror.FieldSelector object_mapper_field_selector = fs;
    protected static List<Map.Entry<Class, Class>> mapImpl = new ArrayList<Map.Entry<Class, Class>>();
    protected static List<Map.Entry<Class, Class>> collImpl = new ArrayList<Map.Entry<Class, Class>>();

    public RpcDefaultProtocol(DataCommon proto) {
        this(proto, BidirectionalRpcDefaultProtocol.DEFAULT_RPC_DATA_WRAPPER);
    }

    public RpcDefaultProtocol(DataCommon proto, DataWrapper wrapper) {
        this.transferDatatype = proto;
        AssertArgument.assertNotNull((Object)this.transferDatatype, (String)"transferDatatype");
        this.dataWrapper = wrapper;
        AssertArgument.assertNotNull((Object)this.dataWrapper, (String)"dataWrapper");
    }

    public void setObjectMapperFieldSelector(Mirror.FieldSelector fs) {
        AssertArgument.assertNotNull((Object)fs, (String)"fieldSelector");
        this.object_mapper_field_selector = fs;
    }

    public Object wrap(Object in) {
        if (null == in) {
            return null;
        }
        if (null != DataReprezTools.isStorable((Object)in)) {
            return in;
        }
        return this.dataWrapper.wrap(this.dataWrapper, this.transferDatatype, in);
    }

    public Object extract(Object in) {
        return this.extract(null, in);
    }

    public Object extractValue(DataObject object, String key) {
        return this.extract(object.get(key));
    }

    public Object extractValue(DataArray array, int index) {
        return this.extract(array.get(index));
    }

    @Override
    public Object extractThisContext(RpcRequest req) {
        DataObject obj = req.getRequestData();
        if (obj.has("_")) {
            return this.extract(obj.get("_"));
        }
        return null;
    }

    public boolean putValue(DataObject object, String key, Object value) {
        return null != DataReprezTools.put((DataObject)object, (String)key, (Object)this.wrap(value));
    }

    public boolean putValue(DataArray arr, int index, Object value) {
        return null != DataReprezTools.put((DataArray)arr, (int)index, (Object)this.wrap(value));
    }

    @Override
    public DataCommon getDefaultCommunicationProtocolPrototype() {
        return this.transferDatatype;
    }

    @Override
    public String extractNamespace(RpcRequest requestObject) {
        return requestObject.getRequestData().optString("N");
    }

    @Override
    public String getPacketTraceId(RpcRequest requestObject) {
        DataObject obj = requestObject.getRequestData();
        if (obj.has("t")) {
            return requestObject.getRequestData().get("t").toString();
        }
        return null;
    }

    @Override
    public String getRequestFunctionName(RpcRequest requestObject) {
        return requestObject.getRequestData().optString("f");
    }

    protected void putPacketTrace(RpcRequest request, DataObject result) {
        String trace = this.getPacketTraceId(request);
        if (null != trace) {
            result.putString("t", trace);
        }
    }

    @Override
    public Object[] extractParameters(RpcRequest requestObject) {
        DataArray o = requestObject.getRequestData().optArray("p");
        if (null != o) {
            Object[] ret = new Object[o.size()];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.extract(o.get(i));
            }
            return ret;
        }
        return Mirror.emptyObjectArray;
    }

    @Override
    public DataObject createEmptyResponsePacket(RpcRequest request) {
        DataObject ret = this.transferDatatype.newObjectInstance();
        String trace = this.getPacketTraceId(request);
        if (null != trace) {
            ret.putString("t", trace);
        }
        return ret;
    }

    @Override
    public DataObject createReturningValue(RpcRequest req, Object result) {
        DataObject ret = this.transferDatatype.newObjectInstance();
        RpcDefaultProtocol.putObject(ret, "r", this.wrap(result));
        this.putPacketTrace(req, ret);
        return ret;
    }

    @Override
    public DataObject createException(RpcRequest req, Throwable exception) {
        DataObject ret = RpcDefaultProtocol.reportException((DataCommon)req.getRequestData(), exception);
        this.putPacketTrace(req, ret);
        return ret;
    }

    public static DataObject reportException(DataCommon proto, Throwable t) {
        DataObject ret = proto.newObjectInstance();
        DataObject ex = proto.newObjectInstance();
        String msg = t.getMessage();
        if (null != msg) {
            ex.putString("message", msg);
        }
        ex.putString("type", t.getClass().getSimpleName());
        ex.putString("detail", Format.getPrintedStackTrace((Throwable)t));
        RpcDefaultProtocol.putObject(ret, "e", ex);
        return ret;
    }

    public static Object castObject(Object in, RpcFunctionParameter param) {
        return param.getCaster().cast(in);
    }

    public static void putObject(DataObject ret, String key, Object value) {
        DataReprezTools.put((DataObject)ret, (String)key, (Object)value);
    }

    @Override
    public Object extract(Class retType, Object src) {
        if (null == src || this.transferDatatype.isNull(src)) {
            return null;
        }
        if (null != retType && retType.isAssignableFrom(src.getClass())) {
            return src;
        }
        if (null != retType && src instanceof DataArray) {
            try {
                DataArray arr = (DataArray)src;
                if (retType.isArray()) {
                    ArrayList<Object> ret = new ArrayList<Object>();
                    Class<?> clazz = retType.getComponentType();
                    for (int i = 0; i < arr.size(); ++i) {
                        ret.add(this.extract(clazz, arr.get(i)));
                    }
                    return ret.toArray((Object[])Array.newInstance(clazz, 0));
                }
                for (Map.Entry<Class, Class> entry : collImpl) {
                    if (!retType.isAssignableFrom(entry.getKey())) continue;
                    Collection ret = (Collection)entry.getValue().newInstance();
                    for (int i = 0; i < arr.size(); ++i) {
                        ret.add(this.extract(Object.class, arr.get(i)));
                    }
                    return ret;
                }
            }
            catch (Exception arr) {}
        } else if (src instanceof DataObject) {
            try {
                DataObject obj = (DataObject)src;
                if (null != retType) {
                    for (Map.Entry entry : mapImpl) {
                        if (!retType.isAssignableFrom((Class)entry.getKey())) continue;
                        Map ret = (Map)((Class)entry.getValue()).newInstance();
                        for (String k : obj.keys()) {
                            ret.put(k, this.extract(Object.class, obj.get(k)));
                        }
                        return ret;
                    }
                }
                Object ret = this.createObject(retType, obj);
                Mirror.ClassData classData = Mirror.getClassData(ret.getClass());
                for (String k : obj.keys()) {
                    Field f = classData.getFieldByName(k);
                    if (null == f) continue;
                    f.set(ret, this.extract(f.getType(), obj.get(k)));
                }
                return ret;
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
            }
        }
        return src;
    }

    protected Object createObject(Class request, DataObject obj) throws Exception {
        if (obj.has("class")) {
            return Class.forName(obj.getString("class")).newInstance();
        }
        return request.newInstance();
    }

    static {
        mapImpl.add((Map.Entry<Class, Class>)new KeyVal(ConcurrentMap.class, ConcurrentHashMap.class));
        mapImpl.add((Map.Entry<Class, Class>)new KeyVal(Map.class, HashMap.class));
        collImpl.add((Map.Entry<Class, Class>)new KeyVal(Set.class, HashSet.class));
        collImpl.add((Map.Entry<Class, Class>)new KeyVal(List.class, ArrayList.class));
        collImpl.add((Map.Entry<Class, Class>)new KeyVal(Collection.class, ArrayList.class));
    }
}

