/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.saac;

import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.saac.SaacEnv;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import org.json.JSONObject;

public class SaacTools {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("SaacTools", (LoggingDetailLevel)LogLevel.INFO));

    public static void execScript(String file, Map<String, Object> env) throws FileNotFoundException, IOException {
        Object o = SaacTools.loadScriptRoot(file);
        if (o instanceof SimplePublish1) {
            ((SimplePublish1)o).publish(env);
        } else if (o instanceof GetBy1) {
            ((GetBy1)o).getBy(env);
        } else if (o instanceof SimpleCall) {
            ((SimpleCall)o).call();
        }
    }

    public static Object loadScriptRoot(String file) throws FileNotFoundException, IOException {
        String str = IOTools.getFileContents((String)file);
        SaacEnv env = SaacEnv.create(null, (DataObject)new DataObjectJsonImpl(new JSONObject(str)), null);
        return env.root;
    }

    public static void assertNotRuntimeClosure(Object ret) {
        if (ret instanceof SaacEnv.SaacClosureInfo) {
            throw new RuntimeException("Closure is wrapped for runtime execution");
        }
    }

    public static void assertTypeOf(Type t, Object ret) {
        if (!(ret instanceof GetBy1)) {
            throw new RuntimeException("Wrong root type in the script file: " + t.getTypeName() + " required, " + ret.getClass().getTypeName() + " given");
        }
    }

    public static GetBy1<Boolean, ?> loadScriptFile(String file) {
        try {
            Object ret = SaacTools.loadScriptRoot(file);
            SaacTools.assertNotRuntimeClosure(ret);
            SaacTools.assertTypeOf(GetBy1.class, ret);
            return (GetBy1)ret;
        }
        catch (Exception e) {
            LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Can't parse script file: %s\n", (Object)file);
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }
}

