/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.saac;

import eu.javaexperience.collection.map.NullMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.javaImpl.DataObjectJavaImpl;
import eu.javaexperience.functional.saac.Functions;
import eu.javaexperience.saac.SaacEnv;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SaacFunctionCollection {
    protected Map<String, Functions.PreparedFunction> functionSet = new HashMap<String, Functions.PreparedFunction>();

    protected void registerClasses(Class<?> ... clss) {
        ArrayList<Functions.PreparedFunction> funcs = new ArrayList<Functions.PreparedFunction>();
        for (Class<?> cls : clss) {
            Functions.collectFunctions(funcs, cls);
        }
        for (Functions.PreparedFunction f : funcs) {
            this.functionSet.put(f.getId(), f);
        }
    }

    public SaacFunctionCollection(Class ... functionClasses) {
        this.registerClasses(functionClasses);
    }

    public Map<String, Functions.PreparedFunction> getFunctions() {
        return this.functionSet;
    }

    public <T> T createFunction(Class<T> ret, Map<String, Object> func) {
        return this.createFunction(ret, false, func);
    }

    public <T> T createFunction(Class<T> ret, boolean envDepend, Map<String, Object> func) {
        SaacEnv env = SaacEnv.create(this.functionSet, (DataObject)new DataObjectJavaImpl(func), ret);
        Object root = env.getRoot();
        if (!envDepend && root instanceof SaacEnv.SaacGetByWrapper) {
            root = ((SaacEnv.SaacGetByWrapper)root).getBy(NullMap.instance);
        }
        return (T)root;
    }

    public <T> T createEnvFunction(Class<T> cls, Map<String, Object> impl) {
        return this.createFunction(cls, true, impl);
    }
}

