/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.saac;

import eu.javaexperience.annotation.FunctionDescription;
import eu.javaexperience.annotation.FunctionVariableDescription;
import eu.javaexperience.collection.map.NullMap;
import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.collection.map.SmallMap;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.functional.saac.AutocompleteProvider;
import eu.javaexperience.functional.saac.FunctionCreator;
import eu.javaexperience.functional.saac.Functions;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.log.ThreadLocalHookableLogFacility;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.resource.ReferenceCounted;
import eu.javaexperience.rpc.JavaClassRpcFunctions;
import eu.javaexperience.rpc.SimpleRpcRequest;
import eu.javaexperience.rpc.SimpleRpcSession;
import eu.javaexperience.saac.SaacEnv;
import eu.javaexperience.saac.SaacSession;
import eu.javaexperience.saac.exceptions.SaacException;
import eu.javaexperience.text.Format;
import eu.javaexperience.verify.TranslationFriendlyValidationEntry;
import java.io.PrintWriter;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class SaacRpc {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("SaacRpc"));
    public static final JavaClassRpcFunctions<SimpleRpcRequest> DISPATCH = new JavaClassRpcFunctions(SaacRpc.class);
    public static final String SAAC_FUNCTION_SET_KEY = "SAAC_FUNCTIONSET";
    protected static final String SAAC_SESSION_KEY = "SAAC_EXECUTION";

    @FunctionDescription(functionDescription="Sets the given parameters on the current Saac session, hence this values can be used int the PARAM variable.\n This feature has effect only in execution mode, not affects the stored functions.", parameters={@FunctionVariableDescription(description="Parameters in js object/map/associative array style.", mayNull=false, paramName="PARAM", type=Map.class)}, returning=@FunctionVariableDescription(description="", mayNull=false, paramName="", type=FunctionDescriptor.class))
    public static void setQueryParams(SimpleRpcRequest req, Map<String, Object> ps) {
        SimpleRpcSession sess = (SimpleRpcSession)req.getRpcSession();
        if (null != ps) {
            sess.put("PARAM", ps);
        }
    }

    @FunctionDescription(functionDescription="List all available functions.", parameters={}, returning=@FunctionVariableDescription(description="Collection of function descriptors.", mayNull=false, paramName="", type=FunctionDescriptor[].class))
    public static FunctionDescriptor[] listFunctions(SimpleRpcRequest req) {
        Map<String, Functions.PreparedFunction> fset = SaacRpc.getSessionFunctionSet((SimpleRpcSession)req.getRpcSession());
        Collection<Functions.PreparedFunction> fs = fset.values();
        FunctionDescriptor[] ret = new FunctionDescriptor[fs.size()];
        int i = 0;
        for (Functions.PreparedFunction f : fs) {
            ret[i++] = new FunctionDescriptor(f);
        }
        return ret;
    }

    @FunctionDescription(functionDescription="Offers functions/enums that can be accepted by the specified function's specified argument (by index).\nCurrently Saac RPC not provide type specifications from the returning and parameter types, and can't provide \ntype bounding instructions (eg is KeyVal<String, HashMap<Boolean,GetBy1<String,Object>>> suitable for ? extends Entry<String, ? extends Map<Boolean,GetBy1>>)\nSo in this version, you should get an offer. Eg.: if user wants to edit the 0th argument of function.aggregates.countUsers(GetBy1<Boolean,User> criteria)\n you might\ncall this function: offerForType(\\\"function.aggregates.countUsers\\\", 0, false, \\\"\\\", 0,0) to get the list of suitable functions that returns GetBy1<Boolean, User> functionObject.\nNot that if the target type is an enum, enumeration elements and functions that return that class of enum is returned.\nAlso note that an argument might have custom AutocompleteProvider, which make possible to promt application specific strings, eg:\ngetRedisInteger(String key) [key might be prompted as string]", parameters={@FunctionVariableDescription(description="Id of the receiver function.", mayNull=false, paramName="functionId", type=String.class), @FunctionVariableDescription(description="Index of the parent's paramter count.", mayNull=false, paramName="index", type=int.class), @FunctionVariableDescription(description="Is the function variadic?", mayNull=false, paramName="isVariadic", type=boolean.class), @FunctionVariableDescription(description="Search term, result may be filtered by this fraction of string.", mayNull=true, paramName="", type=String.class), @FunctionVariableDescription(description="Where the user's cursor stands in the given term.", mayNull=true, paramName="cursorStartIndex", type=Integer.class), @FunctionVariableDescription(description="", mayNull=true, paramName="cursorEndIndex", type=Integer.class)}, returning=@FunctionVariableDescription(description="Collection of function descriptors.", mayNull=false, paramName="", type=FunctionDescriptor[].class))
    public static Object offerForType(SimpleRpcRequest req, String functionId, Integer index, Boolean variadic, String term, Integer cursorStartIndex, Integer cursorEndIndex) {
        Functions.Param p;
        AutocompleteProvider acp;
        ArrayList<Object> ret = new ArrayList<Object>();
        Map<String, Functions.PreparedFunction> INDEX = SaacRpc.getSessionFunctionSet((SimpleRpcSession)req.getRpcSession());
        Functions.PreparedFunction parentFunction = INDEX.get(functionId);
        if (null == parentFunction) {
            return null;
        }
        Functions.Param[] ps = parentFunction.getArgs();
        if (0 == ps.length) {
            return Mirror.emptyObjectArray;
        }
        if (ps.length <= index) {
            index = ps.length - 1;
        }
        if (null != (acp = (p = ps[index]).getAutocompleteProvider())) {
            if (null == cursorStartIndex) {
                cursorStartIndex = 0;
            }
            if (null == cursorEndIndex) {
                cursorEndIndex = 0;
            }
            if (cursorEndIndex < cursorStartIndex) {
                cursorEndIndex = cursorStartIndex;
            }
            acp.offerElement(term, cursorStartIndex, cursorEndIndex);
        }
        SaacRpc.offerTypeV1(ret, INDEX, p, Boolean.TRUE == variadic);
        return ret.toArray();
    }

    protected static void offerTypeV1(List<Object> offers, Map<String, Functions.PreparedFunction> INDEX, Functions.Param p, boolean variadic) {
        SaacRpc.offerTypeV1(offers, INDEX, p.getType(), variadic);
    }

    protected static void offerTypeV1(List<Object> offers, Map<String, Functions.PreparedFunction> INDEX, Type req, boolean variadic) {
        Class<?> reqType = Mirror.extracClass((Type)req);
        if (variadic) {
            req = reqType.getComponentType();
            reqType = reqType.getComponentType();
        }
        if (reqType.isEnum()) {
            for (Enum e : (Enum[])reqType.getEnumConstants()) {
                offers.add(new _enum(e));
            }
        }
        if (req instanceof GenericArrayType) {
            req = ((GenericArrayType)req).getGenericComponentType();
        }
        Collection<Functions.PreparedFunction> pps = INDEX.values();
        for (Functions.PreparedFunction pp : pps) {
            Type fret = pp.getReturning().getType();
            if (!SaacRpc.isAcceptable(req, fret)) continue;
            offers.add(new FunctionDescriptor(pp));
        }
    }

    @FunctionDescription(functionDescription="Offers functions/enums that can be accepted by the specified function's specified argument (by index).\nThis version is take care about type Also note that an argument might have custom AutocompleteProvider, which make possible to promt application specific strings, eg:\ngetRedisInteger(String key) [key might be prompted as string]", parameters={@FunctionVariableDescription(description="The function tree from the context.", mayNull=false, paramName="function", type=String.class), @FunctionVariableDescription(description="UUID of the receiver function in the function tree.", mayNull=false, paramName="uuid", type=String.class), @FunctionVariableDescription(description="Index of the parent's paramter count.", mayNull=false, paramName="index", type=int.class)}, returning=@FunctionVariableDescription(description="Collection of function descriptors.", mayNull=false, paramName="", type=FunctionDescriptor[].class))
    public static Object[] accurateOfferV1(String tree, String functionUUID, int index) {
        return null;
    }

    @FunctionDescription(functionDescription="Validates every function connections (This function not implmented yet.). Because users can give any kind of functions as\n an argument of other function, they can broke the \"connections\". \nWarning levels:\n\t- NOTICE: If parameter matcher exacly the requested type.\n\t- INFO: If parameter is wrapped automatically eg.: requested function is a `void function(T p1, T p2)` and the given method is `void function()` which can be assembled by relaying the call to the requested type without parameters\n\t- WARNING: Saac supports environment variables that can be given anywhere as a given parameter, and will be fetched and used in runtime.\t- ERROR: On incompatible function composition (Requested and given functions are incompatible types.).", parameters={@FunctionVariableDescription(description="Serialized function.", mayNull=false, paramName="function", type=DataObject.class)}, returning=@FunctionVariableDescription(description="Validation results for every entry.", mayNull=false, paramName="", type=List.class))
    public static List<TranslationFriendlyValidationEntry> compileAndCheck(SimpleRpcRequest req, DataObject function) {
        Map INDEX = (Map)((SimpleRpcSession)req.getRpcSession()).get(SAAC_FUNCTION_SET_KEY);
        ArrayList<TranslationFriendlyValidationEntry> ret = new ArrayList<TranslationFriendlyValidationEntry>();
        try {
            SaacRpc.parse(INDEX, function);
        }
        catch (SaacException e) {
            ret.add(new TranslationFriendlyValidationEntry("saac_error", e.toDetailedMessage(), (Map)new OneShotMap((Object)"stack_trace", (Object)Format.getPrintedStackTrace((Throwable)e))));
        }
        catch (Exception e) {
            ret.add(new TranslationFriendlyValidationEntry("error", Format.getPrintedStackTrace((Throwable)e), (Map)NullMap.instance));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FunctionDescription(functionDescription="Executes the constructed function.", parameters={@FunctionVariableDescription(description="Serialized function.", mayNull=false, paramName="function", type=DataObject.class)}, returning=@FunctionVariableDescription(description="Return value of the root function", mayNull=false, paramName="", type=FunctionDescriptor[].class))
    public static Object execute(SimpleRpcRequest req, DataObject fs) {
        SimpleRpcSession rpcSess = (SimpleRpcSession)req.getRpcSession();
        SaacSession saac_sess = SaacRpc.getOrCreateSaacSession(rpcSess);
        ReferenceCounted<PrintWriter> log = saac_sess.setContextLogger();
        SmallMap env = new SmallMap();
        env.put("PARAM", rpcSess.get("PARAM"));
        env.put("SAAC_SESSION", saac_sess);
        Map INDEX = (Map)((SimpleRpcSession)req.getRpcSession()).get(SAAC_FUNCTION_SET_KEY);
        long t0 = System.currentTimeMillis();
        try {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"Saac execution starting", (Object[])new Object[0]);
            if (!SaacRpc.execute(INDEX, fs, (Map<String, Object>)env, log)) {
                throw new RuntimeException("The root element is not runnable.");
            }
        }
        catch (Throwable e) {
            Throwable t = e;
            while (t instanceof InvocationTargetException || t instanceof RuntimeException) {
                t = t.getCause();
            }
            LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)t, (String)"Saac execution exception:\n");
            if (null == t) {
                throw e;
            }
            Mirror.throwSoftOrHardButAnyway((Throwable)e);
        }
        finally {
            LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"Saac execution ended after %d ms", (Object)(System.currentTimeMillis() - t0));
        }
        return true;
    }

    public static boolean isAcceptable(Type targetType, Type sourceType) {
        Type[] ts;
        if (SaacRpc.isUnbounded(targetType)) {
            return true;
        }
        if (SaacRpc.isUnbounded(sourceType)) {
            return true;
        }
        if (targetType instanceof Class && sourceType instanceof Class) {
            return targetType == sourceType;
        }
        if (targetType instanceof ParameterizedType && sourceType instanceof ParameterizedType) {
            Type[] ta;
            ParameterizedType src = (ParameterizedType)sourceType;
            ParameterizedType target = (ParameterizedType)targetType;
            if (!SaacRpc.isAcceptable(target.getRawType(), src.getRawType())) {
                return false;
            }
            Type[] sa = src.getActualTypeArguments();
            if (sa.length != (ta = target.getActualTypeArguments()).length) {
                return false;
            }
            for (int i = 0; i < sa.length; ++i) {
                if (SaacRpc.isAcceptable(ta[i], sa[i])) continue;
                return false;
            }
            return true;
        }
        if (targetType instanceof GenericArrayType && sourceType instanceof GenericArrayType) {
            return SaacRpc.isAcceptable(((GenericArrayType)targetType).getGenericComponentType(), ((GenericArrayType)sourceType).getGenericComponentType());
        }
        if (targetType instanceof TypeVariable && (ts = ((TypeVariable)targetType).getBounds()).length == 1) {
            return SaacRpc.isAcceptable(ts[0], sourceType);
        }
        if (targetType instanceof ParameterizedType) {
            Type act = ((ParameterizedType)targetType).getRawType();
            return SaacRpc.isAcceptable(act, sourceType);
        }
        if (targetType instanceof WildcardType) {
            WildcardType wt = (WildcardType)targetType;
            Type[] b = null;
            b = wt.getLowerBounds();
            if (null != b) {
                for (Type t : b) {
                    if (SaacRpc.isAcceptable(t, sourceType)) continue;
                    return false;
                }
            }
            if (null != (b = wt.getUpperBounds())) {
                for (Type t : b) {
                    if (SaacRpc.isAcceptable(sourceType, t)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean isUnbounded(Type[] tt) {
        for (int i = 0; i < tt.length; ++i) {
            if (SaacRpc.isUnbounded(tt[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnbounded(Type t) {
        if (t instanceof Class) {
            return ((Class)t).isAssignableFrom(Object.class);
        }
        if (t instanceof ParameterizedType) {
            return SaacRpc.isUnbounded(((ParameterizedType)t).getRawType()) && SaacRpc.isUnbounded(((ParameterizedType)t).getActualTypeArguments());
        }
        if (t instanceof GenericArrayType) {
            return SaacRpc.isUnbounded(((GenericArrayType)t).getGenericComponentType());
        }
        if (t instanceof TypeVariable) {
            return SaacRpc.isUnbounded(((TypeVariable)t).getBounds());
        }
        if (t instanceof WildcardType) {
            if (!SaacRpc.isUnbounded(((WildcardType)t).getLowerBounds())) {
                return false;
            }
            return SaacRpc.isUnbounded(((WildcardType)t).getUpperBounds());
        }
        return false;
    }

    public static Map<String, Functions.PreparedFunction> getSessionFunctionSet(SimpleRpcSession sess) {
        Map ret = (Map)sess.get(SAAC_FUNCTION_SET_KEY);
        if (null == ret) {
            throw new RuntimeException("SAAC functionSet not set in the session. Use SaacRpc.setSessionFunctionSet to setup the session");
        }
        return ret;
    }

    public static void setSessionFunctionSet(SimpleRpcSession sess, Map<String, Functions.PreparedFunction> map) {
        sess.put(SAAC_FUNCTION_SET_KEY, map);
    }

    public static SaacSession getOrCreateSaacSession(SimpleRpcSession sess) {
        SaacSession saac_sess = (SaacSession)sess.get(SAAC_SESSION_KEY);
        if (null == saac_sess) {
            saac_sess = new SaacSession(sess);
            sess.put(SAAC_SESSION_KEY, (Object)saac_sess);
        }
        return saac_sess;
    }

    public static SaacEnv parse(Map<String, Functions.PreparedFunction> functions, DataObject data) {
        SaacEnv se = new SaacEnv(functions, null);
        se.parse(data);
        return se;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(SaacEnv se, Map<String, Object> env, ReferenceCounted<PrintWriter> LOGGER) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)LogLevel.INFO, (String)"Saac Parse started", (Object[])new Object[0]);
        SaacEnv.pushEnv(env);
        try {
            Object stage;
            if (null != LOGGER) {
                ThreadLocalHookableLogFacility.setLocalOutput(LOGGER);
            }
            if ((stage = se.root) instanceof SimpleCall) {
                ((SimpleCall)stage).call();
                boolean bl = true;
                return bl;
            }
            if (stage instanceof SimplePublish1) {
                ((SimplePublish1)stage).publish(env);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            SaacEnv.popEnv(env);
            if (null != LOGGER) {
                ThreadLocalHookableLogFacility.setLocalOutput(null);
            }
        }
        return false;
    }

    public static boolean execute(Map<String, Functions.PreparedFunction> functions, DataObject data, Map<String, Object> env, ReferenceCounted<PrintWriter> LOGGER) {
        return SaacRpc.execute(SaacRpc.parse(functions, data), env, LOGGER);
    }

    protected static class _enum {
        public String name;
        public int ordinal;
        public String enumClass;

        public _enum(Enum e) {
            this.name = e.name();
            this.ordinal = e.ordinal();
            this.enumClass = e.getClass().getName();
        }
    }

    public static class FunctionDescriptor {
        public static FunctionDescriptor[] emptyFuncArray = new FunctionDescriptor[0];
        public String id;
        public String name;
        public String description;
        public Functions.Param returning;
        public Functions.Param[] arguments;

        public FunctionDescriptor(FunctionCreator cre) {
            this.name = cre.getName();
            this.description = cre.getDescription();
        }

        public FunctionDescriptor(Functions.PreparedFunction f) {
            this.id = f.getMethod().getDeclaringClass().getName() + "." + f.getMethod().getName();
            this.name = f.getName();
            this.description = f.getDescription();
            this.returning = f.getReturning();
            this.arguments = f.getArgs();
        }

        public String toString() {
            return "FunctionDescriptor: " + this.id;
        }
    }
}

