/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.saac;

import eu.javaexperience.annotation.FunctionDescription;
import eu.javaexperience.annotation.FunctionVariableDescription;
import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.collection.PublisherCollection;
import eu.javaexperience.collection.map.MapTools;
import eu.javaexperience.datareprez.DataAccessor;
import eu.javaexperience.datareprez.DataAccessorTools;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.PropertyAccessTools;
import eu.javaexperience.datareprez.WellKnownDataAccessors;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.io.IOTools;
import eu.javaexperience.io.file.FileTools;
import eu.javaexperience.log.ExtraLogLevel;
import eu.javaexperience.log.JavaExperienceLoggingFacility;
import eu.javaexperience.log.LogLevel;
import eu.javaexperience.log.Loggable;
import eu.javaexperience.log.LoggableUnitDescriptor;
import eu.javaexperience.log.Logger;
import eu.javaexperience.log.LoggingDetailLevel;
import eu.javaexperience.log.LoggingTools;
import eu.javaexperience.patterns.behavioral.cor.CorChain;
import eu.javaexperience.patterns.behavioral.cor.link.CorChainLink;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.saac.SaacEnv;
import eu.javaexperience.saac.SaacSession;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class SaacFunctions {
    protected static final Logger LOG = JavaExperienceLoggingFacility.getLogger((LoggableUnitDescriptor)new Loggable("SaacFunctions", (LoggingDetailLevel)LogLevel.INFO));

    @FunctionDescription(functionDescription="Az \u00fatvonalat v\u00e9gigkeresve, a glob kifejez\u00e9sre illeszked\u0151 modulokat bet\u00f6lti, burkolja ha az meg lett adva.", parameters={@FunctionVariableDescription(description="Keres\u00e9si \u00fatvonal", mayNull=false, paramName="searchPath", type=Object.class), @FunctionVariableDescription(description="Kifejez\u00e9s", mayNull=false, paramName="glob", type=Object.class), @FunctionVariableDescription(description="Illeszt\u00e9s relat\u00edv \u00fatvonalk\u00e9nt", mayNull=false, paramName="relativeGlob", type=Object.class), @FunctionVariableDescription(description="Burkol\u00f3", mayNull=false, paramName="wrapper", type=Object.class)}, returning=@FunctionVariableDescription(description="Bet\u00f6lt\u0151 m\u0171velet", mayNull=false, paramName="", type=Object.class))
    public static <T> T[] loadUnitsGlob(String startDir, String glob, boolean relativeGlob, final GetBy2<T, String, Object> wrapper) throws IOException {
        final ArrayList ret = new ArrayList();
        FileTools.globFiles((Collection)new PublisherCollection<File>(){

            public boolean add(File obj) {
                try {
                    String str = IOTools.getFileContents((File)obj);
                    SaacEnv env = SaacEnv.create(null, (DataObject)new DataObjectJsonImpl(new JSONObject(str)), null);
                    Object add = env.root;
                    if (null != wrapper) {
                        add = wrapper.getBy((Object)obj.toString(), add);
                    }
                    ret.add(add);
                }
                catch (Exception e) {
                    LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Error during loadUnitsGlob: file: %s", (Object)obj);
                }
                return true;
            }
        }, (File)new File(startDir), (boolean)relativeGlob, (String)glob);
        return ret.toArray();
    }

    public static <R, A, B> GetBy2<R, A, B> wrap_f2(String p1Name, String p2Name, final SimpleGet<R> process) {
        return new GetBy2<R, A, B>(){

            public R getBy(A a, B b) {
                return process.get();
            }
        };
    }

    protected static Object loadScriptRoot(String file) throws FileNotFoundException, IOException {
        String str = IOTools.getFileContents((String)file);
        SaacEnv env = SaacEnv.create(null, (DataObject)new DataObjectJsonImpl(new JSONObject(str)), null);
        return env.root;
    }

    protected static void assertNotRuntimeClosure(Object ret) {
        if (ret instanceof SaacEnv.SaacClosureInfo) {
            throw new RuntimeException("Closure is wrapped for runtime execution");
        }
    }

    protected static void assertTypeOf(Type t, Object ret) {
        if (!(ret instanceof GetBy1)) {
            throw new RuntimeException("Wrong root type in the script file: " + t.getTypeName() + " required, " + ret.getClass().getTypeName() + " given");
        }
    }

    protected static <T> GetBy1<Boolean, T> loadScriptFile(String file) {
        try {
            Object ret = SaacFunctions.loadScriptRoot(file);
            SaacFunctions.assertNotRuntimeClosure(ret);
            SaacFunctions.assertTypeOf(GetBy1.class, ret);
            return (GetBy1)ret;
        }
        catch (Exception e) {
            LoggingTools.tryLogFormatException((Logger)LOG, (LoggingDetailLevel)LogLevel.ERROR, (Throwable)e, (String)"Can't parse script file: %s\n", (Object)file);
            Mirror.propagateAnyway((Throwable)e);
            return null;
        }
    }

    protected static <T> void addLinksToChain(CorChain<T> cc, Object o) {
        if (null == o) {
            return;
        }
        if (o instanceof CorChainLink) {
            cc.addLink((CorChainLink)o);
        } else if (o.getClass().isArray()) {
            for (Object c : (Object[])o) {
                SaacFunctions.addLinksToChain(cc, c);
            }
        } else {
            throw new RuntimeException("Given object is not a chain link: chain:" + cc.getChainName() + ", link: " + o);
        }
    }

    public static <T> GetBy1<Boolean, T> wrapLocation(final GetBy1<Boolean, T> func, final String file) {
        return new GetBy1<Boolean, T>(){

            public Boolean getBy(T a) {
                try {
                    return (Boolean)func.getBy(a);
                }
                catch (Exception e) {
                    throw new RuntimeException("Exception ocurred in an included file: " + file, e);
                }
            }
        };
    }

    public static <T> T[] array(T ... elems) {
        return elems;
    }

    public static void log(Object o) {
        LoggingTools.tryLogFormat((Logger)LOG, (LoggingDetailLevel)ExtraLogLevel.USER, (String)"log: %s", (Object)o);
    }

    public static <K extends Comparable<K>, V> List<Map.Entry<K, V>> mapSortByKeys(Map<K, V> map) {
        return MapTools.sortByKeys(map);
    }

    public static <K, V extends Comparable<V>> List<Map.Entry<K, V>> mapSortByValues(Map<K, V> map) {
        return MapTools.sortByValues(map);
    }

    public static <T> String collectionToMultilineString(Collection<T> coll) {
        return CollectionTools.toStringMultiline(coll);
    }

    public static Object propGet(String path) {
        Map<String, Object> env = SaacEnv.getCurrentEnv();
        if (null != env) {
            Map access = PropertyAccessTools.dotAccessWrap((Map)DataAccessorTools.mixedAccessWrap(env, (DataAccessor[])new DataAccessor[]{WellKnownDataAccessors.ARRAY, WellKnownDataAccessors.LIST, WellKnownDataAccessors.MAP, WellKnownDataAccessors.OBJECT_PUBLIC_FIELDS}));
            return access.get(path);
        }
        return null;
    }

    @FunctionDescription(functionDescription="A jelenlegi Saac session-nek kisz\u00e1ll\u00edt egy javascript k\u00e9r\u00e9st.", parameters={@FunctionVariableDescription(description="Kliens oldalon a this neve", mayNull=false, paramName="thisName", type=Object.class), @FunctionVariableDescription(description="F\u00fcggv\u00e9ny neve", mayNull=false, paramName="function", type=Object.class), @FunctionVariableDescription(description="Params", mayNull=false, paramName="A f\u00fcggv\u00e9ny param\u00e9terei", type=Object.class)}, returning=@FunctionVariableDescription(description="Bet\u00f6lt\u0151 m\u0171velet", mayNull=false, paramName="", type=Object.class))
    public static void tryDispatchAsyncServerEvent(String _this, String function, Object ... args) {
        Map<String, Object> env = SaacEnv.getCurrentEnv();
        try {
            SaacSession ss = (SaacSession)env.get("SAAC_SESSION");
            ss.sendServerEvent(_this, function, args);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void forceRuntime(SimplePublish1<Map<String, Object>> ... runs) {
        Map<String, Object> env = SaacEnv.getCurrentEnv();
        for (SimplePublish1<Map<String, Object>> run : runs) {
            if (null == run) continue;
            run.publish(env);
        }
    }

    public static Object loadFunctionFile(String file) throws FileNotFoundException, IOException {
        return SaacFunctions.loadScriptRoot(file);
    }

    public static interface ModGet2<R, A, B>
    extends GetBy2<R, A, B>,
    SaacEnv.EnvAdapter {
    }
}

