/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.saac;

import eu.javaexperience.collection.iterator.IteratorTools;
import eu.javaexperience.collection.map.NullMap;
import eu.javaexperience.collection.map.OneShotMap;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.DataSender;
import eu.javaexperience.datareprez.convertFrom.DataWrapper;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.dispatch.Dispatcher;
import eu.javaexperience.functional.saac.Functions;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.patterns.behavioral.cor.CorDispatcher;
import eu.javaexperience.patterns.behavioral.cor.link.CorChainLink;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.RpcFacility;
import eu.javaexperience.rpc.RpcFunction;
import eu.javaexperience.rpc.RpcRequest;
import eu.javaexperience.rpc.RpcSession;
import eu.javaexperience.rpc.SimpleRpcRequest;
import eu.javaexperience.rpc.SimpleRpcSession;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcDefaultProtocol;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcProtocolHandler;
import eu.javaexperience.rpc.codegen.JavascriptRpcSourceGenerator;
import eu.javaexperience.rpc.http.RpcHttpTools;
import eu.javaexperience.saac.SaacRpc;
import eu.javaexperience.saac.SaacWebTools;
import eu.javaexperience.semantic.references.MayNull;
import eu.javaexperience.text.StringFunctions;
import eu.javaexperience.url.UrlPart;
import eu.javaexperience.web.Context;
import eu.javaexperience.web.dispatch.WebDispatchTools;
import eu.javaexperience.web.dispatch.url.URLNodePattern;
import eu.javaexperience.web.dispatch.url.UrlNodePatternTools;
import eu.javaexperience.web.features.WebSocket;
import eu.javaexperience.web.features.WebSocketEndpoint;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import org.json.JSONObject;

public class SaacServerUnit {
    public static final DataWrapper reflectTypeDataWrapper = new DataWrapper(){

        public DataCommon wrap(DataWrapper topWrapper, DataCommon prototype, Object o) {
            if (o instanceof Type) {
                DataObject ret = prototype.newObjectInstance();
                ret.putString("toString", o.toString());
                if (o instanceof Class) {
                    ret.putString("type", "class");
                    ret.putString("class", ((Class)o).getSimpleName());
                } else if (o instanceof GenericArrayType) {
                    GenericArrayType gat = (GenericArrayType)o;
                    ret.putString("type", "genericArray");
                    ret.putObject("genericComponentType", (DataObject)topWrapper.wrap(topWrapper, prototype, (Object)gat.getGenericComponentType()));
                } else if (o instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)o;
                    ret.putString("type", "parameterized");
                    ret.putArray("actualTypeArguments", (DataArray)topWrapper.wrap(topWrapper, prototype, (Object)pt.getActualTypeArguments()));
                    ret.putObject("rawType", (DataObject)this.wrap(topWrapper, prototype, pt.getRawType()));
                } else if (o instanceof TypeVariable) {
                    TypeVariable tv = (TypeVariable)o;
                    ret.putString("type", "typeVariable");
                    ret.putArray("bounds", (DataArray)topWrapper.wrap(topWrapper, prototype, (Object)tv.getBounds()));
                    ret.putString("name", tv.getName());
                } else if (o instanceof WildcardType) {
                    WildcardType wt = (WildcardType)o;
                    ret.putString("type", "wildcard");
                    ret.putArray("lowerBounds", (DataArray)topWrapper.wrap(topWrapper, prototype, (Object)wt.getLowerBounds()));
                    ret.putArray("upperBounds", (DataArray)topWrapper.wrap(topWrapper, prototype, (Object)wt.getUpperBounds()));
                }
                return ret;
            }
            return null;
        }
    };
    public static final BidirectionalRpcProtocolHandler<SimpleRpcSession> DEFAULT_PROTOCOL = new BidirectionalRpcDefaultProtocol((DataCommon)new DataObjectJsonImpl(), DataReprezTools.combineWrappers((DataWrapper[])new DataWrapper[]{reflectTypeDataWrapper, DataReprezTools.WRAP_ARRAY_COLLECTION_MAP, DataReprezTools.WRAP_DATA_LIKE, DataReprezTools.createClassInstanceWrapper((Mirror.FieldSelector)new Mirror.FieldSelector(true, Mirror.Visibility.Public, Mirror.BelongTo.Instance, Mirror.Select.All, Mirror.Select.IsNot, Mirror.Select.All))}));
    protected final String apiName;
    protected final Map<String, Functions.PreparedFunction> saacFunctions;
    protected final BidirectionalRpcProtocolHandler<SimpleRpcSession> protocol;
    public final GetBy1<SimpleRpcSession, Context> GET_SESSION = new GetBy1<SimpleRpcSession, Context>(){

        public SimpleRpcSession getBy(Context a) {
            return SaacServerUnit.this.sessionStart(null);
        }
    };

    public static SaacServerUnit create(String apiName, Iterable<Class<?>> clss) {
        ArrayList<Functions.PreparedFunction> funcs = new ArrayList<Functions.PreparedFunction>();
        for (Class<?> cls : clss) {
            Functions.collectFunctions(funcs, cls);
        }
        HashMap<String, Functions.PreparedFunction> pf = new HashMap<String, Functions.PreparedFunction>();
        for (Functions.PreparedFunction f : funcs) {
            pf.put(f.getId(), f);
        }
        return new SaacServerUnit(apiName, pf);
    }

    public static SaacServerUnit create(String apiName, Class<?> ... clss) {
        return SaacServerUnit.create(apiName, IteratorTools.asList((Object[])clss));
    }

    public SaacServerUnit(String apiName, Map<String, Functions.PreparedFunction> funcs) {
        this.protocol = DEFAULT_PROTOCOL;
        this.apiName = apiName;
        this.saacFunctions = Collections.unmodifiableMap(new HashMap<String, Functions.PreparedFunction>(funcs));
    }

    public Map<String, Functions.PreparedFunction> getFunctions() {
        return this.saacFunctions;
    }

    public String getJsApiCall(boolean async) {
        return JavascriptRpcSourceGenerator.BASIC_JAVASCRIPT_SOURCE_BUILDER.buildRpcClientSource("SaacApi", SaacRpc.DISPATCH.getWrappedMethods(), (Map)(async ? new OneShotMap((Object)"using_callback_return", (Object)"true") : NullMap.instance));
    }

    public SimpleRpcSession sessionStart(@MayNull WebSocket ws) {
        SimpleRpcSession session = new SimpleRpcSession(this.protocol);
        SaacRpc.setSessionFunctionSet(session, this.saacFunctions);
        if (null != ws) {
            session.put("SEND", (Object)ws);
        }
        session.put("PROTOCOL", this.protocol);
        return session;
    }

    public void sessionStart(SimpleRpcSession session, @MayNull WebSocket ws) {
        SaacRpc.setSessionFunctionSet(session, this.saacFunctions);
        if (null != ws) {
            session.put("SEND", (Object)ws);
        }
        session.put("PROTOCOL", this.protocol);
    }

    public void serveRestCall(Context ctx) throws IOException {
        RpcHttpTools.serveRpcAjaxRequest((Context)ctx, (GetBy2)RpcHttpTools.WRAP_SIMPLE_RPC_REQUEST, this.GET_SESSION, this.protocol, SaacRpc.DISPATCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleWebSocket(Context ctx) throws NoSuchAlgorithmException, IOException {
        WebSocket ws = WebSocketEndpoint.upgradeRequest((Context)ctx);
        SimpleRpcSession session = this.sessionStart(ws);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataSender ds = this.protocol.getDefaultCommunicationProtocolPrototype().newDataSender((OutputStream)baos);
        while (true) {
            String get = null;
            try {
                baos.reset();
                get = null;
                byte[] rec = ws.receive();
                get = new String(rec);
                DataObjectJsonImpl rpcReq = new DataObjectJsonImpl(new JSONObject(get));
                ds.send(SaacRpc.DISPATCH.dispatch((RpcRequest)new SimpleRpcRequest((RpcSession)session, (DataObject)rpcReq)));
                continue;
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
                continue;
            }
            finally {
                ws.send(baos.toByteArray());
                continue;
            }
            break;
        }
    }

    public Dispatcher<Context> generateApiAjaxDispatcher() {
        return new Dispatcher<Context>(){

            public boolean dispatch(Context ctx) {
                try {
                    SaacServerUnit.this.serveRestCall(ctx);
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
                ctx.finishOperation();
                return true;
            }
        };
    }

    public Dispatcher<Context> generateApiWebsocketDispatcher() {
        return new Dispatcher<Context>(){

            public boolean dispatch(Context ctx) {
                try {
                    SaacServerUnit.this.handleWebSocket(ctx);
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
                ctx.finishOperation();
                return false;
            }
        };
    }

    public void registerApiDispacher(CorDispatcher<Context> dds, String chain, String restPath, String websocketPath) {
        dds.getChainByName(chain).addLink(WebDispatchTools.exactPath((URLNodePattern)UrlNodePatternTools.assemble((GetBy1)UrlPart.PATH, (GetBy1)StringFunctions.isEquals((String)restPath)), this.generateApiAjaxDispatcher()));
        dds.getChainByName(chain).addLink(WebDispatchTools.exactPath((URLNodePattern)UrlNodePatternTools.assemble((GetBy1)UrlPart.PATH, (GetBy1)StringFunctions.isEquals((String)websocketPath)), this.generateApiWebsocketDispatcher()));
    }

    public static void registerSaveDispatch(CorDispatcher<Context> dispatcher, String chain, File rootDir, final String getPath, final String savePath) throws IOException {
        final Dispatcher<Context> SAVE_RESTORE = SaacWebTools.createSaveRestoreDispatcher(rootDir);
        dispatcher.getChainByName(chain).addLink((CorChainLink)WebDispatchTools.createWith((Dispatcher[])new Dispatcher[]{new Dispatcher<Context>(){

            public boolean dispatch(Context ctx) {
                if (getPath.equals(ctx.getRequestUrl().getPath())) {
                    SAVE_RESTORE.dispatch((Object)ctx);
                }
                if (savePath.equals(ctx.getRequestUrl().getPath())) {
                    SAVE_RESTORE.dispatch((Object)ctx);
                }
                return false;
            }
        }}));
    }

    public Dispatcher<Context> generateSourceApiDispatcher() {
        final byte[] RPC_SORUCE = this.getJsApiCall(true).getBytes();
        return new Dispatcher<Context>(){

            public boolean dispatch(Context ctx) {
                try {
                    ctx.getResponse().setContentType("text/javascript");
                    ServletOutputStream os = ctx.getResponse().getOutputStream();
                    os.write(RPC_SORUCE);
                    os.flush();
                }
                catch (Exception e) {
                    Mirror.propagateAnyway((Throwable)e);
                }
                ctx.finishOperation();
                return true;
            }
        };
    }

    public void registerApiSourceJs(CorDispatcher<Context> dispatcher, String chain, String path) {
        dispatcher.getChainByName(chain).addLink(WebDispatchTools.exactPath((URLNodePattern)UrlNodePatternTools.assemble((GetBy1)UrlPart.PATH, (GetBy1)StringFunctions.isEquals((String)path)), this.generateSourceApiDispatcher()));
    }

    public void registerFullstack(CorDispatcher<Context> dispatcher, String chain, String apiSourcePath, String restPath, String websocketPath) {
        this.registerApiSourceJs(dispatcher, "static", apiSourcePath);
        this.registerApiDispacher(dispatcher, "static", restPath, websocketPath);
    }

    public RpcFacility<SimpleRpcRequest> getApi() {
        return new RpcFacility<SimpleRpcRequest>(){

            public DataObject getBy(SimpleRpcRequest a) {
                return this.dispatch(a);
            }

            public String getRpcName() {
                return SaacServerUnit.this.apiName;
            }

            public DataObject dispatch(SimpleRpcRequest req) {
                ((SimpleRpcSession)req.getRpcSession()).setProtocolHandler(DEFAULT_PROTOCOL);
                SaacServerUnit.this.sessionStart((SimpleRpcSession)req.getRpcSession(), null);
                return SaacRpc.DISPATCH.dispatch((RpcRequest)req);
            }

            public Collection<? extends RpcFunction<SimpleRpcRequest, ?>> getWrappedFunctions() {
                return SaacRpc.DISPATCH.getWrappedFunctions();
            }
        };
    }
}

