/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.functional.saac;

import eu.javaexperience.annotation.FunctionDescription;
import eu.javaexperience.annotation.FunctionVariableDescription;
import eu.javaexperience.arrays.ArrayTools;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.DataReprezTools;
import eu.javaexperience.datareprez.convertFrom.DataWrapper;
import eu.javaexperience.datareprez.jsonImpl.DataObjectJsonImpl;
import eu.javaexperience.functional.saac.AutocompleteProvider;
import eu.javaexperience.generic.annotations.Ignore;
import eu.javaexperience.interfaces.ObjectWithProperty;
import eu.javaexperience.interfaces.ObjectWithPropertyStorage;
import eu.javaexperience.interfaces.simple.SimpleCall;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.getBy.GetBy3;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.rpc.bidirectional.BidirectionalRpcDefaultProtocol;
import eu.javaexperience.saac.SaacIgnore;
import eu.javaexperience.saac.SaacServerUnit;
import eu.javaexperience.text.StringTools;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;

public class Functions {
    public static final DataWrapper TYPE_SERIALIZER = DataReprezTools.combineWrappers((DataWrapper[])new DataWrapper[]{SaacServerUnit.reflectTypeDataWrapper, BidirectionalRpcDefaultProtocol.DEFAULT_RPC_DATA_WRAPPER_WITH_CLASS});
    protected static final Collection<Class<?>> FUNCTION_CLASS = new ArrayList();

    protected static DataObject serializeType(Type t) {
        return (DataObject)TYPE_SERIALIZER.wrap(TYPE_SERIALIZER, DataObjectJsonImpl.instane, (Object)t);
    }

    public static void collectFunctions(Collection<PreparedFunction> funcs, Class cls) {
        int req_mod = 9;
        for (Method m : cls.getMethods()) {
            int mod;
            if (0 != ((SaacIgnore[])m.getAnnotationsByType(SaacIgnore.class)).length || 0 != ((Ignore[])m.getAnnotationsByType(Ignore.class)).length || ((mod = m.getModifiers()) & 9) != 9) continue;
            funcs.add(new PreparedFunction(m));
        }
    }

    static {
        FUNCTION_CLASS.add(SimpleGet.class);
        FUNCTION_CLASS.add(SimplePublish1.class);
        FUNCTION_CLASS.add(SimpleCall.class);
        FUNCTION_CLASS.add(GetBy1.class);
        FUNCTION_CLASS.add(GetBy2.class);
        FUNCTION_CLASS.add(GetBy3.class);
    }

    public static class PreparedFunction {
        protected Method m;
        protected String id;
        protected String name;
        protected String description;
        protected Param returning;
        protected Param[] args;

        public PreparedFunction(Method m) {
            try {
                this.m = m;
                this.id = m.getDeclaringClass().getName() + "." + m.getName();
                this.description = this.name = StringTools.getSubstringAfterLastString((String)m.getName(), (String)".");
                FunctionDescription d = m.getAnnotation(FunctionDescription.class);
                if (null != d) {
                    this.description = d.functionDescription();
                }
                this.returning = new Param(m.getAnnotatedReturnType(), d);
                this.args = Param.wrap(m.getParameters(), d);
            }
            catch (Exception e) {
                throw new RuntimeException("Error in FunctionDescription: " + m + "");
            }
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Param getReturning() {
            return this.returning;
        }

        public Param[] getArgs() {
            return (Param[])ArrayTools.copy((Object[])this.args);
        }

        public Method getMethod() {
            return this.m;
        }

        public Object create(Object ... arguments) {
            try {
                return this.m.invoke(null, arguments);
            }
            catch (Exception e) {
                Mirror.propagateAnyway((Throwable)e);
                return null;
            }
        }

        public String getId() {
            return this.id;
        }

        public String toString() {
            return "PreparedFunction: " + this.m;
        }
    }

    public static class Param
    implements ObjectWithProperty {
        protected String name;
        protected Type type;
        protected String description;
        public static final Param[] emptyParamArray = new Param[0];
        protected static ObjectWithPropertyStorage<Param> PROPS = new ObjectWithPropertyStorage();

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Type getType() {
            return this.type;
        }

        public Param(Parameter at, FunctionDescription d, int i) {
            this.name = at.getName();
            this.type = at.getParameterizedType();
            this.description = this.name;
            if (null != d) {
                try {
                    FunctionVariableDescription pd;
                    Object[] pds = d.parameters();
                    if (null != pds && null != (pd = (FunctionVariableDescription)ArrayTools.accessIndexSafe((Object[])pds, (int)i))) {
                        this.name = pd.paramName();
                        this.description = pd.description();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error in FunctionVariableDescription at parameter index: " + i);
                }
            }
        }

        public Param(AnnotatedType annotatedReturnType, FunctionDescription d) {
            this.name = "ret";
            this.type = annotatedReturnType.getType();
            this.description = "return";
            if (null != d) {
                FunctionVariableDescription f = d.returning();
                this.name = f.paramName();
                this.description = f.description();
            }
        }

        public static Param[] wrap(Parameter[] params, FunctionDescription d) {
            ArrayList<Param> ret = new ArrayList<Param>();
            int i = 0;
            for (Parameter p : params) {
                ret.add(new Param(p, d, i++));
            }
            return ret.toArray(emptyParamArray);
        }

        public AutocompleteProvider getAutocompleteProvider() {
            return null;
        }

        public Object get(String key) {
            return PROPS.get((Object)this, key);
        }

        public String[] keys() {
            return PROPS.keys();
        }

        static {
            PROPS.addExaminer("name", e -> e.name);
            PROPS.addExaminer("description", e -> e.description);
            PROPS.addExaminer("type", e -> Functions.serializeType(e.type));
        }
    }
}

