/*
 * Decompiled with CFR 0.152.
 */
package eu.javaexperience.saac;

import eu.javaexperience.collection.enumerations.EnumTools;
import eu.javaexperience.datareprez.DataArray;
import eu.javaexperience.datareprez.DataCommon;
import eu.javaexperience.datareprez.DataObject;
import eu.javaexperience.datareprez.convertFrom.DataLike;
import eu.javaexperience.exceptions.UnimplementedCaseException;
import eu.javaexperience.functional.saac.Functions;
import eu.javaexperience.interfaces.simple.SimpleGet;
import eu.javaexperience.interfaces.simple.getBy.GetBy1;
import eu.javaexperience.interfaces.simple.getBy.GetBy2;
import eu.javaexperience.interfaces.simple.publish.SimplePublish1;
import eu.javaexperience.reflect.CastTo;
import eu.javaexperience.reflect.Mirror;
import eu.javaexperience.reflect.PrimitiveTools;
import eu.javaexperience.saac.exceptions.SaacFunctionCreationException;
import eu.javaexperience.text.StringTools;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class SaacEnv {
    protected Map<String, Functions.PreparedFunction> functionSet;
    protected Class<?> rootAcceptType;
    protected Map<Object, Object[]> path = new IdentityHashMap<Object, Object[]>();
    protected Object root;
    protected static ThreadLocal<Map<String, Functions.PreparedFunction>> THREAD_CONTEXT = new ThreadLocal();
    protected static ThreadLocal<Stack<Map<String, Object>>> ENV = new ThreadLocal<Stack<Map<String, Object>>>(){

        @Override
        protected Stack<Map<String, Object>> initialValue() {
            return new Stack<Map<String, Object>>();
        }
    };

    public SaacEnv(Map<String, Functions.PreparedFunction> functionSet, Class<?> accept) {
        this.functionSet = functionSet;
        this.rootAcceptType = accept;
    }

    protected static ContextFunctionSet getOrAccumulateProperFunctionSet(Map<String, Functions.PreparedFunction> functionSet) {
        if (null == functionSet) {
            Map<String, Functions.PreparedFunction> ret = THREAD_CONTEXT.get();
            if (null == ret) {
                throw new RuntimeException("There's no function set available for this context.");
            }
            return new ContextFunctionSet(ret, false);
        }
        if (null == THREAD_CONTEXT.get()) {
            THREAD_CONTEXT.set(functionSet);
            return new ContextFunctionSet(functionSet, true);
        }
        return new ContextFunctionSet(functionSet, false);
    }

    protected static void cleanupFunctionSet(ContextFunctionSet funcs) {
        if (null != funcs && funcs.master) {
            THREAD_CONTEXT.set(null);
        }
    }

    public static SaacEnv create(Map<String, Functions.PreparedFunction> functionSet, DataObject obj, Class<?> accept) {
        SaacEnv env = new SaacEnv(functionSet, accept);
        env.parse(obj);
        return env;
    }

    public void parse(DataObject obj) {
        ContextFunctionSet fset = SaacEnv.getOrAccumulateProperFunctionSet(this.functionSet);
        this.functionSet = fset.functionSet;
        try {
            this.root = this.parse(obj, this.rootAcceptType);
        }
        finally {
            SaacEnv.cleanupFunctionSet(fset);
        }
    }

    protected Object parse(DataObject obj, Type acceptType) {
        String content;
        Class accept = Mirror.extracClass((Type)acceptType);
        String id = SaacEnv.extractString(obj, "id");
        if (null != id) {
            boolean needWrap;
            Functions.PreparedFunction pp = this.functionSet.get(id);
            if (null == pp) {
                SaacFunctionCreationException ex = new SaacFunctionCreationException("Function doesn't exists: " + id);
                ex.functionName = id;
                throw ex;
            }
            DataArray args = obj.getArray("args");
            Object[] call = new Object[pp.getArgs().length];
            Functions.Param[] ps = pp.getArgs();
            boolean[] paramWraps = new boolean[pp.getArgs().length];
            boolean wrapRet = false;
            Class retClass = Mirror.extracClass((Type)pp.getReturning().getType());
            if (null != accept && null != retClass) {
                wrapRet = !Mirror.isVoid((Class)retClass) && !SimplePublish1.class.isAssignableFrom(accept);
            }
            ArrayList<Object> varargs = null;
            if (ps.length > 0 && Mirror.extracClass((Type)ps[ps.length - 1].getType()).isArray()) {
                varargs = new ArrayList<Object>();
            }
            for (int i = 0; i < call.length; ++i) {
                DataObject d;
                Class reqType;
                DataLike dc = (DataLike)args.get(i);
                int acc = i;
                if (null != varargs) {
                    acc = ps.length - 1;
                }
                if ((reqType = Mirror.extracClass((Type)ps[acc].getType())).isArray() && dc instanceof DataObject && !SaacEnv.isUseful((d = (DataObject)dc).opt("id")) && !SaacEnv.isUseful(d.opt("content"))) {
                    dc = d.getArray("args");
                }
                Object add = null;
                switch (dc.getDataReprezType()) {
                    case ARRAY: {
                        add = SaacEnv.parseArray(this.functionSet, (DataArray)dc, reqType.getComponentType());
                        break;
                    }
                    case OBJECT: 
                    case CLASS_OBJECT: 
                    case RESOURCE: {
                        add = SaacEnv.create(this.functionSet, (DataObject)((DataObject)dc), reqType).root;
                        break;
                    }
                    default: {
                        throw new UnimplementedCaseException((Enum)dc.getDataReprezType());
                    }
                }
                add = SaacEnv.postWrapFilter(reqType, add, null != varargs);
                if (null != varargs) {
                    if (i < ps.length - 1) continue;
                    varargs.add(add);
                    continue;
                }
                call[i] = add;
            }
            if (null != varargs) {
                if (varargs.size() == 1 && null != varargs.get(0) && Mirror.extracClass((Type)ps[ps.length - 1].getType()).isAssignableFrom(varargs.get(0).getClass())) {
                    call[ps.length - 1] = varargs.get(0);
                } else {
                    Class vr = Mirror.extracClass((Type)ps[ps.length - 1].getType());
                    Object[] as = SaacEnv.tryExtractAsRequested(vr, varargs);
                    call[ps.length - 1] = SaacEnv.postWrapFilter(vr, as, false);
                }
            }
            if (!(needWrap = false)) {
                for (int i = 0; i < paramWraps.length && !(needWrap |= paramWraps[i]); ++i) {
                }
            }
            if (needWrap && null != accept && !Mirror.isVoid((Class)accept)) {
                wrapRet = true;
            }
            if (needWrap) {
                return SaacEnv.wrapForRuntime(pp, wrapRet, paramWraps, call);
            }
            return pp.create(call);
        }
        if (null != accept && null != (content = SaacEnv.extractString(obj, "content"))) {
            if (accept.isEnum()) {
                return EnumTools.getByName((Class)accept, (String)content);
            }
            CastTo to = CastTo.getCasterRestrictlyForTargetClass((Class)accept);
            if (null != to) {
                return to.cast((Object)content);
            }
            if (content.startsWith("$")) {
                return new SaacGetByWrapper<Object, Map<String, Object>>(){

                    public Object getBy(Map<String, Object> a) {
                        return a.get(content);
                    }

                    public String toString() {
                        return "Scope getter: " + super.toString();
                    }

                    @Override
                    public Object[] getArgs() {
                        return new Object[]{content};
                    }
                };
            }
            return new SaacGetByWrapper<Object, Object>(){

                public Object getBy(Object a) {
                    return content;
                }

                public String toString() {
                    return "Scope getter: " + super.toString();
                }

                @Override
                public Object[] getArgs() {
                    return new Object[]{content};
                }
            };
        }
        return null;
    }

    public static Object[] tryExtractAsRequested(Class req, List obj) {
        try {
            return obj.toArray((Object[])Array.newInstance(req.getComponentType(), obj.size()));
        }
        catch (Exception e) {
            return obj.toArray();
        }
    }

    public static Object postWrapFilter(Class reqType, Object add, boolean insideOfVarargs) {
        block2: {
            Object o;
            block3: {
                boolean wrapParam;
                if (null == reqType || null == add) break block2;
                if (insideOfVarargs) {
                    reqType = reqType.getComponentType();
                }
                if (PrimitiveTools.isPrimitiveClass((Class)reqType)) {
                    reqType = PrimitiveTools.toObjectClassType(reqType, reqType);
                }
                boolean bl = wrapParam = !reqType.isAssignableFrom(add.getClass()) || SaacSimplePublishWrapper.class.isAssignableFrom(add.getClass());
                if (!wrapParam) break block2;
                o = SaacEnv.tryWrapSameOfArray(reqType, add);
                if (null == o) break block3;
                add = o;
                break block2;
            }
            o = SaacEnv.tryWrapConstantAsSourceFunction(reqType, add);
            if (null == o) break block2;
            add = o;
        }
        return add;
    }

    public static Object tryWrapSameOfArray(Class reqType, Object object) {
        Class<?> cls;
        if (reqType.isArray() && (cls = reqType.getComponentType()).isAssignableFrom(object.getClass())) {
            Object[] ret = (Object[])Array.newInstance(cls, 1);
            ret[0] = object;
            return ret;
        }
        return null;
    }

    public static Object tryWrapConstantAsSourceFunction(Type reqType, final Object value) {
        Class req = Mirror.extracClass((Type)reqType);
        if (req.isAssignableFrom(SimpleGet.class)) {
            return new SimpleGet(){

                public Object get() {
                    return value;
                }
            };
        }
        if (req.isAssignableFrom(GetBy1.class)) {
            return new GetBy1(){

                public Object getBy(Object o) {
                    return value;
                }
            };
        }
        if (req.isAssignableFrom(GetBy2.class)) {
            return new GetBy2(){

                public Object getBy(Object o, Object p) {
                    return value;
                }
            };
        }
        return null;
    }

    protected static boolean isUseful(Object o) {
        return null != o && !StringTools.isNullOrTrimEmpty((String)o.toString());
    }

    protected static <T> Object processArray(Functions.PreparedFunction pp, Functions.Param p, Object[] at, Map<String, Object> env) {
        Class<?> rt = Mirror.extracClass((Type)p.getType()).getComponentType();
        ArrayList<Object> ret = new ArrayList<Object>();
        boolean allFits = true;
        for (int i = 0; i < at.length; ++i) {
            Object add = SaacEnv.processSingleParam(pp, p, at[i], env);
            ret.add(add);
            if (null == add) continue;
            allFits &= rt.isAssignableFrom(add.getClass());
        }
        if (allFits) {
            return ret.toArray((Object[])Array.newInstance(rt, 0));
        }
        return ret.toArray();
    }

    protected static Object processSingleParam(Functions.PreparedFunction pp, Functions.Param p, Object at, Map<String, Object> env) {
        Class cls;
        if (null == at) {
            return null;
        }
        if (at instanceof EnvAdapter) {
            env = ((EnvAdapter)at).subEnv(env);
        }
        if ((cls = Mirror.extracClass((Type)p.getType())).isAssignableFrom(at.getClass())) {
            return at;
        }
        if (at instanceof SimpleGet) {
            at = ((SimpleGet)at).get();
        } else if (at instanceof GetBy1) {
            at = ((GetBy1)at).getBy(env);
        } else if (at instanceof SimplePublish1) {
            ((SimplePublish1)at).publish(env);
            at = null;
        }
        if (null == at) {
            return null;
        }
        if (at instanceof String) {
            String str = (String)at;
            if (cls.isEnum()) {
                return EnumTools.getByName((Class)cls, (String)str);
            }
            CastTo ct = CastTo.getCasterRestrictlyForTargetClass((Class)cls);
            if (null != ct) {
                return ct.cast((Object)str);
            }
            return env.get(str);
        }
        if (at.getClass().isArray()) {
            return SaacEnv.processArray(pp, p, (Object[])at, env);
        }
        return at;
    }

    protected static String extractString(DataObject obj, String key) {
        if (obj.has(key)) {
            Object o = obj.get(key);
            if (null == o) {
                return null;
            }
            String ret = null;
            if (o instanceof DataCommon) {
                byte[] b = ((DataCommon)o).toBlob();
                if (null != b) {
                    ret = new String(b);
                }
            } else {
                ret = o.toString();
            }
            if (!StringTools.isNullOrTrimEmpty((String)ret)) {
                return ret;
            }
        }
        return null;
    }

    protected static Object processArgs(Functions.PreparedFunction pp, boolean wrapRet, boolean[] paramWraps, Object[] args, Map<String, Object> env) {
        Object[] cre = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            cre[i] = !paramWraps[i] ? args[i] : SaacEnv.processSingleParam(pp, pp.getArgs()[i], args[i], env);
        }
        try {
            return pp.create(cre);
        }
        catch (Exception e) {
            SaacFunctionCreationException t = new SaacFunctionCreationException("Can't create function: " + pp.getName(), e);
            t.functionName = pp.getName();
            t.arguments = cre;
            t.function = pp;
            throw t;
        }
    }

    public static <T> Object wrapForRuntime(final Functions.PreparedFunction pp, final boolean wrapRet, final boolean[] paramWraps, final Object[] args) {
        if (wrapRet) {
            return new SaacGetByWrapper<Object, Map<String, Object>>(){

                public Object getBy(Map<String, Object> env) {
                    return SaacEnv.processArgs(pp, wrapRet, paramWraps, args, env);
                }

                public String toString() {
                    return "Runtime Scope getter (GetBy1): " + super.toString();
                }

                @Override
                public Object[] getArgs() {
                    return new Object[]{pp, wrapRet, paramWraps, args};
                }
            };
        }
        return new SaacSimplePublishWrapper<Map<String, Object>>(){

            public void publish(Map<String, Object> env) {
                SaacEnv.processArgs(pp, wrapRet, paramWraps, args, env);
            }

            public String toString() {
                return "Runtime Wrap (SimplePublish): " + super.toString();
            }

            @Override
            public Object[] getArgs() {
                return new Object[]{pp, wrapRet, paramWraps, args};
            }
        };
    }

    protected static <T> Object parseArray(Map<String, Functions.PreparedFunction> functionSet, DataArray arr, Class<?> accept) {
        int size = arr.size();
        ArrayList<Object> coll = new ArrayList<Object>();
        boolean allFits = true;
        for (int i = 0; i < size; ++i) {
            Object add = SaacEnv.create(functionSet, (DataObject)arr.getObject((int)i), accept).root;
            if (null != add) {
                allFits &= accept.isAssignableFrom(add.getClass());
            }
            coll.add(add);
        }
        if (allFits) {
            return coll.toArray((Object[])Array.newInstance(accept, 0));
        }
        return coll.toArray();
    }

    public static synchronized Map<String, Object> getCurrentEnv() {
        Stack<Map<String, Object>> stack = ENV.get();
        return stack.peek();
    }

    public static synchronized void pushEnv(Map<String, Object> env) {
        Stack<Map<String, Object>> stack = ENV.get();
        stack.push(env);
    }

    public static synchronized Map<String, Object> popEnv(Map<String, Object> env) {
        Stack<Map<String, Object>> stack = ENV.get();
        return stack.pop();
    }

    public Object getRoot() {
        return this.root;
    }

    protected static class ContextFunctionSet {
        protected Map<String, Functions.PreparedFunction> functionSet;
        protected boolean master = false;

        public ContextFunctionSet(Map<String, Functions.PreparedFunction> functionSet, boolean master) {
            this.functionSet = functionSet;
            this.master = false;
        }
    }

    public static interface SaacSimplePublishWrapper<R>
    extends SaacClosureInfo,
    SimplePublish1<R> {
    }

    public static interface SaacGetByWrapper<R, A>
    extends SaacClosureInfo,
    GetBy1<R, A> {
    }

    public static interface EnvAdapter {
        public Map<String, Object> subEnv(Map<String, Object> var1);
    }

    public static interface SaacClosureInfo {
        public Object[] getArgs();
    }
}

