package eu.javaexpereince.spider.selenium;

import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

import eu.javaexperience.collection.CollectionTools;
import eu.javaexperience.url.UrlBuilder;

public class SeleniumSpider extends AbstractSeleniumSpider
{
	protected String domain;
	
	public SeleniumSpider(String domain, Queue<String> urlsToVisit, Map<String, List<String>> pageLinks)
	{
		super(urlsToVisit, pageLinks);
		this.domain = domain;
	}

	@Override
	public boolean needWisit(String url)
	{
		return new UrlBuilder(url).getHost().endsWith(domain);
	}
	
	@Override
	public void selectUrls(Collection<String> dst, WebDriver wd)
	{
		try
		{
			URL url = null;
			WebElement base = querySelector(wd, "base");
			if(null != base)
			{
				url = new URL(base.getAttribute("href"));
			}
			
			if(null == url)
			{
				url = new URL(wd.getCurrentUrl());
			}
			
			List<WebElement> as = querySelectorAll(wd, "a");
			for(WebElement a:as)
			{
				try
				{
					String href = a.getAttribute("href");
					if(null != href)
					{
						href = getAbsPath(href, url);
						dst.add(href);
					}
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	public static WebElement querySelector(SearchContext elem, String selector)
	{
		try
		{
			return elem.findElement(By.cssSelector(selector));
		}
		catch(Exception e)
		{
			return null;
		}
	}
	
	public static List<WebElement> querySelectorAll(SearchContext elem, String selector)
	{
		try
		{
			return elem.findElements(By.cssSelector(selector));
		}
		catch(Exception e)
		{
			return null;
		}
	}
	
	public static String getAbsPath(String url,URL host)
	{
		try
		{
			url = url.trim();
			URL cim = new URL(url);
			//ha ez egy értlemes webcím akkor nincs path feloldás, azt az URL-t adjuk vissza (abba a domainba tartozót)
			if(!cim.getHost().equals(host.getHost()))
			{
				return url;
			}
			
			return url;
		}
		catch (MalformedURLException e)
		{
			if(url.startsWith("/"))// /sdfgasf -ek
			{
				String on = host.toString();
				int index = on.indexOf('/', 9);// https:// utáni / keresése: https://google.hu/ <=ez itten
				if(-1 != index)
				{
					on = on.substring(0, index);//van domain záró /, odáig levágom (/ nélkül)
				}
				return on+url;//a url-en van kezdő / jel mert itt a vezérlés
			}
			else
			{
				return host.getProtocol()+"://"+host.getHost()+relative(host.getPath(), url);
			}
		}
	}
	
	protected static void delPrev(String[] arr, int pos)
	{
		for(int i=pos-1;i>=0;i--)
		{
			if(null != arr[i])
			{
				arr[i] = null;
				return;
			}
		}
	}
	
	public static String relative(String path, String rel)
	{
		if("".equals(rel))
		{
			return "";
		}
		
		if(rel.startsWith("/"))// if relative url starts with / then it's from the root
		{
			return rel;
		}
		
		String[] ps = path.split("/");
		String[] re = rel.split("/");
		
		String[] build = new String[ps.length+re.length]; 
		
		if(!path.endsWith("/"))
		{
			ps[ps.length-1] = null;
		}
		
		for(int i=0;i<ps.length;++i)
		{
			build[i] = ps[i];
		}
		
		for(int i=0;i<re.length;++i)
		{
			build[ps.length+i] = re[i];
		}
		
		for(int i=0;i<build.length;++i)
		{
			String p = build[i];
			if(".".equals(p) || "".equals(p))
			{
				build[i] = null;
			}
			else if("..".equals(p))
			{
				build[i] = null;
				delPrev(build, i);
			}
		}
		
		StringBuilder sb = new StringBuilder();
		
		for(String s:build)
		{
			if(null != s)
			{
				sb.append("/");
				sb.append(s);
			}
		}
		
		return sb.toString();
	}
	
	protected static void examineCookies(Set<Cookie> dst, WebDriver driver)
	{
		/*String originalWindowHandle = driver.getWindowHandle();
		System.out.println("original Window handles are: " + originalWindowHandle);
		System.out.println("Title of original Page:" + driver.getTitle());  
		java.util.Set<java.lang.String> windowHandles = driver.getWindowHandles();
		System.out.println(windowHandles);
		int count = windowHandles.size();
		//if (count > 1) {
		for (String window: windowHandles)
		{
			if(!window.equals(originalWindowHandle))
			{
				driver.switchTo().window(window);
				String url = driver.getCurrentUrl();
				System.out.println("current url is: " + url);
				CollectionTools.copyInto(driver.manage().getCookies(), dst);
			}
		}
		//to go back to original
		driver.switchTo().window(originalWindowHandle);*/
		
		CollectionTools.copyInto(driver.manage().getCookies(), dst);
	}
	
	public static void discoverSite(WebDriver wd, String storage, String rootDomain) throws FileNotFoundException
	{
		final SeleniumSpiderFileStorage ssfs = new SeleniumSpiderFileStorage(storage);
		
		SeleniumSpider sp = new SeleniumSpider(rootDomain, ssfs.pendingLinks, ssfs.linkMap)
		{
			@Override
			public void sniffPage(String link, WebDriver wd)
			{
				super.sniffPage(link, wd);
				System.out.println(link);
				ssfs.getPagesMap().put(link, wd.findElement(By.cssSelector("html")).getAttribute("outerHTML").getBytes());
				/*Set<Cookie> cookie = new HashSet<Cookie>();
				examineCookies(cookie, wd);
				ssfs.pageAttributes.put(link, cookie);
				System.out.println(link);
				for(Cookie c:cookie)
				{
					System.out.println("\t"+c);
				}
				System.out.println();*/
			}
			
			@Override
			public boolean needWisit(String url)
			{
				if(url.contains("?referer="))
				{
					return false;
				}
				return super.needWisit(url);
			}
		};

		if(ssfs.getPendingUrlsQueue().isEmpty())
		{
			sp.addPage("http://"+rootDomain);
		}
		
		sp.continueCrawling(wd);
	}

	
}
